/*
 * Decompiled with CFR 0.152.
 */
package swim.service.web;

import java.net.InetSocketAddress;
import swim.api.service.Service;
import swim.api.service.ServiceContext;
import swim.io.IpService;
import swim.io.IpServiceRef;
import swim.io.IpSettings;
import swim.io.IpSocket;
import swim.io.IpSocketRef;
import swim.io.http.HttpInterface;
import swim.io.http.HttpServer;
import swim.io.http.HttpService;
import swim.io.http.HttpServiceContext;
import swim.io.http.HttpSettings;
import swim.io.warp.WarpSettings;
import swim.kernel.KernelContext;
import swim.service.web.WebServer;
import swim.service.web.WebServiceDef;
import swim.web.WebRoute;

public class WebService
implements Service,
HttpService,
HttpInterface {
    final KernelContext kernel;
    final ServiceContext serviceContext;
    final WebServiceDef serviceDef;
    WebRoute router;
    HttpServiceContext httpServiceContext;

    public WebService(KernelContext kernel, ServiceContext serviceContext, WebServiceDef serviceDef, WebRoute router) {
        this.kernel = kernel;
        this.serviceContext = serviceContext;
        this.serviceDef = serviceDef;
        this.router = router;
        this.httpServiceContext = null;
    }

    public final KernelContext kernel() {
        return this.kernel;
    }

    public final ServiceContext serviceContext() {
        return this.serviceContext;
    }

    public final HttpServiceContext httpServiceContext() {
        return this.httpServiceContext;
    }

    public void setHttpServiceContext(HttpServiceContext httpServiceContext) {
        this.httpServiceContext = httpServiceContext;
    }

    public final WebServiceDef serviceDef() {
        return this.serviceDef;
    }

    public final WebRoute router() {
        return this.router;
    }

    public WebService router(WebRoute router) {
        this.router = router;
        return this;
    }

    public final IpSettings ipSettings() {
        return this.serviceDef.warpSettings.ipSettings();
    }

    public final HttpSettings httpSettings() {
        return this.serviceDef.warpSettings.httpSettings();
    }

    public final WarpSettings warpSettings() {
        return this.serviceDef.warpSettings;
    }

    public IpServiceRef bindTcp(InetSocketAddress localAddress, IpService service, IpSettings ipSettings) {
        return this.serviceContext.bindTcp(localAddress, service, ipSettings);
    }

    public IpServiceRef bindTls(InetSocketAddress localAddress, IpService service, IpSettings ipSettings) {
        return this.serviceContext.bindTls(localAddress, service, ipSettings);
    }

    public IpSocketRef connectTcp(InetSocketAddress remoteAddress, IpSocket socket, IpSettings ipSettings) {
        return this.serviceContext.connectTcp(remoteAddress, socket, ipSettings);
    }

    public IpSocketRef connectTls(InetSocketAddress remoteAddress, IpSocket socket, IpSettings ipSettings) {
        return this.serviceContext.connectTls(remoteAddress, socket, ipSettings);
    }

    public HttpServer createServer() {
        return new WebServer(this.kernel, this.serviceDef, this.router);
    }

    public void willStart() {
    }

    public void didStart() {
        WebServiceDef serviceDef = this.serviceDef;
        if (serviceDef.isSecure) {
            this.bindHttps(serviceDef.address, serviceDef.port, this, serviceDef.warpSettings.httpSettings());
        } else {
            this.bindHttp(serviceDef.address, serviceDef.port, this, serviceDef.warpSettings.httpSettings());
        }
    }

    public void didBind() {
    }

    public void didAccept(HttpServer server) {
    }

    public void didUnbind() {
    }

    public void willStop() {
        HttpServiceContext httpServiceContext = this.httpServiceContext;
        if (httpServiceContext != null) {
            httpServiceContext.unbind();
            this.httpServiceContext = null;
        }
    }

    public void didStop() {
    }

    public void willClose() {
    }

    public void didClose() {
    }

    public void didFail(Throwable error) {
        error.printStackTrace();
    }
}

