/*
 * Decompiled with CFR 0.152.
 */
package swim.service.web;

import swim.kernel.KernelProxy;
import swim.structure.Value;
import swim.uri.UriPath;
import swim.web.WebRequest;
import swim.web.WebResponse;
import swim.web.WebRoute;
import swim.web.route.ResourceDirectoryRoute;

public class UiRouter
extends KernelProxy {
    final double kernelPriority;
    final WebRoute uiRoute;
    private static final double KERNEL_PRIORITY = 100.0;

    public UiRouter(double kernelPriority) {
        this.kernelPriority = kernelPriority;
        this.uiRoute = new ResourceDirectoryRoute(((Object)((Object)this)).getClass().getClassLoader(), UriPath.parse((String)"ui/"), "index.html");
    }

    public UiRouter() {
        this(100.0);
    }

    public final double kernelPriority() {
        return this.kernelPriority;
    }

    public WebResponse routeRequest(WebRequest request) {
        WebResponse response = this.uiRoute.routeRequest(request);
        if (response.isAccepted()) {
            return response;
        }
        return super.routeRequest(request);
    }

    public void trace(Object message) {
    }

    public void debug(Object message) {
    }

    public void info(Object message) {
        super.info(message);
    }

    public void warn(Object message) {
        super.warn(message);
    }

    public void error(Object message) {
        super.error(message);
    }

    public void fail(Object message) {
        super.fail(message);
    }

    public static UiRouter fromValue(Value moduleConfig) {
        Value header = moduleConfig.getAttr("kernel");
        String kernelClassName = header.get("class").stringValue(null);
        if (kernelClassName == null || UiRouter.class.getName().equals(kernelClassName)) {
            double kernelPriority = header.get("priority").doubleValue(100.0);
            return new UiRouter(kernelPriority);
        }
        return null;
    }
}

