/*
 * Decompiled with CFR 0.152.
 */
package swim.service.web;

import swim.api.service.ServiceDef;
import swim.api.service.ServiceFactory;
import swim.io.warp.WarpSettings;
import swim.kernel.KernelContext;
import swim.kernel.KernelProxy;
import swim.service.web.WebServiceDef;
import swim.service.web.WebServiceFactory;
import swim.structure.Item;
import swim.structure.Value;
import swim.uri.UriPath;
import swim.web.WebRoute;
import swim.web.route.RejectRoute;

public class WebServiceKernel
extends KernelProxy {
    final double kernelPriority;
    private static final double KERNEL_PRIORITY = 0.75;

    public WebServiceKernel(double kernelPriority) {
        this.kernelPriority = kernelPriority;
    }

    public WebServiceKernel() {
        this(0.75);
    }

    public final double kernelPriority() {
        return this.kernelPriority;
    }

    public ServiceDef defineService(Item serviceConfig) {
        WebServiceDef serviceDef = this.defineWebService(serviceConfig);
        return serviceDef != null ? serviceDef : super.defineService(serviceConfig);
    }

    public WebServiceDef defineWebService(Item serviceConfig) {
        String webProvider;
        Value value = serviceConfig.toValue();
        Value header = value.getAttr("web");
        boolean isSecure = false;
        if (!header.isDefined()) {
            header = value.getAttr("warp");
        }
        if (!header.isDefined()) {
            header = value.getAttr("warps");
            isSecure = true;
        }
        if (header.isDefined() && ((webProvider = header.get("provider").stringValue(null)) == null || WebServiceKernel.class.getName().equals(webProvider))) {
            String serviceName = serviceConfig.key().stringValue("web");
            String address = header.get("address").stringValue("0.0.0.0");
            int port = header.get("port").intValue(443);
            isSecure = header.get("secure").booleanValue(isSecure);
            String spaceName = value.get("space").stringValue(null);
            if (spaceName == null) {
                spaceName = value.get("plane").stringValue(null);
            }
            String routerClass = null;
            int n = value.length();
            for (int i = 0; i < n; ++i) {
                Value router = value.getItem(i).getAttr("router");
                if (!router.isDefined()) continue;
                routerClass = router.get("class").stringValue(null);
            }
            UriPath documentRoot = (UriPath)value.get("documentRoot").cast(UriPath.pathForm());
            UriPath resourceRoot = (UriPath)value.get("resourceRoot").cast(UriPath.pathForm());
            WarpSettings warpSettings = (WarpSettings)WarpSettings.form().cast((Item)value);
            return new WebServiceDef(serviceName, address, port, isSecure, spaceName, routerClass, documentRoot, resourceRoot, warpSettings);
        }
        return null;
    }

    public ServiceFactory<?> createServiceFactory(ServiceDef serviceDef, ClassLoader classLoader) {
        if (serviceDef instanceof WebServiceDef) {
            return this.createWebServiceFactory((WebServiceDef)serviceDef);
        }
        return super.createServiceFactory(serviceDef, classLoader);
    }

    public WebServiceFactory createWebServiceFactory(WebServiceDef serviceDef) {
        WebRoute router = this.createWebRouter(serviceDef);
        KernelContext kernel = (KernelContext)this.kernelWrapper().unwrapKernel(KernelContext.class);
        return new WebServiceFactory(kernel, serviceDef, router);
    }

    protected WebRoute createWebRouter(WebServiceDef serviceDef) {
        if (serviceDef.routerClass != null) {
            try {
                Class<?> webRouteClass = Class.forName(serviceDef.routerClass);
                return (WebRoute)webRouteClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException cause) {
                throw new RuntimeException(cause);
            }
        }
        return new RejectRoute();
    }

    public static WebServiceKernel fromValue(Value moduleConfig) {
        Value header = moduleConfig.getAttr("kernel");
        String kernelClassName = header.get("class").stringValue(null);
        if (kernelClassName == null || WebServiceKernel.class.getName().equals(kernelClassName)) {
            double kernelPriority = header.get("priority").doubleValue(0.75);
            return new WebServiceKernel(kernelPriority);
        }
        return null;
    }
}

