/*
 * Decompiled with CFR 0.152.
 */
package swim.spatial;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import swim.spatial.BitInterval;
import swim.spatial.QTreeContext;
import swim.spatial.QTreeEntry;
import swim.spatial.QTreeLeaf;
import swim.spatial.QTreePageOrdering;
import swim.util.Cursor;

public abstract class QTreePage<K, S, V> {
    static final QTreeEntry<?, ?, ?>[] EMPTY_SLOTS = new QTreeEntry[0];
    static final Comparator<QTreePage<?, ?, ?>> PAGE_ORDERING = new QTreePageOrdering();

    QTreePage() {
    }

    public abstract boolean isEmpty();

    public abstract long span();

    public abstract int arity();

    public abstract QTreePage<K, S, V> getPage(int var1);

    public abstract int slotCount();

    public abstract QTreeEntry<K, S, V> getSlot(int var1);

    public abstract long x();

    public abstract int xRank();

    public abstract long xBase();

    public abstract long xMask();

    public abstract long xSplit();

    public abstract long y();

    public abstract int yRank();

    public abstract long yBase();

    public abstract long yMask();

    public abstract long ySplit();

    public abstract boolean containsKey(K var1, long var2, long var4, QTreeContext<K, S, V> var6);

    public boolean containsKey(K key, int xkRank, long xkBase, int ykRank, long ykBase, QTreeContext<K, S, V> tree) {
        long x = BitInterval.from(xkRank, xkBase);
        long y = BitInterval.from(ykRank, ykBase);
        return this.containsKey(key, x, y, tree);
    }

    public abstract V get(K var1, long var2, long var4, QTreeContext<K, S, V> var6);

    public V get(K key, int xkRank, long xkBase, int ykRank, long ykBase, QTreeContext<K, S, V> tree) {
        long x = BitInterval.from(xkRank, xkBase);
        long y = BitInterval.from(ykRank, ykBase);
        return this.get(key, x, y, tree);
    }

    public Collection<QTreeEntry<K, S, V>> getAll(long x, long y) {
        ArrayList<QTreeEntry<K, S, V>> slots = new ArrayList<QTreeEntry<K, S, V>>();
        Cursor<QTreeEntry<K, S, V>> cursor = this.cursor(x, y);
        while (cursor.hasNext()) {
            slots.add((QTreeEntry)cursor.next());
        }
        return slots;
    }

    public Collection<QTreeEntry<K, S, V>> getAll(long x0, long y0, long x1, long y1) {
        long x = BitInterval.span(x0, x1);
        long y = BitInterval.span(y0, y1);
        return this.getAll(x, y);
    }

    abstract QTreePage<K, S, V> updated(K var1, S var2, long var3, long var5, V var7, QTreeContext<K, S, V> var8, boolean var9);

    public QTreePage<K, S, V> updated(K key, S shape, long xk, long yk, V newValue, QTreeContext<K, S, V> tree) {
        return this.updated(key, shape, xk, yk, newValue, tree, true);
    }

    public QTreePage<K, S, V> updated(K key, S shape, int xkRank, long xkBase, int ykRank, long ykBase, V newValue, QTreeContext<K, S, V> tree) {
        long xk = BitInterval.from(xkRank, xkBase);
        long yk = BitInterval.from(ykRank, ykBase);
        return this.updated(key, shape, xk, yk, newValue, tree);
    }

    abstract QTreePage<K, S, V> insertedPage(QTreePage<K, S, V> var1, QTreeContext<K, S, V> var2);

    abstract QTreePage<K, S, V> mergedPage(QTreePage<K, S, V> var1, QTreeContext<K, S, V> var2);

    abstract QTreePage<K, S, V> mergedSlots(QTreeEntry<K, S, V>[] var1, QTreeContext<K, S, V> var2);

    abstract QTreePage<K, S, V> updatedSlot(QTreeEntry<K, S, V> var1, QTreeContext<K, S, V> var2);

    public abstract QTreePage<K, S, V> removed(K var1, long var2, long var4, QTreeContext<K, S, V> var6);

    public QTreePage<K, S, V> removed(K key, int xkRank, long xkBase, int ykRank, long ykBase, QTreeContext<K, S, V> tree) {
        long xk = BitInterval.from(xkRank, xkBase);
        long yk = BitInterval.from(ykRank, ykBase);
        return this.removed(key, xk, yk, tree);
    }

    public abstract QTreePage<K, S, V> flattened(QTreeContext<K, S, V> var1);

    public abstract QTreePage<K, S, V> balanced(QTreeContext<K, S, V> var1);

    public abstract QTreePage<K, S, V> split(QTreeContext<K, S, V> var1);

    public abstract Cursor<QTreeEntry<K, S, V>> cursor(long var1, long var3);

    public Cursor<QTreeEntry<K, S, V>> cursor(long x0, long y0, long x1, long y1) {
        long x = BitInterval.span(x0, x1);
        long y = BitInterval.span(y0, y1);
        return this.cursor(x, y);
    }

    public Cursor<QTreeEntry<K, S, V>> cursor() {
        return this.cursor(-1L, -1L);
    }

    public static <K, S, V> QTreePage<K, S, V> empty() {
        return QTreeLeaf.empty();
    }
}

