/*
 * Decompiled with CFR 0.152.
 */
package swim.spatial;

import java.util.NoSuchElementException;
import swim.spatial.BitInterval;
import swim.spatial.QTreeEntry;
import swim.spatial.QTreeLeaf;
import swim.util.Cursor;

final class QTreeLeafCursor<K, S, V>
implements Cursor<QTreeEntry<K, S, V>> {
    final QTreeLeaf<K, S, V> page;
    final long x;
    final long y;
    int index;

    QTreeLeafCursor(QTreeLeaf<K, S, V> page, long x, long y, int index) {
        this.page = page;
        this.x = x;
        this.y = y;
        this.index = index;
    }

    QTreeLeafCursor(QTreeLeaf<K, S, V> page, long x, long y) {
        this(page, x, y, 0);
    }

    public boolean isEmpty() {
        long x = this.x;
        long y = this.y;
        QTreeEntry<K, S, V>[] slots = this.page.slots;
        while (this.index < slots.length) {
            QTreeEntry slot = slots[this.index];
            if (!BitInterval.intersects(x, y, slot.x, slot.y)) continue;
            return false;
        }
        return true;
    }

    public QTreeEntry<K, S, V> head() {
        long x = this.x;
        long y = this.y;
        QTreeEntry<K, S, V>[] slots = this.page.slots;
        while (this.index < slots.length) {
            QTreeEntry slot = slots[this.index];
            if (!BitInterval.intersects(x, y, slot.x, slot.y)) continue;
            return slot;
        }
        throw new NoSuchElementException();
    }

    public void step() {
        long x = this.x;
        long y = this.y;
        QTreeEntry<K, S, V>[] slots = this.page.slots;
        while (this.index < slots.length) {
            QTreeEntry slot = slots[this.index];
            if (!BitInterval.intersects(x, y, slot.x, slot.y)) continue;
            ++this.index;
            return;
        }
        throw new UnsupportedOperationException();
    }

    public void skip(long count) {
        if (count < 0L) {
            throw new IllegalArgumentException();
        }
        this.index = Math.min(this.index + (int)count, this.page.slots.length);
    }

    public boolean hasNext() {
        long x = this.x;
        long y = this.y;
        QTreeEntry<K, S, V>[] slots = this.page.slots;
        while (this.index < slots.length) {
            QTreeEntry slot = slots[this.index];
            if (BitInterval.intersects(x, y, slot.x, slot.y)) {
                return true;
            }
            ++this.index;
        }
        return false;
    }

    public long nextIndexLong() {
        return this.nextIndex();
    }

    public int nextIndex() {
        return this.index;
    }

    public QTreeEntry<K, S, V> next() {
        long x = this.x;
        long y = this.y;
        QTreeEntry<K, S, V>[] slots = this.page.slots;
        while (this.index < slots.length) {
            QTreeEntry slot = slots[this.index];
            ++this.index;
            if (!BitInterval.intersects(x, y, slot.x, slot.y)) continue;
            return slot;
        }
        throw new NoSuchElementException();
    }

    public boolean hasPrevious() {
        long x = this.x;
        long y = this.y;
        QTreeEntry<K, S, V>[] slots = this.page.slots;
        while (this.index > 0) {
            QTreeEntry slot = slots[this.index - 1];
            if (BitInterval.intersects(x, y, slot.x, slot.y)) {
                return true;
            }
            --this.index;
        }
        return false;
    }

    public long previousIndexLong() {
        return this.previousIndex();
    }

    public int previousIndex() {
        return this.index - 1;
    }

    public QTreeEntry<K, S, V> previous() {
        long x = this.x;
        long y = this.y;
        QTreeEntry<K, S, V>[] slots = this.page.slots;
        while (this.index > 0) {
            QTreeEntry slot = slots[this.index - 1];
            --this.index;
            if (!BitInterval.intersects(x, y, slot.x, slot.y)) continue;
            return slot;
        }
        throw new NoSuchElementException();
    }
}

