/*
 * Decompiled with CFR 0.152.
 */
package swim.spatial;

import swim.math.Z2Form;
import swim.spatial.QTreeEntry;
import swim.spatial.SpatialMap;
import swim.util.Cursor;

final class QTreeShapeCursor<K, S, V>
implements Cursor<SpatialMap.Entry<K, S, V>> {
    final Cursor<QTreeEntry<K, S, V>> inner;
    final Z2Form<S> shapeForm;
    final S shape;
    QTreeEntry<K, S, V> nextSlot;
    QTreeEntry<K, S, V> previousSlot;

    QTreeShapeCursor(Cursor<QTreeEntry<K, S, V>> inner, Z2Form<S> shapeForm, S shape) {
        this.inner = inner;
        this.shapeForm = shapeForm;
        this.shape = shape;
        this.nextSlot = null;
        this.previousSlot = null;
    }

    public boolean isEmpty() {
        QTreeEntry nextSlot = this.nextSlot;
        if (nextSlot == null) {
            Z2Form<S> shapeForm = this.shapeForm;
            while (this.inner.hasNext()) {
                nextSlot = (QTreeEntry)this.inner.next();
                if (!shapeForm.intersects(this.shape, nextSlot.shape)) continue;
                this.nextSlot = nextSlot;
                return false;
            }
            return true;
        }
        return false;
    }

    public QTreeEntry<K, S, V> head() {
        QTreeEntry nextSlot = this.nextSlot;
        if (nextSlot == null) {
            Z2Form<S> shapeForm = this.shapeForm;
            do {
                nextSlot = (QTreeEntry)this.inner.next();
            } while (!shapeForm.intersects(this.shape, nextSlot.shape));
        }
        this.previousSlot = null;
        this.nextSlot = nextSlot;
        return nextSlot;
    }

    public void step() {
        QTreeEntry nextSlot = this.nextSlot;
        if (nextSlot == null) {
            Z2Form<S> shapeForm = this.shapeForm;
            do {
                nextSlot = (QTreeEntry)this.inner.next();
            } while (!shapeForm.intersects(this.shape, nextSlot.shape));
        }
        this.previousSlot = nextSlot;
        this.nextSlot = null;
    }

    public void skip(long count) {
        this.inner.skip(count);
    }

    public boolean hasNext() {
        QTreeEntry nextSlot = this.nextSlot;
        if (nextSlot == null) {
            Z2Form<S> shapeForm = this.shapeForm;
            while (this.inner.hasNext()) {
                nextSlot = (QTreeEntry)this.inner.next();
                if (!shapeForm.intersects(this.shape, nextSlot.shape)) continue;
                this.nextSlot = nextSlot;
                return true;
            }
            return false;
        }
        return true;
    }

    public long nextIndexLong() {
        return this.inner.nextIndexLong();
    }

    public int nextIndex() {
        return this.inner.nextIndex();
    }

    public QTreeEntry<K, S, V> next() {
        QTreeEntry nextSlot = this.nextSlot;
        if (nextSlot == null) {
            Z2Form<S> shapeForm = this.shapeForm;
            do {
                nextSlot = (QTreeEntry)this.inner.next();
            } while (!shapeForm.intersects(this.shape, nextSlot.shape));
        }
        this.previousSlot = nextSlot;
        this.nextSlot = null;
        return nextSlot;
    }

    public boolean hasPrevious() {
        QTreeEntry previousSlot = this.previousSlot;
        if (previousSlot == null) {
            Z2Form<S> shapeForm = this.shapeForm;
            while (this.inner.hasPrevious()) {
                previousSlot = (QTreeEntry)this.inner.previous();
                if (!shapeForm.intersects(this.shape, previousSlot.shape)) continue;
                this.previousSlot = previousSlot;
                return true;
            }
            return false;
        }
        return true;
    }

    public long previousIndexLong() {
        return this.inner.previousIndexLong();
    }

    public int previousIndex() {
        return this.inner.previousIndex();
    }

    public QTreeEntry<K, S, V> previous() {
        QTreeEntry previousSlot = this.previousSlot;
        if (previousSlot == null) {
            Z2Form<S> shapeForm = this.shapeForm;
            do {
                previousSlot = (QTreeEntry)this.inner.previous();
            } while (!shapeForm.intersects(this.shape, previousSlot.shape));
        }
        this.nextSlot = previousSlot;
        this.previousSlot = null;
        return previousSlot;
    }
}

