/*
 * Decompiled with CFR 0.152.
 */
package swim.spatial;

import java.util.Map;
import swim.spatial.SpatialMap;

public class QTreeEntry<K, S, V>
implements SpatialMap.Entry<K, S, V> {
    final K key;
    final S shape;
    final long x;
    final long y;
    final V value;

    public QTreeEntry(K key, S shape, long x, long y, V value) {
        this.key = key;
        this.shape = shape;
        this.x = x;
        this.y = y;
        this.value = value;
    }

    @Override
    public final K getKey() {
        return this.key;
    }

    @Override
    public final S getShape() {
        return this.shape;
    }

    public final long x() {
        return this.x;
    }

    public final int xRank() {
        return Long.numberOfLeadingZeros(this.x ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public final long xBase() {
        return this.x << this.xRank();
    }

    public final long y() {
        return this.y;
    }

    public final int yRank() {
        return Long.numberOfLeadingZeros(this.y ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public final long yBase() {
        return this.y << this.yRank();
    }

    @Override
    public final V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Map.Entry) {
            Map.Entry that = (Map.Entry)other;
            if (this.key == null ? that.getKey() != null : !this.key.equals(that.getKey())) {
                return false;
            }
            return !(this.value == null ? that.getValue() != null : !this.value.equals(that.getValue()));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
    }

    public String toString() {
        return "" + this.key + '=' + this.value;
    }
}

