/*
 * Decompiled with CFR 0.152.
 */
package swim.store.db;

import java.util.Collections;
import java.util.Iterator;
import swim.api.data.ListData;
import swim.api.data.MapData;
import swim.api.data.SpatialData;
import swim.api.data.ValueData;
import swim.api.store.StoreException;
import swim.concurrent.MainStage;
import swim.concurrent.Stage;
import swim.db.BTreeMap;
import swim.db.QTreeMap;
import swim.db.STreeList;
import swim.db.Store;
import swim.db.UTreeValue;
import swim.math.R2Shape;
import swim.math.Z2Form;
import swim.spatial.GeoProjection;
import swim.store.DataBinding;
import swim.store.ListDataBinding;
import swim.store.MapDataBinding;
import swim.store.SpatialDataBinding;
import swim.store.StoreBinding;
import swim.store.StoreContext;
import swim.store.ValueDataBinding;
import swim.store.db.ListDataModel;
import swim.store.db.MapDataModel;
import swim.store.db.SpatialDataModel;
import swim.store.db.ValueDataModel;
import swim.structure.Item;
import swim.structure.Text;
import swim.structure.Value;

public class DbStore
implements StoreBinding,
StoreContext {
    protected final Store store;
    protected final Value name;
    protected StoreContext storeContext;

    public DbStore(Store store, Value name) {
        this.store = store;
        this.name = name;
    }

    public StoreContext storeContext() {
        return this.storeContext != null ? this.storeContext : this;
    }

    public void setStoreContext(StoreContext storeContext) {
        this.storeContext = storeContext;
    }

    protected Value storeName(Value name) {
        return this.name.concat((Item)name);
    }

    protected Value treeName(Value name) {
        return this.name.concat((Item)name);
    }

    public Iterator<DataBinding> dataBindings() {
        return Collections.emptyIterator();
    }

    public void closeData(Value name) {
        Value treeName = this.treeName(name);
        this.store.database().closeTrunk(treeName);
    }

    public void close() {
        if (!this.name.isDefined()) {
            try {
                this.store.close();
                Stage stage = this.store.stage();
                if (stage instanceof MainStage) {
                    ((MainStage)stage).stop();
                }
            }
            catch (InterruptedException cause) {
                throw new StoreException((Throwable)cause);
            }
        }
    }

    public StoreBinding openStore(Value name) {
        Value storeName = this.storeName(name);
        return new DbStore(this.store, storeName);
    }

    public StoreBinding injectStore(StoreBinding storeBinding) {
        return storeBinding;
    }

    public ListDataBinding openListData(Value name) {
        Value treeName = this.treeName(name);
        STreeList stree = this.store.database().openSTreeList(treeName);
        return new ListDataModel(treeName, stree);
    }

    public ListDataBinding injectListData(ListDataBinding dataBinding) {
        return dataBinding;
    }

    public MapDataBinding openMapData(Value name) {
        Value treeName = this.treeName(name);
        BTreeMap btree = this.store.database().openBTreeMap(treeName);
        return new MapDataModel(treeName, btree);
    }

    public MapDataBinding injectMapData(MapDataBinding dataBinding) {
        return dataBinding;
    }

    public <S> SpatialDataBinding<S> openSpatialData(Value name, Z2Form<S> shapeForm) {
        Value treeName = this.treeName(name);
        QTreeMap qtree = this.store.database().openQTreeMap(treeName, shapeForm);
        return new SpatialDataModel(treeName, qtree);
    }

    public <S> SpatialDataBinding<S> injectSpatialData(SpatialDataBinding<S> dataBinding) {
        return dataBinding;
    }

    public ValueDataBinding openValueData(Value name) {
        Value treeName = this.treeName(name);
        UTreeValue utree = this.store.database().openUTreeValue(treeName);
        return new ValueDataModel(treeName, utree);
    }

    public ValueDataBinding injectValueData(ValueDataBinding dataBinding) {
        return dataBinding;
    }

    public ListData<Value> listData(Value name) {
        ListDataBinding dataBinding = this.openListData(name);
        dataBinding = this.injectListData(dataBinding);
        return dataBinding;
    }

    public ListData<Value> listData(String name) {
        return this.listData((Value)Text.from((String)name));
    }

    public MapData<Value, Value> mapData(Value name) {
        MapDataBinding dataBinding = this.openMapData(name);
        dataBinding = this.injectMapData(dataBinding);
        return dataBinding;
    }

    public MapData<Value, Value> mapData(String name) {
        return this.mapData((Value)Text.from((String)name));
    }

    public <S> SpatialData<Value, S, Value> spatialData(Value name, Z2Form<S> shapeForm) {
        SpatialDataBinding<S> dataBinding = this.openSpatialData(name, shapeForm);
        dataBinding = this.injectSpatialData(dataBinding);
        return dataBinding;
    }

    public <S> SpatialData<Value, S, Value> spatialData(String name, Z2Form<S> shapeForm) {
        return this.spatialData((Value)Text.from((String)name), shapeForm);
    }

    public SpatialData<Value, R2Shape, Value> geospatialData(Value name) {
        return this.spatialData(name, GeoProjection.wgs84Form());
    }

    public SpatialData<Value, R2Shape, Value> geospatialData(String name) {
        return this.geospatialData((Value)Text.from((String)name));
    }

    public ValueData<Value> valueData(Value name) {
        ValueDataBinding dataBinding = this.openValueData(name);
        dataBinding = this.injectValueData(dataBinding);
        return dataBinding;
    }

    public ValueData<Value> valueData(String name) {
        return this.valueData((Value)Text.from((String)name));
    }
}

