/*
 * Decompiled with CFR 0.152.
 */
package swim.store.db;

import swim.api.store.StoreException;
import swim.concurrent.MainStage;
import swim.concurrent.Stage;
import swim.db.FileStore;
import swim.db.Store;
import swim.db.StoreContext;
import swim.db.StoreSettings;
import swim.kernel.KernelContext;
import swim.kernel.KernelProxy;
import swim.runtime.CellAddress;
import swim.runtime.StoreAddress;
import swim.store.StoreBinding;
import swim.store.StoreDef;
import swim.store.db.DbStore;
import swim.store.db.DbStoreDef;
import swim.structure.Item;
import swim.structure.Value;

public class DbStoreKernel
extends KernelProxy {
    private static final double KERNEL_PRIORITY = -0.75;
    final double kernelPriority;

    public DbStoreKernel(double kernelPriority) {
        this.kernelPriority = kernelPriority;
    }

    public DbStoreKernel() {
        this(-0.75);
    }

    public static DbStoreKernel fromValue(Value moduleConfig) {
        Value header = moduleConfig.getAttr("kernel");
        String kernelClassName = header.get("class").stringValue(null);
        if (kernelClassName == null || DbStoreKernel.class.getName().equals(kernelClassName)) {
            double kernelPriority = header.get("priority").doubleValue(-0.75);
            return new DbStoreKernel(kernelPriority);
        }
        return null;
    }

    public final double kernelPriority() {
        return this.kernelPriority;
    }

    public StoreDef defineStore(Item storeConfig) {
        DbStoreDef storeDef = this.defineDbStore(storeConfig);
        return storeDef != null ? storeDef : super.defineStore(storeConfig);
    }

    public DbStoreDef defineDbStore(Item storeConfig) {
        String storeProvider;
        Value value = storeConfig.toValue();
        Value header = value.getAttr("store");
        if (header.isDefined() && ((storeProvider = header.get("provider").stringValue(null)) == null || DbStoreKernel.class.getName().equals(storeProvider))) {
            String storeName = storeConfig.key().stringValue(null);
            String path = value.get("path").stringValue(null);
            StoreSettings settings = (StoreSettings)StoreSettings.form().cast((Item)value);
            if (path != null && settings != null) {
                return new DbStoreDef(storeName, path, settings);
            }
        }
        return null;
    }

    public StoreBinding createStore(StoreDef storeDef, ClassLoader classLoader) {
        if (storeDef instanceof DbStoreDef) {
            return this.createDbStore((DbStoreDef)storeDef);
        }
        return super.createStore(storeDef, classLoader);
    }

    public DbStore createDbStore(DbStoreDef storeDef) {
        String storeName = storeDef.storeName;
        String storePath = storeDef.path;
        StoreSettings storeSettings = storeDef.settings;
        StoreContext storeContext = new StoreContext(storeSettings);
        StoreAddress storeAddress = new StoreAddress(storeName);
        KernelContext kernel = (KernelContext)this.kernelWrapper().unwrapKernel(KernelContext.class);
        Stage stage = kernel.createStage((CellAddress)storeAddress);
        try {
            FileStore fileStore = new FileStore(storeContext, storePath, stage).open();
            fileStore.openDatabase();
            return new DbStore((Store)fileStore, Value.absent());
        }
        catch (InterruptedException cause) {
            if (stage instanceof MainStage) {
                ((MainStage)stage).stop();
            }
            throw new StoreException((Throwable)cause);
        }
    }
}

