/*
 * Decompiled with CFR 0.152.
 */
package swim.store.db;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import swim.api.data.MapData;
import swim.db.BTree;
import swim.db.BTreeDelegate;
import swim.db.BTreeMap;
import swim.db.Database;
import swim.db.Page;
import swim.db.Store;
import swim.db.Tree;
import swim.db.TreeDelegate;
import swim.store.MapDataBinding;
import swim.store.MapDataContext;
import swim.store.MapDataView;
import swim.store.StoreBinding;
import swim.structure.Form;
import swim.structure.Value;
import swim.util.Cursor;
import swim.util.OrderedMap;
import swim.util.OrderedMapCursor;

public class MapDataModel
implements MapDataBinding,
BTreeDelegate {
    protected final Value name;
    protected final BTreeMap tree;
    protected MapDataContext dataContext;
    protected StoreBinding storeBinding;

    public MapDataModel(Value name, BTreeMap tree) {
        this.name = name;
        this.tree = tree;
        tree.setTreeDelegate((TreeDelegate)this);
    }

    public MapDataContext dataContext() {
        return this.dataContext;
    }

    public void setDataContext(MapDataContext dataContext) {
        this.dataContext = dataContext;
    }

    public StoreBinding storeBinding() {
        return this.storeBinding;
    }

    public void setStoreBinding(StoreBinding storeBinding) {
        this.storeBinding = storeBinding;
    }

    public <T> T unwrapData(Class<T> dataClass) {
        if (dataClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    public final BTreeMap tree() {
        return this.tree;
    }

    public final Database database() {
        return this.tree.database();
    }

    public final Store store() {
        return this.database().store();
    }

    public final Value treeName() {
        return this.tree.name();
    }

    public final Value name() {
        return this.name;
    }

    public Form<Value> keyForm() {
        return Form.forValue();
    }

    public <K2> MapData<K2, Value> keyForm(Form<K2> keyForm) {
        return new MapDataView((MapDataBinding)this, keyForm, Form.forValue());
    }

    public <K2> MapData<K2, Value> keyClass(Class<K2> keyClass) {
        return this.keyForm(Form.forClass(keyClass));
    }

    public Form<Value> valueForm() {
        return Form.forValue();
    }

    public <V2> MapData<Value, V2> valueForm(Form<V2> valueForm) {
        return new MapDataView((MapDataBinding)this, Form.forValue(), valueForm);
    }

    public <V2> MapData<Value, V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public long dataSize() {
        return this.tree.treeSize();
    }

    public boolean isResident() {
        return this.tree.isResident();
    }

    public MapDataBinding isResident(boolean isResident) {
        this.tree.isResident(isResident);
        return this;
    }

    public boolean isTransient() {
        return this.tree.isTransient();
    }

    public MapDataBinding isTransient(boolean isTransient) {
        this.tree.isTransient(isTransient);
        return this;
    }

    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    public int size() {
        return this.tree.size();
    }

    public boolean containsKey(Object key) {
        return this.tree.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.tree.containsValue(value);
    }

    public int indexOf(Object key) {
        return this.tree.indexOf(key);
    }

    public Value get(Object key) {
        return this.tree.get(key);
    }

    public Map.Entry<Value, Value> getEntry(Object key) {
        return this.tree.getEntry(key);
    }

    public Map.Entry<Value, Value> getIndex(int index) {
        return this.tree.getIndex(index);
    }

    public Map.Entry<Value, Value> firstEntry() {
        return this.tree.firstEntry();
    }

    public Value firstKey() {
        return this.tree.firstKey();
    }

    public Value firstValue() {
        return this.tree.firstValue();
    }

    public Map.Entry<Value, Value> lastEntry() {
        return this.tree.lastEntry();
    }

    public Value lastKey() {
        return this.tree.lastKey();
    }

    public Value lastValue() {
        return this.tree.lastValue();
    }

    public Map.Entry<Value, Value> nextEntry(Value key) {
        return this.tree.nextEntry(key);
    }

    public Value nextKey(Value key) {
        return this.tree.nextKey(key);
    }

    public Value nextValue(Value key) {
        return this.tree.nextValue(key);
    }

    public Map.Entry<Value, Value> previousEntry(Value key) {
        return this.tree.previousEntry(key);
    }

    public Value previousKey(Value key) {
        return this.tree.previousKey(key);
    }

    public Value previousValue(Value key) {
        return this.tree.previousValue(key);
    }

    public Value put(Value key, Value value) {
        return this.tree.put(key, value);
    }

    public void putAll(Map<? extends Value, ? extends Value> items) {
        this.tree.putAll(items);
    }

    public Value remove(Object key) {
        return this.tree.remove(key);
    }

    public void drop(int lower) {
        this.tree.drop(lower);
    }

    public void take(int upper) {
        this.tree.take(upper);
    }

    public void clear() {
        this.tree.clear();
    }

    public OrderedMap<Value, Value> headMap(Value toKey) {
        return this.tree.headMap((Object)toKey);
    }

    public OrderedMap<Value, Value> tailMap(Value fromKey) {
        return this.tree.tailMap((Object)fromKey);
    }

    public OrderedMap<Value, Value> subMap(Value fromKey, Value toKey) {
        return this.tree.subMap((Object)fromKey, (Object)toKey);
    }

    public Set<Map.Entry<Value, Value>> entrySet() {
        return this.tree.entrySet();
    }

    public Set<Value> keySet() {
        return this.tree.keySet();
    }

    public Collection<Value> values() {
        return this.tree.values();
    }

    public OrderedMapCursor<Value, Value> iterator() {
        return this.tree.iterator();
    }

    public Cursor<Value> keyIterator() {
        return this.tree.keyIterator();
    }

    public Cursor<Value> valueIterator() {
        return this.tree.valueIterator();
    }

    public OrderedMap<Value, Value> snapshot() {
        return this.tree.snapshot();
    }

    public Comparator<? super Value> comparator() {
        return this.tree.comparator();
    }

    public void close() {
        StoreBinding storeBinding = this.storeBinding;
        if (storeBinding != null) {
            storeBinding.closeData(this.name);
        }
    }

    public void treeDidLoadPage(Page page) {
    }

    public void treeDidChange(Tree newTree, Tree oldTree) {
    }

    public void treeDidCommit(Tree newTree, Tree oldTree) {
    }

    public void treeDidClear(Tree newTree, Tree oldTree) {
    }

    public void btreeDidUpdate(BTree newTree, BTree oldTree, Value key, Value newValue, Value oldValue) {
        MapDataContext dataContext = this.dataContext;
        if (dataContext != null) {
            dataContext.didUpdate(key, newValue, oldValue);
        }
    }

    public void btreeDidRemove(BTree newTree, BTree oldTree, Value key, Value oldValue) {
        MapDataContext dataContext = this.dataContext;
        if (dataContext != null) {
            dataContext.didRemove(key, oldValue);
        }
    }

    public void btreeDidDrop(BTree newTree, BTree oldTree, long lower) {
        MapDataContext dataContext = this.dataContext;
        if (dataContext != null) {
            dataContext.didDrop(lower);
        }
    }

    public void btreeDidTake(BTree newTree, BTree oldTree, long upper) {
        MapDataContext dataContext = this.dataContext;
        if (dataContext != null) {
            dataContext.didTake(upper);
        }
    }
}

