/*
 * Decompiled with CFR 0.152.
 */
package swim.store.db;

import swim.api.data.ValueData;
import swim.db.Page;
import swim.db.Tree;
import swim.db.TreeDelegate;
import swim.db.UTree;
import swim.db.UTreeDelegate;
import swim.db.UTreeValue;
import swim.store.StoreBinding;
import swim.store.ValueDataBinding;
import swim.store.ValueDataContext;
import swim.store.ValueDataView;
import swim.structure.Form;
import swim.structure.Value;

public class ValueDataModel
implements ValueDataBinding,
UTreeDelegate {
    protected final Value name;
    protected final UTreeValue tree;
    protected ValueDataContext dataContext;
    protected StoreBinding storeBinding;

    public ValueDataModel(Value name, UTreeValue tree) {
        this.name = name;
        this.tree = tree;
        tree.setTreeDelegate((TreeDelegate)this);
    }

    public ValueDataContext dataContext() {
        return this.dataContext;
    }

    public void setDataContext(ValueDataContext dataContext) {
        this.dataContext = dataContext;
    }

    public StoreBinding storeBinding() {
        return this.storeBinding;
    }

    public void setStoreBinding(StoreBinding storeBinding) {
        this.storeBinding = storeBinding;
    }

    public <T> T unwrapData(Class<T> dataClass) {
        if (dataClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    public Value name() {
        return this.name;
    }

    public long dataSize() {
        return this.tree.tree().treeSize();
    }

    public Form<Value> valueForm() {
        return Form.forValue();
    }

    public <V2> ValueData<V2> valueForm(Form<V2> valueForm) {
        return new ValueDataView((ValueDataBinding)this, valueForm);
    }

    public <V2> ValueData<V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public boolean isResident() {
        return this.tree.isResident();
    }

    public ValueDataBinding isResident(boolean isResident) {
        this.tree.isResident(isResident);
        return this;
    }

    public boolean isTransient() {
        return this.tree.isTransient();
    }

    public ValueDataBinding isTransient(boolean isTransient) {
        this.tree.isTransient(isTransient);
        return this;
    }

    public Value get() {
        return this.tree.get();
    }

    public Value set(Value newValue) {
        return this.tree.set(newValue);
    }

    public void close() {
        StoreBinding storeBinding = this.storeBinding;
        if (storeBinding != null) {
            storeBinding.closeData(this.name);
        }
    }

    public void treeDidLoadPage(Page page) {
    }

    public void treeDidChange(Tree newTree, Tree oldTree) {
    }

    public void treeDidCommit(Tree newTree, Tree oldTree) {
    }

    public void treeDidClear(Tree newTree, Tree oldTree) {
    }

    public void utreeDidUpdate(UTree newTree, UTree oldTree, Value newValue, Value oldValue) {
        ValueDataContext dataContext = this.dataContext;
        if (dataContext != null) {
            dataContext.didSet(newValue, oldValue);
        }
    }
}

