/*
 * Decompiled with CFR 0.152.
 */
package swim.store.db;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import swim.api.data.ListData;
import swim.db.Database;
import swim.db.Page;
import swim.db.STree;
import swim.db.STreeDelegate;
import swim.db.STreeList;
import swim.db.Store;
import swim.db.Tree;
import swim.db.TreeDelegate;
import swim.store.ListDataBinding;
import swim.store.ListDataContext;
import swim.store.ListDataView;
import swim.store.StoreBinding;
import swim.structure.Form;
import swim.structure.Value;
import swim.util.KeyedList;

public class ListDataModel
implements ListDataBinding,
STreeDelegate {
    protected final Value name;
    protected final STreeList tree;
    protected ListDataContext dataContext;
    protected StoreBinding storeBinding;

    public ListDataModel(Value name, STreeList tree) {
        this.name = name;
        this.tree = tree;
        this.dataContext = null;
        this.storeBinding = null;
        this.tree.setTreeDelegate((TreeDelegate)this);
    }

    public ListDataContext dataContext() {
        return this.dataContext;
    }

    public void setDataContext(ListDataContext dataContext) {
        this.dataContext = dataContext;
    }

    public StoreBinding storeBinding() {
        return this.storeBinding;
    }

    public void setStoreBinding(StoreBinding storeBinding) {
        this.storeBinding = storeBinding;
    }

    public <T> T unwrapData(Class<T> dataClass) {
        if (dataClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    public final STreeList tree() {
        return this.tree;
    }

    public final Database database() {
        return this.tree.database();
    }

    public final Store store() {
        return this.database().store();
    }

    public final Value treeName() {
        return this.tree.name();
    }

    public final Value name() {
        return this.name;
    }

    public Form<Value> valueForm() {
        return Form.forValue();
    }

    public <V2> ListData<V2> valueForm(Form<V2> valueForm) {
        return new ListDataView((ListDataBinding)this, valueForm);
    }

    public <V2> ListData<V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public long dataSize() {
        return this.tree.treeSize();
    }

    public boolean isResident() {
        return this.tree.isResident();
    }

    public ListDataModel isResident(boolean isResident) {
        this.tree.isResident(isResident);
        return this;
    }

    public boolean isTransient() {
        return this.tree.isTransient();
    }

    public ListDataModel isTransient(boolean isTransient) {
        this.tree.isTransient(isTransient);
        return this;
    }

    public int size() {
        return this.tree.size();
    }

    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    public boolean contains(Object value) {
        return this.tree.contains(value);
    }

    public boolean containsAll(Collection<?> values) {
        return this.tree.containsAll(values);
    }

    public int indexOf(Object value) {
        return this.tree.indexOf(value);
    }

    public int lastIndexOf(Object value) {
        return this.tree.lastIndexOf(value);
    }

    public Value get(int index) {
        return this.tree.get(index);
    }

    public Value set(int index, Value value) {
        return this.tree.set(index, value);
    }

    public boolean add(Value value) {
        return this.tree.add(value);
    }

    public boolean addAll(Collection<? extends Value> values) {
        return this.tree.addAll(values);
    }

    public void add(int index, Value value) {
        this.tree.add(index, value);
    }

    public boolean addAll(int index, Collection<? extends Value> values) {
        return this.tree.addAll(index, values);
    }

    public Value remove(int index) {
        return this.tree.remove(index);
    }

    public boolean remove(Object value) {
        return this.tree.remove(value);
    }

    public boolean removeAll(Collection<?> values) {
        return this.tree.removeAll(values);
    }

    public boolean retainAll(Collection<?> values) {
        return this.tree.retainAll(values);
    }

    public void drop(int lower) {
        this.tree.drop(lower);
    }

    public void take(int upper) {
        this.tree.take(upper);
    }

    public void clear() {
        this.tree.clear();
    }

    public Iterator<Value> iterator() {
        return this.tree.iterator();
    }

    public ListIterator<Value> listIterator() {
        return this.tree.listIterator();
    }

    public ListIterator<Value> listIterator(int index) {
        return this.tree.listIterator(index);
    }

    public List<Value> subList(int fromIndex, int toIndex) {
        return this.tree.subList(fromIndex, toIndex);
    }

    public KeyedList<Value> snapshot() {
        return null;
    }

    public Object[] toArray() {
        return this.tree.toArray();
    }

    public <T> T[] toArray(T[] array) {
        return this.tree.toArray((Object[])array);
    }

    public void close() {
        StoreBinding storeBinding = this.storeBinding;
        if (storeBinding != null) {
            storeBinding.closeData(this.name);
        }
    }

    public Value get(int index, Object key) {
        return this.tree.get(index, key);
    }

    public Map.Entry<Object, Value> getEntry(int index) {
        return this.tree.getEntry(index);
    }

    public Map.Entry<Object, Value> getEntry(int index, Object key) {
        return this.tree.getEntry(index, key);
    }

    public Value set(int index, Value element, Object key) {
        return this.tree.set(index, element, key);
    }

    public boolean add(Value element, Object key) {
        return this.tree.add(element, key);
    }

    public void add(int index, Value element, Object key) {
        this.tree.add(index, element, key);
    }

    public Value remove(int index, Object key) {
        return this.tree.remove(index, key);
    }

    public void move(int fromIndex, int toIndex) {
        this.tree.move(fromIndex, toIndex);
    }

    public void move(int fromIndex, int toIndex, Object key) {
        this.tree.move(fromIndex, toIndex, key);
    }

    public ListIterator<Object> keyIterator() {
        return this.tree.keyIterator();
    }

    public ListIterator<Map.Entry<Object, Value>> entryIterator() {
        return this.tree.entryIterator();
    }

    public void treeDidLoadPage(Page page) {
    }

    public void treeDidChange(Tree newTree, Tree oldTree) {
    }

    public void treeDidCommit(Tree newTree, Tree oldTree) {
    }

    public void treeDidClear(Tree newTree, Tree oldTree) {
    }

    public void streeDidUpdate(STree newTree, STree oldTree, long index, Value id, Value newValue, Value oldValue) {
        ListDataContext dataContext = this.dataContext;
        if (dataContext != null) {
            dataContext.didUpdate(index, newValue, oldValue);
        }
    }

    public void streeDidInsert(STree newTree, STree oldTree, long index, Value id, Value newValue) {
        ListDataContext dataContext = this.dataContext;
        if (dataContext != null) {
            dataContext.didInsert(index, newValue);
        }
    }

    public void streeDidRemove(STree newTree, STree oldTree, long index, Value id, Value oldValue) {
        ListDataContext dataContext = this.dataContext;
        if (dataContext != null) {
            dataContext.didRemove(index, oldValue);
        }
    }

    public void streeDidDrop(STree newTree, STree oldTree, long lower) {
        ListDataContext dataContext = this.dataContext;
        if (dataContext != null) {
            dataContext.didDrop(lower);
        }
    }

    public void streeDidTake(STree newTree, STree oldTree, long upper) {
        ListDataContext dataContext = this.dataContext;
        if (dataContext != null) {
            dataContext.didTake(upper);
        }
    }
}

