/*
 * Decompiled with CFR 0.152.
 */
package swim.store.db;

import java.util.Iterator;
import swim.api.data.SpatialData;
import swim.db.Database;
import swim.db.Page;
import swim.db.QTree;
import swim.db.QTreeDelegate;
import swim.db.QTreeMap;
import swim.db.Store;
import swim.db.Tree;
import swim.db.TreeDelegate;
import swim.math.Z2Form;
import swim.spatial.SpatialMap;
import swim.store.SpatialDataBinding;
import swim.store.SpatialDataContext;
import swim.store.SpatialDataView;
import swim.store.StoreBinding;
import swim.structure.Form;
import swim.structure.Value;

public class SpatialDataModel<S>
implements SpatialDataBinding<S>,
QTreeDelegate {
    protected final Value name;
    protected final QTreeMap<S> tree;
    protected SpatialDataContext<S> dataContext;
    protected StoreBinding storeBinding;

    public SpatialDataModel(Value name, QTreeMap<S> tree) {
        this.name = name;
        this.tree = tree;
        this.dataContext = null;
        this.storeBinding = null;
        this.tree.setTreeDelegate((TreeDelegate)this);
    }

    public SpatialDataContext<S> dataContext() {
        return this.dataContext;
    }

    public void setDataContext(SpatialDataContext<S> dataContext) {
        this.dataContext = dataContext;
    }

    public StoreBinding storeBinding() {
        return this.storeBinding;
    }

    public void setStoreBinding(StoreBinding storeBinding) {
        this.storeBinding = storeBinding;
    }

    public <T> T unwrapData(Class<T> dataClass) {
        if (dataClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    public final QTreeMap<S> tree() {
        return this.tree;
    }

    public final Database database() {
        return this.tree.database();
    }

    public final Store store() {
        return this.database().store();
    }

    public final Value treeName() {
        return this.tree.name();
    }

    public final Value name() {
        return this.name;
    }

    public Form<Value> keyForm() {
        return Form.forValue();
    }

    public <K2> SpatialData<K2, S, Value> keyForm(Form<K2> keyForm) {
        return new SpatialDataView((SpatialDataBinding)this, keyForm, Form.forValue());
    }

    public <K2> SpatialData<K2, S, Value> keyClass(Class<K2> keyClass) {
        return this.keyForm(Form.forClass(keyClass));
    }

    public long dataSize() {
        return this.tree.treeSize();
    }

    public long leafCount() {
        return this.tree.span();
    }

    public final Z2Form<S> shapeForm() {
        return this.tree.shapeForm();
    }

    public Form<Value> valueForm() {
        return Form.forValue();
    }

    public <V2> SpatialData<Value, S, V2> valueForm(Form<V2> valueForm) {
        return new SpatialDataView((SpatialDataBinding)this, Form.forValue(), valueForm);
    }

    public <V2> SpatialData<Value, S, V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public boolean isResident() {
        return this.tree.isResident();
    }

    public SpatialDataBinding<S> isResident(boolean isResident) {
        this.tree.isResident(isResident);
        return this;
    }

    public boolean isTransient() {
        return this.tree.isTransient();
    }

    public SpatialDataBinding<S> isTransient(boolean isTransient) {
        this.tree.isTransient(isTransient);
        return this;
    }

    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    public int size() {
        return this.tree.size();
    }

    public boolean containsKey(Value key, S shape) {
        return this.tree.containsKey(key, shape);
    }

    public boolean containsKey(Object key) {
        return this.tree.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.tree.containsValue(value);
    }

    public Value get(Value key, S shape) {
        return this.tree.get(key, shape);
    }

    public Value get(Object key) {
        return this.tree.get(key);
    }

    public Value put(Value key, S shape, Value newValue) {
        return this.tree.put(key, shape, newValue);
    }

    public Value move(Value key, S oldShape, S newShape, Value newValue) {
        return this.tree.move(key, oldShape, newShape, newValue);
    }

    public Value remove(Value key, S shape) {
        return this.tree.remove(key, shape);
    }

    public void clear() {
        this.tree.clear();
    }

    public Iterator<SpatialMap.Entry<Value, S, Value>> iterator(S shape) {
        return this.tree.iterator(shape);
    }

    public Iterator<SpatialMap.Entry<Value, S, Value>> iterator() {
        return this.tree.iterator();
    }

    public Iterator<Value> keyIterator() {
        return this.tree.keyIterator();
    }

    public Iterator<Value> valueIterator() {
        return this.tree.valueIterator();
    }

    public SpatialMap<Value, S, Value> snapshot() {
        return this.tree.snapshot();
    }

    public void close() {
        StoreBinding storeBinding = this.storeBinding;
        if (storeBinding != null) {
            storeBinding.closeData(this.name);
        }
    }

    public void treeDidLoadPage(Page page) {
    }

    public void treeDidChange(Tree newTree, Tree oldTree) {
    }

    public void treeDidCommit(Tree newTree, Tree oldTree) {
    }

    public void treeDidClear(Tree newTree, Tree oldTree) {
    }

    public void qtreeDidUpdate(QTree newTree, QTree oldTree, Value key, long x, long y, Value newValue, Value oldValue) {
        SpatialDataContext<S> dataContext = this.dataContext;
        if (dataContext != null) {
            dataContext.didUpdate(key, x, y, newValue, oldValue);
        }
    }

    public void qtreeDidMove(QTree newTree, QTree oldTree, Value key, long newX, long newY, Value newValue, long oldX, long oldY, Value oldValue) {
        SpatialDataContext<S> dataContext = this.dataContext;
        if (dataContext != null) {
            dataContext.didMove(key, newX, newY, newValue, oldX, oldY, oldValue);
        }
    }

    public void qtreeDidRemove(QTree newTree, QTree oldTree, Value key, long x, long y, Value oldValue) {
        SpatialDataContext<S> dataContext = this.dataContext;
        if (dataContext != null) {
            dataContext.didRemove(key, x, y, oldValue);
        }
    }
}

