/*
 * Decompiled with CFR 0.152.
 */
package swim.store.db;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.db.StoreSettings;
import swim.store.StoreDef;
import swim.util.Murmur3;

public class DbStoreDef
implements StoreDef,
Debug {
    protected final String storeName;
    protected final String path;
    protected final StoreSettings settings;
    private static int hashSeed;

    public DbStoreDef(String storeName, String path, StoreSettings settings) {
        this.storeName = storeName;
        this.path = path;
        this.settings = settings;
    }

    public final String storeName() {
        return this.storeName;
    }

    public DbStoreDef storeName(String storeName) {
        return this.copy(storeName, this.path, this.settings);
    }

    public final String path() {
        return this.path;
    }

    public DbStoreDef path(String path) {
        return this.copy(this.storeName, path, this.settings);
    }

    public final StoreSettings settings() {
        return this.settings;
    }

    public DbStoreDef settings(StoreSettings settings) {
        return this.copy(this.storeName, this.path, settings);
    }

    protected DbStoreDef copy(String storeName, String path, StoreSettings settings) {
        return new DbStoreDef(storeName, path, settings);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DbStoreDef) {
            DbStoreDef that = (DbStoreDef)other;
            return (this.storeName == null ? that.storeName == null : this.storeName.equals(that.storeName)) && this.path.equals(that.path) && this.settings.equals((Object)that.settings);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(DbStoreDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((Object)this.storeName)), (int)this.path.hashCode()), (int)this.settings.hashCode()));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("new").write(32).write("DbStoreDef").write(40).debug((Object)this.storeName).write(", ").debug((Object)this.path).write(", ").debug((Object)this.settings).write(41);
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

