/*
 * Decompiled with CFR 0.152.
 */
package swim.store.mem;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import swim.api.data.ListData;
import swim.collections.STreeList;
import swim.store.ListDataBinding;
import swim.store.ListDataContext;
import swim.store.ListDataView;
import swim.store.StoreBinding;
import swim.structure.Form;
import swim.structure.Value;
import swim.util.KeyedList;

public class ListDataModel
implements ListDataBinding {
    protected final Value name;
    protected final STreeList<Value> tree;
    protected ListDataContext dataContext;
    protected StoreBinding storeBinding;

    public ListDataModel(Value name, STreeList<Value> tree) {
        this.name = name;
        this.tree = tree;
    }

    public ListDataContext dataContext() {
        return this.dataContext;
    }

    public void setDataContext(ListDataContext dataContext) {
        this.dataContext = dataContext;
    }

    public StoreBinding storeBinding() {
        return this.storeBinding;
    }

    public void setStoreBinding(StoreBinding storeBinding) {
        this.storeBinding = storeBinding;
    }

    public <T> T unwrapData(Class<T> dataClass) {
        if (dataClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    public final STreeList<Value> tree() {
        return this.tree;
    }

    public final Value name() {
        return this.name;
    }

    public Form<Value> valueForm() {
        return Form.forValue();
    }

    public <V2> ListData<V2> valueForm(Form<V2> valueForm) {
        return new ListDataView((ListDataBinding)this, valueForm);
    }

    public <V2> ListData<V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public long dataSize() {
        return 0L;
    }

    public boolean isResident() {
        return true;
    }

    public ListDataModel isResident(boolean isResident) {
        return this;
    }

    public boolean isTransient() {
        return true;
    }

    public ListDataModel isTransient(boolean isTransient) {
        return this;
    }

    public int size() {
        return this.tree.size();
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean contains(Object value) {
        return this.tree.contains(value);
    }

    public boolean containsAll(Collection<?> values) {
        return this.tree.containsAll(values);
    }

    public int indexOf(Object value) {
        return this.tree.indexOf(value);
    }

    public int lastIndexOf(Object value) {
        return this.tree.lastIndexOf(value);
    }

    public Value get(int index) {
        return (Value)this.tree.get(index);
    }

    public Value set(int index, Value value) {
        return (Value)this.tree.set(index, (Object)value.commit());
    }

    public boolean add(Value value) {
        return this.tree.add((Object)value.commit());
    }

    public boolean addAll(Collection<? extends Value> values) {
        for (Value value : values) {
            value.commit();
        }
        return this.tree.addAll(values);
    }

    public void add(int index, Value value) {
        this.tree.add(index, (Object)value.commit());
    }

    public boolean addAll(int index, Collection<? extends Value> values) {
        return this.tree.addAll(index, values);
    }

    public Value remove(int index) {
        return (Value)this.tree.remove(index);
    }

    public boolean remove(Object value) {
        return this.tree.remove(value);
    }

    public boolean removeAll(Collection<?> values) {
        return this.tree.removeAll(values);
    }

    public boolean retainAll(Collection<?> values) {
        return this.tree.retainAll(values);
    }

    public void drop(int lower) {
        this.tree.drop(lower);
    }

    public void take(int upper) {
        this.tree.take(upper);
    }

    public void clear() {
        this.tree.clear();
    }

    public Iterator<Value> iterator() {
        return this.tree.iterator();
    }

    public ListIterator<Value> listIterator() {
        return this.tree.listIterator();
    }

    public ListIterator<Value> listIterator(int index) {
        return this.tree.listIterator(index);
    }

    public List<Value> subList(int fromIndex, int toIndex) {
        return this.tree.subList(fromIndex, toIndex);
    }

    public KeyedList<Value> snapshot() {
        return this.tree.snapshot();
    }

    public Object[] toArray() {
        return this.tree.toArray();
    }

    public <T> T[] toArray(T[] array) {
        return this.tree.toArray((Object[])array);
    }

    public void close() {
        StoreBinding storeBinding = this.storeBinding;
        if (storeBinding != null) {
            storeBinding.closeData(this.name);
        }
    }

    public Value get(int index, Object key) {
        return (Value)this.tree.get(index, key);
    }

    public Map.Entry<Object, Value> getEntry(int index) {
        return this.tree.getEntry(index);
    }

    public Map.Entry<Object, Value> getEntry(int index, Object key) {
        return this.tree.getEntry(index, key);
    }

    public Value set(int index, Value element, Object key) {
        return (Value)this.tree.set(index, (Object)element.commit(), key);
    }

    public boolean add(Value element, Object key) {
        return this.tree.add((Object)element.commit(), key);
    }

    public void add(int index, Value element, Object key) {
        this.tree.add(index, (Object)element.commit(), key);
    }

    public Value remove(int index, Object key) {
        return (Value)this.tree.remove(index, key);
    }

    public void move(int fromIndex, int toIndex) {
        this.tree.move(fromIndex, toIndex);
    }

    public void move(int fromIndex, int toIndex, Object key) {
        this.tree.move(fromIndex, toIndex, key);
    }

    public ListIterator<Object> keyIterator() {
        return this.tree.keyIterator();
    }

    public ListIterator<Map.Entry<Object, Value>> entryIterator() {
        return this.tree.entryIterator();
    }
}

