/*
 * Decompiled with CFR 0.152.
 */
package swim.store.mem;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import swim.api.data.MapData;
import swim.collections.BTreeMap;
import swim.store.MapDataBinding;
import swim.store.MapDataContext;
import swim.store.MapDataView;
import swim.store.StoreBinding;
import swim.structure.Form;
import swim.structure.Value;
import swim.util.Cursor;
import swim.util.OrderedMap;
import swim.util.OrderedMapCursor;

public class MapDataModel
implements MapDataBinding {
    protected final Value name;
    protected final BTreeMap<Value, Value, Value> tree;
    protected MapDataContext dataContext;
    protected StoreBinding storeBinding;

    public MapDataModel(Value name, BTreeMap<Value, Value, Value> tree) {
        this.name = name;
        this.tree = tree;
    }

    public MapDataContext dataContext() {
        return this.dataContext;
    }

    public void setDataContext(MapDataContext dataContext) {
        this.dataContext = dataContext;
    }

    public StoreBinding storeBinding() {
        return this.storeBinding;
    }

    public void setStoreBinding(StoreBinding storeBinding) {
        this.storeBinding = storeBinding;
    }

    public <T> T unwrapData(Class<T> dataClass) {
        if (dataClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    public final BTreeMap<Value, Value, Value> tree() {
        return this.tree;
    }

    public final Value name() {
        return this.name;
    }

    public Form<Value> keyForm() {
        return Form.forValue();
    }

    public <K2> MapData<K2, Value> keyForm(Form<K2> keyForm) {
        return new MapDataView((MapDataBinding)this, keyForm, Form.forValue());
    }

    public <K2> MapData<K2, Value> keyClass(Class<K2> keyClass) {
        return this.keyForm(Form.forClass(keyClass));
    }

    public Form<Value> valueForm() {
        return Form.forValue();
    }

    public <V2> MapData<Value, V2> valueForm(Form<V2> valueForm) {
        return new MapDataView((MapDataBinding)this, Form.forValue(), valueForm);
    }

    public <V2> MapData<Value, V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public long dataSize() {
        return 0L;
    }

    public boolean isResident() {
        return true;
    }

    public MapDataBinding isResident(boolean isResident) {
        return this;
    }

    public boolean isTransient() {
        return true;
    }

    public MapDataBinding isTransient(boolean isTransient) {
        return this;
    }

    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    public int size() {
        return this.tree.size();
    }

    public boolean containsKey(Object key) {
        return this.tree.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.tree.containsValue(value);
    }

    public int indexOf(Object key) {
        return this.tree.indexOf(key);
    }

    public Value get(Object key) {
        Value res = (Value)this.tree.get(key);
        if (res == null) {
            res = Value.absent();
        }
        return res;
    }

    public Map.Entry<Value, Value> getEntry(Object key) {
        return this.tree.getEntry(key);
    }

    public Map.Entry<Value, Value> getIndex(int index) {
        return this.tree.getIndex(index);
    }

    public Map.Entry<Value, Value> firstEntry() {
        return this.tree.firstEntry();
    }

    public Value firstKey() {
        Value res = (Value)this.tree.firstKey();
        if (res == null) {
            res = Value.absent();
        }
        return res;
    }

    public Value firstValue() {
        Value res = (Value)this.tree.firstValue();
        if (res == null) {
            res = Value.absent();
        }
        return res;
    }

    public Map.Entry<Value, Value> lastEntry() {
        return this.tree.lastEntry();
    }

    public Value lastKey() {
        Value res = (Value)this.tree.lastKey();
        if (res == null) {
            res = Value.absent();
        }
        return res;
    }

    public Value lastValue() {
        Value res = (Value)this.tree.lastValue();
        if (res == null) {
            res = Value.absent();
        }
        return res;
    }

    public Map.Entry<Value, Value> nextEntry(Value key) {
        return this.tree.nextEntry((Object)key);
    }

    public Value nextKey(Value key) {
        Value res = (Value)this.tree.nextKey((Object)key);
        if (res == null) {
            res = Value.absent();
        }
        return res;
    }

    public Value nextValue(Value key) {
        Value res = (Value)this.tree.nextValue((Object)key);
        if (res == null) {
            res = Value.absent();
        }
        return res;
    }

    public Map.Entry<Value, Value> previousEntry(Value key) {
        return this.tree.previousEntry((Object)key);
    }

    public Value previousKey(Value key) {
        Value res = (Value)this.tree.previousKey((Object)key);
        if (res == null) {
            res = Value.absent();
        }
        return res;
    }

    public Value previousValue(Value key) {
        Value res = (Value)this.tree.previousValue((Object)key);
        if (res == null) {
            res = Value.absent();
        }
        return res;
    }

    public Value put(Value key, Value value) {
        Value res = (Value)this.tree.put((Object)key.commit(), (Object)value.commit());
        if (res == null) {
            res = Value.absent();
        }
        return res;
    }

    public void putAll(Map<? extends Value, ? extends Value> items) {
        for (Map.Entry<? extends Value, ? extends Value> entry : items.entrySet()) {
            entry.getKey().commit();
            entry.getValue().commit();
        }
        this.tree.putAll(items);
    }

    public Value remove(Object key) {
        Value res = (Value)this.tree.remove(key);
        if (res == null) {
            res = Value.absent();
        }
        return res;
    }

    public void drop(int lower) {
        this.tree.drop(lower);
    }

    public void take(int upper) {
        this.tree.take(upper);
    }

    public void clear() {
        this.tree.clear();
    }

    public OrderedMap<Value, Value> headMap(Value toKey) {
        return this.tree.headMap((Object)toKey);
    }

    public OrderedMap<Value, Value> tailMap(Value fromKey) {
        return this.tree.tailMap((Object)fromKey);
    }

    public OrderedMap<Value, Value> subMap(Value fromKey, Value toKey) {
        return this.tree.subMap((Object)fromKey, (Object)toKey);
    }

    public Set<Map.Entry<Value, Value>> entrySet() {
        return this.tree.entrySet();
    }

    public Set<Value> keySet() {
        return this.tree.keySet();
    }

    public Collection<Value> values() {
        return this.tree.values();
    }

    public OrderedMapCursor<Value, Value> iterator() {
        return this.tree.iterator();
    }

    public Cursor<Value> keyIterator() {
        return this.tree.keyIterator();
    }

    public Cursor<Value> valueIterator() {
        return this.tree.valueIterator();
    }

    public OrderedMap<Value, Value> snapshot() {
        return this.tree.snapshot();
    }

    public Comparator<? super Value> comparator() {
        return this.tree.comparator();
    }

    public void close() {
        StoreBinding storeBinding = this.storeBinding;
        if (storeBinding != null) {
            storeBinding.closeData(this.name);
        }
    }
}

