/*
 * Decompiled with CFR 0.152.
 */
package swim.store.mem;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.data.ListData;
import swim.api.data.MapData;
import swim.api.data.SpatialData;
import swim.api.data.ValueData;
import swim.collections.BTreeMap;
import swim.collections.HashTrieMap;
import swim.collections.STreeList;
import swim.math.R2Shape;
import swim.math.Z2Form;
import swim.spatial.GeoProjection;
import swim.spatial.QTreeMap;
import swim.store.DataBinding;
import swim.store.ListDataBinding;
import swim.store.MapDataBinding;
import swim.store.SpatialDataBinding;
import swim.store.StoreBinding;
import swim.store.StoreContext;
import swim.store.ValueDataBinding;
import swim.store.mem.ListDataModel;
import swim.store.mem.MapDataModel;
import swim.store.mem.SpatialDataModel;
import swim.store.mem.ValueDataModel;
import swim.structure.Text;
import swim.structure.Value;

public class MemStore
implements StoreBinding,
StoreContext {
    static final AtomicReferenceFieldUpdater<MemStore, HashTrieMap<Value, StoreBinding>> STORES = AtomicReferenceFieldUpdater.newUpdater(MemStore.class, HashTrieMap.class, "stores");
    static final AtomicReferenceFieldUpdater<MemStore, HashTrieMap<Value, DataBinding>> TREES = AtomicReferenceFieldUpdater.newUpdater(MemStore.class, HashTrieMap.class, "trees");
    protected StoreContext storeContext;
    volatile HashTrieMap<Value, StoreBinding> stores = HashTrieMap.empty();
    volatile HashTrieMap<Value, DataBinding> trees = HashTrieMap.empty();

    public StoreContext storeContext() {
        return this.storeContext != null ? this.storeContext : this;
    }

    public void setStoreContext(StoreContext storeContext) {
        this.storeContext = storeContext;
    }

    public Iterator<DataBinding> dataBindings() {
        return this.trees.valueIterator();
    }

    public void closeData(Value name) {
        HashTrieMap newTrees;
        HashTrieMap<Value, DataBinding> oldTrees;
        while ((oldTrees = this.trees) != (newTrees = oldTrees.removed((Object)name)) && !TREES.compareAndSet(this, oldTrees, (HashTrieMap<Value, DataBinding>)newTrees)) {
        }
    }

    public void close() {
    }

    public StoreBinding openStore(Value name) {
        HashTrieMap newStores;
        HashTrieMap<Value, StoreBinding> oldStores;
        StoreBinding store = null;
        do {
            StoreBinding oldStore;
            if ((oldStore = (StoreBinding)(oldStores = this.stores).get((Object)name)) != null) {
                store = oldStore;
                break;
            }
            if (store != null) continue;
            store = new MemStore();
        } while (!STORES.compareAndSet(this, oldStores, (HashTrieMap<Value, StoreBinding>)(newStores = oldStores.updated((Object)name, (Object)store))));
        return store;
    }

    public StoreBinding injectStore(StoreBinding storeBinding) {
        return storeBinding;
    }

    public ListDataBinding openListData(Value name) {
        HashTrieMap newTrees;
        HashTrieMap<Value, DataBinding> oldTrees;
        ListDataModel tree = null;
        do {
            DataBinding oldTree;
            if ((oldTree = (DataBinding)(oldTrees = this.trees).get((Object)name)) != null) {
                tree = (ListDataModel)oldTree;
                break;
            }
            if (tree != null) continue;
            tree = new ListDataModel(name, (STreeList<Value>)new STreeList());
        } while (!TREES.compareAndSet(this, oldTrees, (HashTrieMap<Value, DataBinding>)(newTrees = oldTrees.updated((Object)name, (Object)tree))));
        return tree;
    }

    public ListDataBinding injectListData(ListDataBinding dataBinding) {
        return dataBinding;
    }

    public MapDataBinding openMapData(Value name) {
        HashTrieMap newTrees;
        HashTrieMap<Value, DataBinding> oldTrees;
        MapDataModel tree = null;
        do {
            DataBinding oldTree;
            if ((oldTree = (DataBinding)(oldTrees = this.trees).get((Object)name)) != null) {
                tree = (MapDataModel)oldTree;
                break;
            }
            if (tree != null) continue;
            tree = new MapDataModel(name, (BTreeMap<Value, Value, Value>)new BTreeMap());
        } while (!TREES.compareAndSet(this, oldTrees, (HashTrieMap<Value, DataBinding>)(newTrees = oldTrees.updated((Object)name, (Object)tree))));
        return tree;
    }

    public MapDataBinding injectMapData(MapDataBinding dataBinding) {
        return dataBinding;
    }

    public <S> SpatialDataBinding<S> openSpatialData(Value name, Z2Form<S> shapeForm) {
        HashTrieMap newTrees;
        HashTrieMap<Value, DataBinding> oldTrees;
        SpatialDataModel tree = null;
        do {
            DataBinding oldTree;
            if ((oldTree = (DataBinding)(oldTrees = this.trees).get((Object)name)) != null) {
                tree = (SpatialDataModel)oldTree;
                break;
            }
            if (tree != null) continue;
            tree = new SpatialDataModel(name, new QTreeMap(shapeForm));
        } while (!TREES.compareAndSet(this, oldTrees, (HashTrieMap<Value, DataBinding>)(newTrees = oldTrees.updated((Object)name, (Object)tree))));
        return tree;
    }

    public <S> SpatialDataBinding<S> injectSpatialData(SpatialDataBinding<S> dataBinding) {
        return dataBinding;
    }

    public ValueDataBinding openValueData(Value name) {
        HashTrieMap newTrees;
        HashTrieMap<Value, DataBinding> oldTrees;
        ValueDataModel tree = null;
        do {
            DataBinding oldTree;
            if ((oldTree = (DataBinding)(oldTrees = this.trees).get((Object)name)) != null) {
                tree = (ValueDataModel)oldTree;
                break;
            }
            if (tree != null) continue;
            tree = new ValueDataModel(name, Value.absent());
        } while (!TREES.compareAndSet(this, oldTrees, (HashTrieMap<Value, DataBinding>)(newTrees = oldTrees.updated((Object)name, (Object)tree))));
        return tree;
    }

    public ValueDataBinding injectValueData(ValueDataBinding dataBinding) {
        return dataBinding;
    }

    public ListData<Value> listData(Value name) {
        ListDataBinding dataBinding = this.openListData(name);
        dataBinding = this.injectListData(dataBinding);
        return dataBinding;
    }

    public ListData<Value> listData(String name) {
        return this.listData((Value)Text.from((String)name));
    }

    public MapData<Value, Value> mapData(Value name) {
        MapDataBinding dataBinding = this.openMapData(name);
        dataBinding = this.injectMapData(dataBinding);
        return dataBinding;
    }

    public MapData<Value, Value> mapData(String name) {
        return this.mapData((Value)Text.from((String)name));
    }

    public <S> SpatialData<Value, S, Value> spatialData(Value name, Z2Form<S> shapeForm) {
        SpatialDataBinding<S> dataBinding = this.openSpatialData(name, shapeForm);
        dataBinding = this.injectSpatialData(dataBinding);
        return dataBinding;
    }

    public <S> SpatialData<Value, S, Value> spatialData(String name, Z2Form<S> shapeForm) {
        return this.spatialData((Value)Text.from((String)name), shapeForm);
    }

    public SpatialData<Value, R2Shape, Value> geospatialData(Value name) {
        return this.spatialData(name, GeoProjection.wgs84Form());
    }

    public SpatialData<Value, R2Shape, Value> geospatialData(String name) {
        return this.geospatialData((Value)Text.from((String)name));
    }

    public ValueData<Value> valueData(Value name) {
        ValueDataBinding dataBinding = this.openValueData(name);
        dataBinding = this.injectValueData(dataBinding);
        return dataBinding;
    }

    public ValueData<Value> valueData(String name) {
        return this.valueData((Value)Text.from((String)name));
    }
}

