/*
 * Decompiled with CFR 0.152.
 */
package swim.store.mem;

import java.util.Iterator;
import swim.api.data.SpatialData;
import swim.math.Z2Form;
import swim.spatial.QTreeMap;
import swim.spatial.SpatialMap;
import swim.store.SpatialDataBinding;
import swim.store.SpatialDataContext;
import swim.store.SpatialDataView;
import swim.store.StoreBinding;
import swim.structure.Form;
import swim.structure.Value;

public class SpatialDataModel<S>
implements SpatialDataBinding<S> {
    protected final Value name;
    protected final QTreeMap<Value, S, Value> tree;
    protected SpatialDataContext<S> dataContext;
    protected StoreBinding storeBinding;

    public SpatialDataModel(Value name, QTreeMap<Value, S, Value> tree) {
        this.name = name;
        this.tree = tree;
    }

    public SpatialDataContext<S> dataContext() {
        return this.dataContext;
    }

    public void setDataContext(SpatialDataContext<S> dataContext) {
        this.dataContext = dataContext;
    }

    public StoreBinding storeBinding() {
        return this.storeBinding;
    }

    public void setStoreBinding(StoreBinding storeBinding) {
        this.storeBinding = storeBinding;
    }

    public <T> T unwrapData(Class<T> dataClass) {
        if (dataClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    public final QTreeMap<Value, S, Value> tree() {
        return this.tree;
    }

    public final Value name() {
        return this.name;
    }

    public Form<Value> keyForm() {
        return Form.forValue();
    }

    public <K2> SpatialData<K2, S, Value> keyForm(Form<K2> keyForm) {
        return new SpatialDataView((SpatialDataBinding)this, keyForm, Form.forValue());
    }

    public <K2> SpatialData<K2, S, Value> keyClass(Class<K2> keyClass) {
        return this.keyForm(Form.forClass(keyClass));
    }

    public long dataSize() {
        return 0L;
    }

    public final Z2Form<S> shapeForm() {
        return this.tree.shapeForm();
    }

    public Form<Value> valueForm() {
        return Form.forValue();
    }

    public <V2> SpatialData<Value, S, V2> valueForm(Form<V2> valueForm) {
        return new SpatialDataView((SpatialDataBinding)this, Form.forValue(), valueForm);
    }

    public <V2> SpatialData<Value, S, V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public boolean isResident() {
        return true;
    }

    public SpatialDataBinding<S> isResident(boolean isResident) {
        return this;
    }

    public boolean isTransient() {
        return true;
    }

    public SpatialDataBinding<S> isTransient(boolean isTransient) {
        return this;
    }

    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    public int size() {
        return this.tree.size();
    }

    public boolean containsKey(Value key, S shape) {
        return this.tree.containsKey((Object)key, shape);
    }

    public boolean containsKey(Object key) {
        return this.tree.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.tree.containsValue(value);
    }

    public Value get(Value key, S shape) {
        return (Value)this.tree.get((Object)key.commit(), shape);
    }

    public Value get(Object key) {
        return (Value)this.tree.get(key);
    }

    public Value put(Value key, S shape, Value newValue) {
        return (Value)this.tree.put((Object)key.commit(), shape, (Object)newValue.commit());
    }

    public Value move(Value key, S oldShape, S newShape, Value newValue) {
        return (Value)this.tree.move((Object)key.commit(), oldShape, newShape, (Object)newValue.commit());
    }

    public Value remove(Value key, S shape) {
        return (Value)this.tree.remove((Object)key, shape);
    }

    public void clear() {
        this.tree.clear();
    }

    public Iterator<SpatialMap.Entry<Value, S, Value>> iterator(S shape) {
        return this.tree.iterator(shape);
    }

    public Iterator<SpatialMap.Entry<Value, S, Value>> iterator() {
        return this.tree.iterator();
    }

    public Iterator<Value> keyIterator() {
        return this.tree.keyIterator();
    }

    public Iterator<Value> valueIterator() {
        return this.tree.valueIterator();
    }

    public SpatialMap<Value, S, Value> snapshot() {
        return this.tree.snapshot();
    }

    public void close() {
        StoreBinding storeBinding = this.storeBinding;
        if (storeBinding != null) {
            storeBinding.closeData(this.name);
        }
    }
}

