/*
 * Decompiled with CFR 0.152.
 */
package swim.store.mem;

import swim.kernel.KernelProxy;
import swim.store.StoreBinding;
import swim.store.StoreDef;
import swim.store.mem.MemStore;
import swim.structure.Value;
import swim.system.CellAddress;
import swim.system.EdgeAddress;

public class MemStoreKernel
extends KernelProxy {
    final double kernelPriority;
    private static final double KERNEL_PRIORITY = -1.0;

    public MemStoreKernel(double kernelPriority) {
        this.kernelPriority = kernelPriority;
    }

    public MemStoreKernel() {
        this(-1.0);
    }

    public final double kernelPriority() {
        return this.kernelPriority;
    }

    public StoreBinding createStore(StoreDef storeDef, ClassLoader classLoader) {
        StoreBinding store = super.createStore(storeDef, classLoader);
        if (store == null) {
            store = new MemStore();
        }
        return store;
    }

    public StoreBinding createStore(CellAddress cellAddress) {
        StoreBinding store = super.createStore(cellAddress);
        if (store == null && cellAddress instanceof EdgeAddress) {
            store = new MemStore();
        }
        return store;
    }

    public static MemStoreKernel fromValue(Value moduleConfig) {
        Value header = moduleConfig.getAttr("kernel");
        String kernelClassName = header.get("class").stringValue(null);
        if (kernelClassName == null || MemStoreKernel.class.getName().equals(kernelClassName)) {
            double kernelPriority = header.get("priority").doubleValue(-1.0);
            return new MemStoreKernel(kernelPriority);
        }
        return null;
    }
}

