/*
 * Decompiled with CFR 0.152.
 */
package swim.store.mem;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.data.ValueData;
import swim.store.StoreBinding;
import swim.store.ValueDataBinding;
import swim.store.ValueDataContext;
import swim.store.ValueDataView;
import swim.structure.Form;
import swim.structure.Value;

public class ValueDataModel
implements ValueDataBinding {
    protected final Value name;
    protected volatile Value value;
    protected ValueDataContext dataContext;
    protected StoreBinding storeBinding;
    static final AtomicReferenceFieldUpdater<ValueDataModel, Value> VALUE = AtomicReferenceFieldUpdater.newUpdater(ValueDataModel.class, Value.class, "value");

    public ValueDataModel(Value name, Value value) {
        this.name = name;
        this.value = value.commit();
        this.dataContext = null;
        this.storeBinding = null;
    }

    public ValueDataContext dataContext() {
        return this.dataContext;
    }

    public void setDataContext(ValueDataContext dataContext) {
        this.dataContext = dataContext;
    }

    public StoreBinding storeBinding() {
        return this.storeBinding;
    }

    public void setStoreBinding(StoreBinding storeBinding) {
        this.storeBinding = storeBinding;
    }

    public <T> T unwrapData(Class<T> dataClass) {
        if (dataClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    public Value name() {
        return this.name;
    }

    public long dataSize() {
        return 0L;
    }

    public Form<Value> valueForm() {
        return Form.forValue();
    }

    public <V2> ValueData<V2> valueForm(Form<V2> valueForm) {
        return new ValueDataView((ValueDataBinding)this, valueForm);
    }

    public <V2> ValueData<V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public boolean isResident() {
        return true;
    }

    public ValueDataBinding isResident(boolean isResident) {
        return this;
    }

    public boolean isTransient() {
        return true;
    }

    public ValueDataBinding isTransient(boolean isTransient) {
        return this;
    }

    public Value get() {
        return VALUE.get(this);
    }

    public Value set(Value newValue) {
        Value oldValue;
        while (!(oldValue = VALUE.get(this)).equals((Object)newValue)) {
            if (!VALUE.compareAndSet(this, oldValue, newValue.commit())) continue;
            return oldValue;
        }
        return oldValue;
    }

    public void close() {
        StoreBinding storeBinding = this.storeBinding;
        if (storeBinding != null) {
            storeBinding.closeData(this.name);
        }
    }
}

