/*
 * Decompiled with CFR 0.152.
 */
package swim.streamlet;

import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.Map;
import swim.streamlet.GenericStreamlet;
import swim.streamlet.In;
import swim.streamlet.Inlet;
import swim.streamlet.Inout;
import swim.streamlet.Inoutlet;
import swim.streamlet.MapInlet;
import swim.streamlet.MapInoutlet;
import swim.streamlet.MapOutlet;
import swim.streamlet.Out;
import swim.streamlet.Outlet;
import swim.streamlet.Streamlet;
import swim.streamlet.StreamletContext;
import swim.streamlet.StreamletException;
import swim.streamlet.StreamletInlet;
import swim.streamlet.StreamletInoutlet;
import swim.streamlet.StreamletOutlet;
import swim.streamlet.StreamletScope;

public abstract class AbstractStreamlet<I, O>
implements GenericStreamlet<I, O> {
    protected StreamletScope<? extends O> scope;
    protected StreamletContext context;
    protected int version;

    public AbstractStreamlet(StreamletScope<? extends O> scope) {
        this.scope = scope;
        this.version = -1;
    }

    public AbstractStreamlet() {
        this(null);
    }

    public static <I, O> void disconnectInputs(Streamlet<I, O> streamlet, Class<?> streamletClass) {
        while (streamletClass != null) {
            Field[] fields;
            for (Field field : fields = streamletClass.getDeclaredFields()) {
                if (!Inlet.class.isAssignableFrom(field.getType())) continue;
                AbstractStreamlet.disconnectInputField(streamlet, field);
            }
            streamletClass = streamletClass.getSuperclass();
        }
    }

    private static <I, O> void disconnectInputField(Streamlet<I, O> streamlet, Field field) {
        if (field.getAnnotation(Out.class) != null) {
            Inlet<I> inlet = AbstractStreamlet.reflectInletField(streamlet, field);
            inlet.disconnectInputs();
        } else if (field.getAnnotation(Inout.class) != null) {
            Inoutlet<I, O> inoutlet = AbstractStreamlet.reflectInoutletField(streamlet, field);
            inoutlet.disconnectInputs();
        }
    }

    public static <I, O> void disconnectOutputs(Streamlet<I, O> streamlet, Class<?> streamletClass) {
        while (streamletClass != null) {
            Field[] fields;
            for (Field field : fields = streamletClass.getDeclaredFields()) {
                if (!Outlet.class.isAssignableFrom(field.getType())) continue;
                AbstractStreamlet.disconnectOutputField(streamlet, field);
            }
            streamletClass = streamletClass.getSuperclass();
        }
    }

    private static <I, O> void disconnectOutputField(Streamlet<I, O> streamlet, Field field) {
        if (field.getAnnotation(Out.class) != null) {
            Outlet<O> outlet = AbstractStreamlet.reflectOutletField(streamlet, field);
            outlet.disconnectOutputs();
        } else if (field.getAnnotation(Inout.class) != null) {
            Inoutlet<I, O> inoutlet = AbstractStreamlet.reflectInoutletField(streamlet, field);
            inoutlet.disconnectOutputs();
        }
    }

    public static <I, O> void invalidateOutlets(Streamlet<I, O> streamlet, Class<?> streamletClass) {
        while (streamletClass != null) {
            Field[] fields;
            for (Field field : fields = streamletClass.getDeclaredFields()) {
                if (!Outlet.class.isAssignableFrom(field.getType())) continue;
                AbstractStreamlet.invalidateOutletField(streamlet, field);
            }
            streamletClass = streamletClass.getSuperclass();
        }
    }

    private static <I, O> void invalidateOutletField(Streamlet<I, O> streamlet, Field field) {
        if (field.getAnnotation(Out.class) != null) {
            Outlet<O> outlet = AbstractStreamlet.reflectOutletField(streamlet, field);
            outlet.invalidateInput();
        } else if (field.getAnnotation(Inout.class) != null) {
            Inoutlet<I, O> inoutlet = AbstractStreamlet.reflectInoutletField(streamlet, field);
            inoutlet.invalidateInput();
        }
    }

    public static <I, O> void reconcileInlets(int version, Streamlet<I, O> streamlet, Class<?> streamletClass) {
        while (streamletClass != null) {
            Field[] fields;
            for (Field field : fields = streamletClass.getDeclaredFields()) {
                if (!Inlet.class.isAssignableFrom(field.getType())) continue;
                AbstractStreamlet.reconcileInletField(version, streamlet, field);
            }
            streamletClass = streamletClass.getSuperclass();
        }
    }

    private static <I, O> void reconcileInletField(int version, Streamlet<I, O> streamlet, Field field) {
        if (field.getAnnotation(In.class) != null) {
            Inlet<I> inlet = AbstractStreamlet.reflectInletField(streamlet, field);
            inlet.reconcileOutput(version);
        } else if (field.getAnnotation(Inout.class) != null) {
            Inoutlet<I, O> inoutlet = AbstractStreamlet.reflectInoutletField(streamlet, field);
            inoutlet.reconcileOutput(version);
        }
    }

    public static <I, O> void reconcileOutlets(int version, Streamlet<I, O> streamlet, Class<?> streamletClass) {
        while (streamletClass != null) {
            Field[] fields;
            for (Field field : fields = streamletClass.getDeclaredFields()) {
                if (!Outlet.class.isAssignableFrom(field.getType())) continue;
                AbstractStreamlet.reconcileOutletField(version, streamlet, field);
            }
            streamletClass = streamletClass.getSuperclass();
        }
    }

    private static <I, O> void reconcileOutletField(int version, Streamlet<I, O> streamlet, Field field) {
        if (field.getAnnotation(Out.class) != null) {
            Outlet<O> outlet = AbstractStreamlet.reflectOutletField(streamlet, field);
            outlet.reconcileInput(version);
        } else if (field.getAnnotation(Inout.class) != null) {
            Inoutlet<I, O> inoutlet = AbstractStreamlet.reflectInoutletField(streamlet, field);
            inoutlet.reconcileInput(version);
        }
    }

    public static <I, O> int reflectInletCount(Class<?> streamletClass) {
        int count = 0;
        while (streamletClass != null) {
            Field[] fields;
            for (Field field : fields = streamletClass.getDeclaredFields()) {
                if (!Inlet.class.isAssignableFrom(field.getType())) continue;
                In in = field.getAnnotation(In.class);
                if (in != null) {
                    ++count;
                    continue;
                }
                Inout inout = field.getAnnotation(Inout.class);
                if (inout == null) continue;
                ++count;
            }
            streamletClass = streamletClass.getSuperclass();
        }
        return count;
    }

    public static <I, O> int reflectOutletCount(Class<?> streamletClass) {
        int count = 0;
        while (streamletClass != null) {
            Field[] fields;
            for (Field field : fields = streamletClass.getDeclaredFields()) {
                if (!Outlet.class.isAssignableFrom(field.getType())) continue;
                Out out = field.getAnnotation(Out.class);
                if (out != null) {
                    ++count;
                    continue;
                }
                Inout inout = field.getAnnotation(Inout.class);
                if (inout == null) continue;
                ++count;
            }
            streamletClass = streamletClass.getSuperclass();
        }
        return count;
    }

    public static <I, O> Map.Entry<String, Inlet<I>> reflectInletIndex(int index, Streamlet<I, O> streamlet, Class<?> streamletClass) {
        while (streamletClass != null) {
            Field[] fields;
            for (Field field : fields = streamletClass.getDeclaredFields()) {
                if (!Inlet.class.isAssignableFrom(field.getType())) continue;
                In in = field.getAnnotation(In.class);
                if (in != null) {
                    if (index == 0) {
                        return new AbstractMap.SimpleImmutableEntry<String, Inlet<I>>(field.getName(), AbstractStreamlet.reflectInletField(streamlet, field));
                    }
                    --index;
                    continue;
                }
                Inout inout = field.getAnnotation(Inout.class);
                if (inout == null) continue;
                if (index == 0) {
                    return new AbstractMap.SimpleImmutableEntry<String, Inlet<I>>(field.getName(), AbstractStreamlet.reflectInoutletField(streamlet, field));
                }
                --index;
            }
            streamletClass = streamletClass.getSuperclass();
        }
        return null;
    }

    public static <I, O> Map.Entry<String, Outlet<O>> reflectOutletIndex(int index, Streamlet<I, O> streamlet, Class<?> streamletClass) {
        while (streamletClass != null) {
            Field[] fields;
            for (Field field : fields = streamletClass.getDeclaredFields()) {
                if (!Outlet.class.isAssignableFrom(field.getType())) continue;
                Out out = field.getAnnotation(Out.class);
                if (out != null) {
                    if (index == 0) {
                        return new AbstractMap.SimpleImmutableEntry<String, Outlet<O>>(field.getName(), AbstractStreamlet.reflectOutletField(streamlet, field));
                    }
                    --index;
                    continue;
                }
                Inout inout = field.getAnnotation(Inout.class);
                if (inout == null) continue;
                if (index == 0) {
                    return new AbstractMap.SimpleImmutableEntry<String, Outlet<O>>(field.getName(), AbstractStreamlet.reflectInoutletField(streamlet, field));
                }
                --index;
            }
            streamletClass = streamletClass.getSuperclass();
        }
        return null;
    }

    public static <I, O> Inlet<I> reflectInletKey(String key, Streamlet<I, O> streamlet, Class<?> streamletClass) {
        while (streamletClass != null) {
            Field[] fields;
            for (Field field : fields = streamletClass.getDeclaredFields()) {
                Inlet<I> inlet;
                if (!Inlet.class.isAssignableFrom(field.getType()) || (inlet = AbstractStreamlet.reflectInletKeyField(key, streamlet, field)) == null) continue;
                return inlet;
            }
            streamletClass = streamletClass.getSuperclass();
        }
        return null;
    }

    private static <I, O> Inlet<I> reflectInletKeyField(String key, Streamlet<I, O> streamlet, Field field) {
        String name;
        String name2;
        In in = field.getAnnotation(In.class);
        if (in != null && ((name2 = in.value()).equals(key) || name2.isEmpty() && field.getName().equals(key))) {
            return AbstractStreamlet.reflectInletField(streamlet, field);
        }
        Inout inout = field.getAnnotation(Inout.class);
        if (inout != null && ((name = inout.value()).equals(key) || name.isEmpty() && field.getName().equals(key))) {
            return AbstractStreamlet.reflectInoutletField(streamlet, field);
        }
        return null;
    }

    public static <I, O> Outlet<O> reflectOutletKey(String key, Streamlet<I, O> streamlet, Class<?> streamletClass) {
        while (streamletClass != null) {
            Field[] fields;
            for (Field field : fields = streamletClass.getDeclaredFields()) {
                Outlet<O> outlet;
                if (!Outlet.class.isAssignableFrom(field.getType()) || (outlet = AbstractStreamlet.reflectOutletKeyField(key, streamlet, field)) == null) continue;
                return outlet;
            }
            streamletClass = streamletClass.getSuperclass();
        }
        return null;
    }

    private static <I, O> Outlet<O> reflectOutletKeyField(String key, Streamlet<I, O> streamlet, Field field) {
        String name;
        String name2;
        Out out = field.getAnnotation(Out.class);
        if (out != null && ((name2 = out.value()).equals(key) || name2.isEmpty() && field.getName().equals(key))) {
            return AbstractStreamlet.reflectOutletField(streamlet, field);
        }
        Inout inout = field.getAnnotation(Inout.class);
        if (inout != null && ((name = inout.value()).equals(key) || name.isEmpty() && field.getName().equals(key))) {
            return AbstractStreamlet.reflectInoutletField(streamlet, field);
        }
        return null;
    }

    public static <I, O> Inlet<I> reflectInletField(Streamlet<I, O> streamlet, Field field) {
        field.setAccessible(true);
        if (MapInlet.class.isAssignableFrom(field.getType())) {
            return AbstractStreamlet.reflectMapInletField(streamlet, field);
        }
        return AbstractStreamlet.reflectValueInletField(streamlet, field);
    }

    private static <I, O> Inlet<I> reflectValueInletField(Streamlet<I, O> streamlet, Field field) {
        try {
            Inlet inlet = (Inlet)field.get(streamlet);
            if (inlet == null) {
                inlet = streamlet instanceof AbstractStreamlet ? ((AbstractStreamlet)streamlet).inlet() : new StreamletInlet(streamlet);
                field.set(streamlet, inlet);
            }
            return inlet;
        }
        catch (IllegalAccessException cause) {
            throw new StreamletException(cause);
        }
    }

    private static <I, O> Inlet<I> reflectMapInletField(Streamlet<I, O> streamlet, Field field) {
        return null;
    }

    public static <I, O> Outlet<O> reflectOutletField(Streamlet<I, O> streamlet, Field field) {
        field.setAccessible(true);
        if (MapOutlet.class.isAssignableFrom(field.getType())) {
            return AbstractStreamlet.reflectMapOutletField(streamlet, field);
        }
        return AbstractStreamlet.reflectValueOutletField(streamlet, field);
    }

    private static <I, O> Outlet<O> reflectValueOutletField(Streamlet<I, O> streamlet, Field field) {
        try {
            Outlet outlet = (Outlet)field.get(streamlet);
            if (outlet == null) {
                outlet = streamlet instanceof AbstractStreamlet ? ((AbstractStreamlet)streamlet).outlet() : new StreamletOutlet(streamlet);
                field.set(streamlet, outlet);
            }
            return outlet;
        }
        catch (IllegalAccessException cause) {
            throw new StreamletException(cause);
        }
    }

    private static <I, O> Outlet<O> reflectMapOutletField(Streamlet<I, O> streamlet, Field field) {
        return null;
    }

    public static <I, O> Inoutlet<I, O> reflectInoutletField(Streamlet<I, O> streamlet, Field field) {
        field.setAccessible(true);
        if (MapInoutlet.class.isAssignableFrom(field.getType())) {
            return AbstractStreamlet.reflectMapInoutletField(streamlet, field);
        }
        return AbstractStreamlet.reflectValueInoutletField(streamlet, field);
    }

    private static <I, O> Inoutlet<I, O> reflectValueInoutletField(Streamlet<I, O> streamlet, Field field) {
        try {
            Inoutlet inoutlet = (Inoutlet)field.get(streamlet);
            if (inoutlet == null) {
                inoutlet = streamlet instanceof AbstractStreamlet ? ((AbstractStreamlet)streamlet).inoutlet() : new StreamletInoutlet(streamlet);
                field.set(streamlet, inoutlet);
            }
            return inoutlet;
        }
        catch (IllegalAccessException cause) {
            throw new StreamletException(cause);
        }
    }

    private static <I, O> Inoutlet<I, O> reflectMapInoutletField(Streamlet<I, O> streamlet, Field field) {
        return null;
    }

    @Override
    public StreamletScope<? extends O> streamletScope() {
        return this.scope;
    }

    @Override
    public void setStreamletScope(StreamletScope<? extends O> scope) {
        this.scope = scope;
    }

    @Override
    public StreamletContext streamletContext() {
        if (this.context != null) {
            return this.context;
        }
        StreamletScope<O> scope = this.streamletScope();
        if (scope != null) {
            return scope.streamletContext();
        }
        return null;
    }

    @Override
    public void setStreamletContext(StreamletContext context) {
        this.context = context;
    }

    @Override
    public Inlet<I> inlet(String key) {
        return AbstractStreamlet.reflectInletKey(key, this, this.getClass());
    }

    protected <I2 extends I> Inlet<I2> inlet() {
        return new StreamletInlet(this);
    }

    @Override
    public void bindInput(String key, Outlet<? extends I> input) {
        Inlet<? extends I> inlet = this.inlet(key);
        if (inlet == null) {
            throw new IllegalArgumentException(key.toString());
        }
        inlet.bindInput(input);
    }

    @Override
    public void unbindInput(String key) {
        Inlet<I> inlet = this.inlet(key);
        if (inlet == null) {
            throw new IllegalArgumentException(key.toString());
        }
        inlet.unbindInput();
    }

    @Override
    public Outlet<O> outlet(String key) {
        return AbstractStreamlet.reflectOutletKey(key, this, this.getClass());
    }

    protected <O2> Outlet<O2> outlet() {
        return new StreamletOutlet(this);
    }

    protected <I2 extends I, O2> Inoutlet<I2, O2> inoutlet() {
        return new StreamletInoutlet(this);
    }

    @Override
    public void invalidate() {
        if (this.version >= 0) {
            this.willInvalidate();
            this.version = -1;
            this.onInvalidate();
            this.onInvalidateOutlets();
            this.didInvalidate();
        }
    }

    @Override
    public void reconcile(int version) {
        if (this.version < 0) {
            this.willReconcile(version);
            this.version = version;
            this.onReconcileInlets(version);
            this.onReconcile(version);
            this.onReconcileOutlets(version);
            this.didReconcile(version);
        }
    }

    public <I2 extends I> I2 getInput(Inlet<I2> inlet) {
        Outlet<I2> input = inlet.input();
        if (input != null) {
            return input.get();
        }
        return null;
    }

    public <I2 extends I> I2 getInput(String key) {
        Inlet<I> inlet = this.inlet(key);
        if (inlet != null) {
            return (I2)this.getInput(inlet);
        }
        return null;
    }

    public <I2 extends I> I2 getInput(Inlet<I2> inlet, I2 orElse) {
        I2 input = this.getInput(inlet);
        if (input == null) {
            input = orElse;
        }
        return input;
    }

    public <I2 extends I> I2 getInput(String key, I2 orElse) {
        I2 input = this.getInput(key);
        if (input == null) {
            input = orElse;
        }
        return input;
    }

    @Override
    public O getOutput(Outlet<? super O> outlet) {
        return null;
    }

    public O getOutput(String key) {
        Outlet<O> outlet = this.outlet(key);
        if (outlet != null) {
            return this.getOutput(outlet);
        }
        return null;
    }

    @Override
    public void disconnectInputs() {
        AbstractStreamlet.disconnectInputs(this, this.getClass());
    }

    @Override
    public void disconnectOutputs() {
        AbstractStreamlet.disconnectOutputs(this, this.getClass());
    }

    @Override
    public void willInvalidateInlet(Inlet<? extends I> inlet) {
    }

    @Override
    public void didInvalidateInlet(Inlet<? extends I> inlet) {
        this.invalidate();
    }

    @Override
    public void willReconcileInlet(Inlet<? extends I> inlet, int version) {
    }

    @Override
    public void didReconcileInlet(Inlet<? extends I> inlet, int version) {
        this.reconcile(version);
    }

    @Override
    public void willInvalidateOutlet(Outlet<? super O> outlet) {
    }

    @Override
    public void didInvalidateOutlet(Outlet<? super O> outlet) {
    }

    @Override
    public void willReconcileOutlet(Outlet<? super O> outlet, int version) {
    }

    @Override
    public void didReconcileOutlet(Outlet<? super O> outlet, int version) {
    }

    protected void willInvalidate() {
    }

    protected void onInvalidate() {
    }

    protected void onInvalidateOutlets() {
        AbstractStreamlet.invalidateOutlets(this, this.getClass());
    }

    protected void didInvalidate() {
    }

    protected void willReconcile(int version) {
    }

    protected void onReconcileInlets(int version) {
        AbstractStreamlet.reconcileInlets(version, this, this.getClass());
    }

    protected void onReconcile(int version) {
    }

    protected void onReconcileOutlets(int version) {
        AbstractStreamlet.reconcileOutlets(version, this, this.getClass());
    }

    protected void didReconcile(int version) {
    }
}

