/*
 * Decompiled with CFR 0.152.
 */
package swim.streamlet;

import java.util.Iterator;
import swim.collections.HashTrieMap;
import swim.streamlet.Inlet;
import swim.streamlet.KeyEffect;
import swim.streamlet.KeyOutlet;
import swim.streamlet.MapInlet;
import swim.streamlet.MapInoutlet;
import swim.streamlet.MapOutlet;
import swim.streamlet.Outlet;
import swim.util.Cursor;

public abstract class AbstractMapInoutlet<K, VI, VO, I, O>
implements MapInoutlet<K, VI, VO, I, O> {
    protected MapOutlet<K, VI, ? extends I> input = null;
    protected HashTrieMap<K, KeyEffect> effects = HashTrieMap.empty();
    protected HashTrieMap<K, KeyOutlet<K, VO>> outlets = HashTrieMap.empty();
    protected Inlet<? super O>[] outputs = null;
    protected int version = -1;

    @Override
    public abstract boolean containsKey(K var1);

    @Override
    public abstract VO get(K var1);

    @Override
    public abstract O get();

    @Override
    public abstract Iterator<K> keyIterator();

    public MapOutlet<K, VI, ? extends I> input() {
        return this.input;
    }

    @Override
    public void bindInput(Outlet<? extends I> input) {
        if (!(input instanceof MapOutlet)) {
            throw new IllegalArgumentException(input.toString());
        }
        this.bindInput((MapOutlet)input);
    }

    public void bindInput(MapOutlet<K, VI, ? extends I> input) {
        if (this.input != null) {
            this.input.unbindOutput(this);
        }
        this.input = input;
        if (this.input != null) {
            this.input.bindOutput(this);
        }
    }

    @Override
    public void unbindInput() {
        if (this.input != null) {
            this.input.unbindOutput(this);
        }
        this.input = null;
    }

    @Override
    public void disconnectInputs() {
        MapOutlet<K, VI, I> input;
        if (this.outputs == null && this.outlets.isEmpty() && (input = this.input) != null) {
            input.unbindOutput(this);
            this.input = null;
            input.disconnectInputs();
        }
    }

    @Override
    public Outlet<VO> outlet(K key) {
        KeyOutlet outlet = (KeyOutlet)this.outlets.get(key);
        if (outlet == null) {
            outlet = new KeyOutlet(this, key);
            this.outlets = this.outlets.updated(key, outlet);
        }
        return outlet;
    }

    @Override
    public Iterator<Inlet<? super O>> outputIterator() {
        return this.outputs != null ? Cursor.array((Object[])this.outputs) : Cursor.empty();
    }

    @Override
    public void bindOutput(Inlet<? super O> output) {
        Inlet<? super O>[] oldOutputs = this.outputs;
        int n = oldOutputs != null ? oldOutputs.length : 0;
        Inlet[] newOutputs = new Inlet[n + 1];
        if (n > 0) {
            System.arraycopy(oldOutputs, 0, newOutputs, 0, n);
        }
        newOutputs[n] = output;
        this.outputs = newOutputs;
    }

    @Override
    public void unbindOutput(Inlet<? super O> output) {
        Inlet<? super O>[] oldOutputs = this.outputs;
        int n = oldOutputs != null ? oldOutputs.length : 0;
        for (int i = 0; i < n; ++i) {
            if (oldOutputs[i] != output) continue;
            if (n > 1) {
                Inlet[] newOutputs = new Inlet[n - 1];
                System.arraycopy(oldOutputs, 0, newOutputs, 0, i);
                System.arraycopy(oldOutputs, i + 1, newOutputs, i, n - 1 - i);
                this.outputs = newOutputs;
                break;
            }
            this.outputs = null;
            break;
        }
    }

    @Override
    public void unbindOutputs() {
        Inlet<? super O>[] outputs;
        HashTrieMap<K, KeyOutlet<K, VO>> outlets = this.outlets;
        if (!outlets.isEmpty()) {
            this.outlets = HashTrieMap.empty();
            Iterator keyOutlets = outlets.valueIterator();
            while (keyOutlets.hasNext()) {
                KeyOutlet keyOutlet = (KeyOutlet)keyOutlets.next();
                keyOutlet.unbindOutputs();
            }
        }
        if ((outputs = this.outputs) != null) {
            this.outputs = null;
            for (Inlet<O> inlet : outputs) {
                inlet.unbindInput();
            }
        }
    }

    @Override
    public void disconnectOutputs() {
        if (this.input == null) {
            Inlet<? super O>[] outputs;
            HashTrieMap<K, KeyOutlet<K, VO>> outlets = this.outlets;
            if (!outlets.isEmpty()) {
                this.outlets = HashTrieMap.empty();
                Iterator keyOutlets = outlets.valueIterator();
                while (keyOutlets.hasNext()) {
                    KeyOutlet keyOutlet = (KeyOutlet)keyOutlets.next();
                    keyOutlet.disconnectOutputs();
                }
            }
            if ((outputs = this.outputs) != null) {
                this.outputs = null;
                for (Inlet<O> inlet : outputs) {
                    inlet.unbindInput();
                    inlet.disconnectOutputs();
                }
            }
        }
    }

    @Override
    public void decohereOutputKey(K key, KeyEffect effect) {
        this.decohereKey(key, effect);
    }

    @Override
    public void decohereInputKey(K key, KeyEffect effect) {
        this.decohereKey(key, effect);
    }

    public void decohereKey(K key, KeyEffect effect) {
        HashTrieMap<K, KeyEffect> oldEffects = this.effects;
        if (oldEffects.get(key) != effect) {
            this.willDecohereKey(key, effect);
            this.effects = oldEffects.updated(key, (Object)effect);
            this.version = -1;
            this.onDecohereKey(key, effect);
            int n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                Inlet<O> output = this.outputs[i];
                if (output instanceof MapInlet) {
                    ((MapInlet)output).decohereOutputKey(key, effect);
                    continue;
                }
                output.decohereOutput();
            }
            KeyOutlet outlet = (KeyOutlet)this.outlets.get(key);
            if (outlet != null) {
                outlet.decohereInput();
            }
            this.didDecohereKey(key, effect);
        }
    }

    @Override
    public void decohereOutput() {
        this.decohere();
    }

    @Override
    public void decohereInput() {
        this.decohere();
    }

    public void decohere() {
        if (this.version >= 0) {
            this.willDecohere();
            this.version = -1;
            this.onDecohere();
            int n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                this.outputs[i].decohereOutput();
            }
            Iterator outlets = this.outlets.valueIterator();
            while (outlets.hasNext()) {
                ((KeyOutlet)outlets.next()).decohereInput();
            }
            this.didDecohere();
        }
    }

    @Override
    public void recohereOutputKey(K key, int version) {
        this.recohereKey(key, version);
    }

    @Override
    public void recohereInputKey(K key, int version) {
        this.recohereKey(key, version);
    }

    public void recohereKey(K key, int version) {
        HashTrieMap<K, KeyEffect> oldEffects;
        KeyEffect effect;
        if (this.version < 0 && (effect = (KeyEffect)((Object)(oldEffects = this.effects).get(key))) != null) {
            int n;
            this.willRecohereKey(key, effect, version);
            this.effects = oldEffects.removed(key);
            if (this.input != null) {
                this.input.recohereInputKey(key, version);
            }
            this.onRecohereKey(key, effect, version);
            int n2 = n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                Inlet<O> output = this.outputs[i];
                if (!(output instanceof MapInlet)) continue;
                ((MapInlet)output).recohereOutputKey(key, version);
            }
            KeyOutlet outlet = (KeyOutlet)this.outlets.get(key);
            if (outlet != null) {
                outlet.recohereInput(version);
            }
            this.didRecohereKey(key, effect, version);
        }
    }

    @Override
    public void recohereOutput(int version) {
        this.recohere(version);
    }

    @Override
    public void recohereInput(int version) {
        this.recohere(version);
    }

    public void recohere(int version) {
        if (this.version < 0) {
            int n;
            this.willRecohere(version);
            Iterator keys = this.effects.keyIterator();
            while (keys.hasNext()) {
                this.recohereKey(keys.next(), version);
            }
            this.version = version;
            this.onRecohere(version);
            int n2 = n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                this.outputs[i].recohereOutput(version);
            }
            this.didRecohere(version);
        }
    }

    protected void willDecohereKey(K key, KeyEffect effect) {
    }

    protected void onDecohereKey(K key, KeyEffect effect) {
    }

    protected void didDecohereKey(K key, KeyEffect effect) {
    }

    protected void willDecohere() {
    }

    protected void onDecohere() {
    }

    protected void didDecohere() {
    }

    protected void willRecohereKey(K key, KeyEffect effect, int version) {
    }

    protected void onRecohereKey(K key, KeyEffect effect, int version) {
    }

    protected void didRecohereKey(K key, KeyEffect effect, int version) {
    }

    protected void willRecohere(int version) {
    }

    protected void onRecohere(int version) {
    }

    protected void didRecohere(int version) {
    }
}

