/*
 * Decompiled with CFR 0.152.
 */
package swim.streamlet;

import java.util.Iterator;
import swim.streamlet.Inlet;
import swim.streamlet.Inoutlet;
import swim.streamlet.Outlet;
import swim.util.Cursor;

public abstract class AbstractInoutlet<I, O>
implements Inoutlet<I, O> {
    protected Outlet<? extends I> input = null;
    protected Inlet<? super O>[] outputs = null;
    protected int version = -1;

    @Override
    public abstract O get();

    @Override
    public Outlet<? extends I> input() {
        return this.input;
    }

    @Override
    public void bindInput(Outlet<? extends I> input) {
        if (this.input != null) {
            this.input.unbindOutput(this);
        }
        this.input = input;
        if (this.input != null) {
            this.input.bindOutput(this);
        }
    }

    @Override
    public void unbindInput() {
        if (this.input != null) {
            this.input.unbindOutput(this);
        }
        this.input = null;
    }

    @Override
    public void disconnectInputs() {
        Outlet<I> input;
        if (this.outputs == null && (input = this.input) != null) {
            input.unbindOutput(this);
            this.input = null;
            input.disconnectInputs();
        }
    }

    @Override
    public Iterator<Inlet<? super O>> outputIterator() {
        return this.outputs != null ? Cursor.array((Object[])this.outputs) : Cursor.empty();
    }

    @Override
    public void bindOutput(Inlet<? super O> output) {
        Inlet<? super O>[] oldOutputs = this.outputs;
        int n = oldOutputs != null ? oldOutputs.length : 0;
        Inlet[] newOutputs = new Inlet[n + 1];
        if (n > 0) {
            System.arraycopy(oldOutputs, 0, newOutputs, 0, n);
        }
        newOutputs[n] = output;
        this.outputs = newOutputs;
    }

    @Override
    public void unbindOutput(Inlet<? super O> output) {
        Inlet<? super O>[] oldOutputs = this.outputs;
        int n = oldOutputs != null ? oldOutputs.length : 0;
        for (int i = 0; i < n; ++i) {
            if (!oldOutputs[i].equals(output)) continue;
            if (n > 1) {
                Inlet[] newOutputs = new Inlet[n - 1];
                System.arraycopy(oldOutputs, 0, newOutputs, 0, i);
                System.arraycopy(oldOutputs, i + 1, newOutputs, i, n - 1 - i);
                this.outputs = newOutputs;
                break;
            }
            this.outputs = null;
            break;
        }
    }

    @Override
    public void unbindOutputs() {
        Inlet<? super O>[] outputs = this.outputs;
        if (outputs != null) {
            this.outputs = null;
            for (Inlet<O> inlet : outputs) {
                inlet.unbindInput();
            }
        }
    }

    @Override
    public void disconnectOutputs() {
        Inlet<? super O>[] outputs;
        if (this.input == null && (outputs = this.outputs) != null) {
            this.outputs = null;
            for (Inlet<O> inlet : outputs) {
                inlet.unbindInput();
                inlet.disconnectOutputs();
            }
        }
    }

    @Override
    public void decohereOutput() {
        this.decohere();
    }

    @Override
    public void decohereInput() {
        this.decohere();
    }

    public void decohere() {
        if (this.version >= 0) {
            this.willDecohere();
            this.version = -1;
            this.onDecohere();
            int n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                this.outputs[i].decohereOutput();
            }
            this.didDecohere();
        }
    }

    @Override
    public void recohereOutput(int version) {
        this.recohere(version);
    }

    @Override
    public void recohereInput(int version) {
        this.recohere(version);
    }

    public void recohere(int version) {
        if (this.version < 0) {
            this.willRecohere(version);
            this.version = version;
            if (this.input != null) {
                this.input.recohereInput(version);
            }
            this.onRecohere(version);
            int n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                this.outputs[i].recohereOutput(version);
            }
            this.didRecohere(version);
        }
    }

    protected void willDecohere() {
    }

    protected void onDecohere() {
    }

    protected void didDecohere() {
    }

    protected void willRecohere(int version) {
    }

    protected void onRecohere(int version) {
    }

    protected void didRecohere(int version) {
    }
}

