/*
 * Decompiled with CFR 0.152.
 */
package swim.streamlet;

import java.util.Iterator;
import swim.collections.HashTrieMap;
import swim.streamlet.Inlet;
import swim.streamlet.KeyEffect;
import swim.streamlet.KeyOutlet;
import swim.streamlet.MapInlet;
import swim.streamlet.MapOutlet;
import swim.streamlet.Outlet;
import swim.util.Cursor;

public abstract class AbstractMapOutlet<K, V, O>
implements MapOutlet<K, V, O> {
    protected HashTrieMap<K, KeyEffect> effects = HashTrieMap.empty();
    protected HashTrieMap<K, KeyOutlet<K, V>> outlets = HashTrieMap.empty();
    protected Inlet<? super O>[] outputs = null;
    protected int version = -1;

    @Override
    public abstract boolean containsKey(K var1);

    @Override
    public abstract V get(K var1);

    @Override
    public abstract O get();

    @Override
    public abstract Iterator<K> keyIterator();

    @Override
    public Outlet<V> outlet(K key) {
        KeyOutlet outlet = (KeyOutlet)this.outlets.get(key);
        if (outlet == null) {
            outlet = new KeyOutlet(this, key);
            this.outlets = this.outlets.updated(key, outlet);
        }
        return outlet;
    }

    @Override
    public Iterator<Inlet<? super O>> outputIterator() {
        return this.outputs != null ? Cursor.array((Object[])this.outputs) : Cursor.empty();
    }

    @Override
    public void bindOutput(Inlet<? super O> output) {
        Inlet<? super O>[] oldOutputs = this.outputs;
        int n = oldOutputs != null ? oldOutputs.length : 0;
        Inlet[] newOutputs = new Inlet[n + 1];
        if (n > 0) {
            System.arraycopy(oldOutputs, 0, newOutputs, 0, n);
        }
        newOutputs[n] = output;
        this.outputs = newOutputs;
    }

    @Override
    public void unbindOutput(Inlet<? super O> output) {
        Inlet<? super O>[] oldOutputs = this.outputs;
        int n = oldOutputs != null ? oldOutputs.length : 0;
        for (int i = 0; i < n; ++i) {
            if (oldOutputs[i] != output) continue;
            if (n > 1) {
                Inlet[] newOutputs = new Inlet[n - 1];
                System.arraycopy(oldOutputs, 0, newOutputs, 0, i);
                System.arraycopy(oldOutputs, i + 1, newOutputs, i, n - 1 - i);
                this.outputs = newOutputs;
                break;
            }
            this.outputs = null;
            break;
        }
    }

    @Override
    public void unbindOutputs() {
        Inlet<? super O>[] outputs;
        HashTrieMap<K, KeyOutlet<K, V>> outlets = this.outlets;
        if (!outlets.isEmpty()) {
            this.outlets = HashTrieMap.empty();
            Iterator keyOutlets = outlets.valueIterator();
            while (keyOutlets.hasNext()) {
                KeyOutlet keyOutlet = (KeyOutlet)keyOutlets.next();
                keyOutlet.unbindOutputs();
            }
        }
        if ((outputs = this.outputs) != null) {
            this.outputs = null;
            for (Inlet<O> inlet : outputs) {
                inlet.unbindInput();
            }
        }
    }

    @Override
    public void disconnectOutputs() {
        Inlet<? super O>[] outputs;
        HashTrieMap<K, KeyOutlet<K, V>> outlets = this.outlets;
        if (!outlets.isEmpty()) {
            this.outlets = HashTrieMap.empty();
            Iterator keyOutlets = outlets.valueIterator();
            while (keyOutlets.hasNext()) {
                KeyOutlet keyOutlet = (KeyOutlet)keyOutlets.next();
                keyOutlet.disconnectOutputs();
            }
        }
        if ((outputs = this.outputs) != null) {
            this.outputs = null;
            for (Inlet<O> inlet : outputs) {
                inlet.unbindInput();
                inlet.disconnectOutputs();
            }
        }
    }

    @Override
    public void disconnectInputs() {
    }

    @Override
    public void invalidateInputKey(K key, KeyEffect effect) {
        HashTrieMap<K, KeyEffect> oldEffects = this.effects;
        if (oldEffects.get(key) != effect) {
            this.willInvalidateInputKey(key, effect);
            this.effects = oldEffects.updated(key, (Object)effect);
            this.version = -1;
            this.onInvalidateInputKey(key, effect);
            int n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                Inlet<O> output = this.outputs[i];
                if (output instanceof MapInlet) {
                    ((MapInlet)output).invalidateOutputKey(key, effect);
                    continue;
                }
                output.invalidateOutput();
            }
            KeyOutlet outlet = (KeyOutlet)this.outlets.get(key);
            if (outlet != null) {
                outlet.invalidateInput();
            }
            this.didInvalidateInputKey(key, effect);
        }
    }

    @Override
    public void invalidateInput() {
        if (this.version >= 0) {
            this.willInvalidateInput();
            this.version = -1;
            this.onInvalidateInput();
            int n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                this.outputs[i].invalidateOutput();
            }
            Iterator outlets = this.outlets.valueIterator();
            while (outlets.hasNext()) {
                ((KeyOutlet)outlets.next()).invalidateInput();
            }
            this.didInvalidateInput();
        }
    }

    @Override
    public void reconcileInputKey(K key, int version) {
        HashTrieMap<K, KeyEffect> oldEffects;
        KeyEffect effect;
        if (this.version < 0 && (effect = (KeyEffect)((Object)(oldEffects = this.effects).get(key))) != null) {
            int n;
            this.willReconcileInputKey(key, effect, version);
            this.effects = oldEffects.removed(key);
            this.onReconcileInputKey(key, effect, version);
            int n2 = n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                Inlet<O> output = this.outputs[i];
                if (!(output instanceof MapInlet)) continue;
                ((MapInlet)output).reconcileOutputKey(key, version);
            }
            KeyOutlet outlet = (KeyOutlet)this.outlets.get(key);
            if (outlet != null) {
                outlet.reconcileInput(version);
            }
            this.didReconcileInputKey(key, effect, version);
        }
    }

    @Override
    public void reconcileInput(int version) {
        if (this.version < 0) {
            int n;
            this.willReconcileInput(version);
            Iterator keys = this.effects.keyIterator();
            while (keys.hasNext()) {
                this.reconcileInputKey(keys.next(), version);
            }
            this.version = version;
            this.onReconcileInput(version);
            int n2 = n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                this.outputs[i].reconcileOutput(version);
            }
            this.didReconcileInput(version);
        }
    }

    protected void willInvalidateInputKey(K key, KeyEffect effect) {
    }

    protected void onInvalidateInputKey(K key, KeyEffect effect) {
    }

    protected void didInvalidateInputKey(K key, KeyEffect effect) {
    }

    protected void willInvalidateInput() {
    }

    protected void onInvalidateInput() {
    }

    protected void didInvalidateInput() {
    }

    protected void willReconcileInputKey(K key, KeyEffect effect, int version) {
    }

    protected void onReconcileInputKey(K key, KeyEffect effect, int version) {
    }

    protected void didReconcileInputKey(K key, KeyEffect effect, int version) {
    }

    protected void willReconcileInput(int version) {
    }

    protected void onReconcileInput(int version) {
    }

    protected void didReconcileInput(int version) {
    }
}

