/*
 * Decompiled with CFR 0.152.
 */
package swim.streamlet;

import swim.streamlet.Inlet;
import swim.streamlet.Outlet;

public abstract class AbstractInlet<I>
implements Inlet<I> {
    protected Outlet<? extends I> input = null;
    protected int version = -1;

    @Override
    public Outlet<? extends I> input() {
        return this.input;
    }

    @Override
    public void bindInput(Outlet<? extends I> input) {
        if (this.input != null) {
            this.input.unbindOutput(this);
        }
        this.input = input;
        if (this.input != null) {
            this.input.bindOutput(this);
        }
    }

    @Override
    public void unbindInput() {
        if (this.input != null) {
            this.input.unbindOutput(this);
        }
        this.input = null;
    }

    @Override
    public void disconnectInputs() {
        Outlet<I> input = this.input;
        if (input != null) {
            input.unbindOutput(this);
            this.input = null;
            input.disconnectInputs();
        }
    }

    @Override
    public void disconnectOutputs() {
    }

    @Override
    public void decohereOutput() {
        if (this.version >= 0) {
            this.willDecohereOutput();
            this.version = -1;
            this.onDecohereOutput();
            this.didDecohereOutput();
        }
    }

    @Override
    public void recohereOutput(int version) {
        if (this.version < 0) {
            this.willRecohereOutput(version);
            this.version = version;
            if (this.input != null) {
                this.input.recohereInput(version);
            }
            this.onRecohereOutput(version);
            this.didRecohereOutput(version);
        }
    }

    protected void willDecohereOutput() {
    }

    protected void onDecohereOutput() {
    }

    protected void didDecohereOutput() {
    }

    protected void willRecohereOutput(int version) {
    }

    protected void onRecohereOutput(int version) {
    }

    protected void didRecohereOutput(int version) {
    }
}

