/*
 * Decompiled with CFR 0.152.
 */
package swim.streamlet;

import java.util.Iterator;
import swim.collections.HashTrieMap;
import swim.streamlet.KeyEffect;
import swim.streamlet.MapInlet;
import swim.streamlet.MapOutlet;
import swim.streamlet.Outlet;

public abstract class AbstractMapInlet<K, V, O>
implements MapInlet<K, V, O> {
    protected MapOutlet<K, V, ? extends O> input = null;
    protected HashTrieMap<K, KeyEffect> effects = HashTrieMap.empty();
    protected int version = -1;

    public MapOutlet<K, V, ? extends O> input() {
        return this.input;
    }

    @Override
    public void bindInput(Outlet<? extends O> input) {
        if (!(input instanceof MapOutlet)) {
            throw new IllegalArgumentException(input.toString());
        }
        this.bindInput((MapOutlet)input);
    }

    public void bindInput(MapOutlet<K, V, ? extends O> input) {
        if (this.input != null) {
            this.input.unbindOutput(this);
        }
        this.input = input;
        if (this.input != null) {
            this.input.bindOutput(this);
        }
    }

    @Override
    public void unbindInput() {
        if (this.input != null) {
            this.input.unbindOutput(this);
        }
        this.input = null;
    }

    @Override
    public void disconnectInputs() {
        MapOutlet<K, V, O> input = this.input;
        if (input != null) {
            input.unbindOutput(this);
            this.input = null;
            input.disconnectInputs();
        }
    }

    @Override
    public void disconnectOutputs() {
    }

    @Override
    public void decohereOutputKey(K key, KeyEffect effect) {
        HashTrieMap<K, KeyEffect> oldEffects = this.effects;
        if (oldEffects.get(key) != effect) {
            this.willDecohereOutputKey(key, effect);
            this.effects = oldEffects.updated(key, (Object)effect);
            this.version = -1;
            this.onDecohereOutputKey(key, effect);
            this.didDecohereOutputKey(key, effect);
        }
    }

    @Override
    public void decohereOutput() {
        if (this.version >= 0) {
            this.willDecohereOutput();
            this.version = -1;
            this.onDecohereOutput();
            this.didDecohereOutput();
        }
    }

    @Override
    public void recohereOutputKey(K key, int version) {
        HashTrieMap<K, KeyEffect> oldEffects;
        KeyEffect effect;
        if (this.version < 0 && (effect = (KeyEffect)((Object)(oldEffects = this.effects).get(key))) != null) {
            this.willRecohereOutputKey(key, effect, version);
            this.effects = oldEffects.removed(key);
            if (this.input != null) {
                this.input.recohereInputKey(key, version);
            }
            this.onRecohereOutputKey(key, effect, version);
            this.didRecohereOutputKey(key, effect, version);
        }
    }

    @Override
    public void recohereOutput(int version) {
        if (this.version < 0) {
            this.willRecohereOutput(version);
            Iterator keys = this.effects.keyIterator();
            while (keys.hasNext()) {
                this.recohereOutputKey(keys.next(), version);
            }
            this.version = version;
            this.onRecohereOutput(version);
            this.didRecohereOutput(version);
        }
    }

    protected void willDecohereOutputKey(K key, KeyEffect effect) {
    }

    protected void onDecohereOutputKey(K key, KeyEffect effect) {
    }

    protected void didDecohereOutputKey(K key, KeyEffect effect) {
    }

    protected void willDecohereOutput() {
    }

    protected void onDecohereOutput() {
    }

    protected void didDecohereOutput() {
    }

    protected void willRecohereOutputKey(K key, KeyEffect effect, int version) {
    }

    protected void onRecohereOutputKey(K key, KeyEffect effect, int version) {
    }

    protected void didRecohereOutputKey(K key, KeyEffect effect, int version) {
    }

    protected void willRecohereOutput(int version) {
    }

    protected void onRecohereOutput(int version) {
    }

    protected void didRecohereOutput(int version) {
    }
}

