/*
 * Decompiled with CFR 0.152.
 */
package swim.streamlet;

import java.util.Iterator;
import swim.streamlet.Inlet;
import swim.streamlet.Outlet;
import swim.util.Cursor;

public abstract class AbstractOutlet<O>
implements Outlet<O> {
    protected Inlet<? super O>[] outputs = null;
    protected int version = -1;

    @Override
    public abstract O get();

    @Override
    public Iterator<Inlet<? super O>> outputIterator() {
        return this.outputs != null ? Cursor.array((Object[])this.outputs) : Cursor.empty();
    }

    @Override
    public void bindOutput(Inlet<? super O> output) {
        Inlet<? super O>[] oldOutputs = this.outputs;
        int n = oldOutputs != null ? oldOutputs.length : 0;
        Inlet[] newOutputs = new Inlet[n + 1];
        if (n > 0) {
            System.arraycopy(oldOutputs, 0, newOutputs, 0, n);
        }
        newOutputs[n] = output;
        this.outputs = newOutputs;
    }

    @Override
    public void unbindOutput(Inlet<? super O> output) {
        int n;
        Inlet<? super O>[] oldOutputs = this.outputs;
        int n2 = n = oldOutputs != null ? oldOutputs.length : 0;
        for (int i = 0; i < n; ++i) {
            if (oldOutputs[i] != output) continue;
            if (n > 1) {
                Inlet[] newOutputs = new Inlet[n - 1];
                System.arraycopy(oldOutputs, 0, newOutputs, 0, i);
                System.arraycopy(oldOutputs, i + 1, newOutputs, i, n - 1 - i);
                this.outputs = newOutputs;
                break;
            }
            this.outputs = null;
            break;
        }
    }

    @Override
    public void unbindOutputs() {
        Inlet<? super O>[] outputs = this.outputs;
        if (outputs != null) {
            this.outputs = null;
            for (Inlet<O> inlet : outputs) {
                inlet.unbindInput();
            }
        }
    }

    @Override
    public void disconnectOutputs() {
        Inlet<? super O>[] outputs = this.outputs;
        if (outputs != null) {
            this.outputs = null;
            for (Inlet<O> inlet : outputs) {
                inlet.unbindInput();
                inlet.disconnectOutputs();
            }
        }
    }

    @Override
    public void disconnectInputs() {
    }

    @Override
    public void decohereInput() {
        if (this.version >= 0) {
            int n;
            this.willDecohereInput();
            this.version = -1;
            this.onDecohereInput();
            int n2 = n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                this.outputs[i].decohereOutput();
            }
            this.didDecohereInput();
        }
    }

    @Override
    public void recohereInput(int version) {
        if (this.version < 0) {
            int n;
            this.willRecohereInput(version);
            this.version = version;
            this.onRecohereInput(version);
            int n2 = n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                this.outputs[i].recohereOutput(version);
            }
            this.didRecohereInput(version);
        }
    }

    protected void willDecohereInput() {
    }

    protected void onDecohereInput() {
    }

    protected void didDecohereInput() {
    }

    protected void willRecohereInput(int version) {
    }

    protected void onRecohereInput(int version) {
    }

    protected void didRecohereInput(int version) {
    }
}

