/*
 * Decompiled with CFR 0.152.
 */
package swim.streamlet;

import java.util.Iterator;
import java.util.Map;
import swim.collections.HashTrieMap;
import swim.streamlet.AbstractMapOutlet;
import swim.streamlet.KeyEffect;

public class MapInput<K, V>
extends AbstractMapOutlet<K, V, Map<K, V>> {
    protected HashTrieMap<K, V> state;

    public MapInput(HashTrieMap<K, V> state) {
        this.state = state;
        Iterator keys = state.keyIterator();
        while (keys.hasNext()) {
            this.effects = this.effects.updated(keys.next(), (Object)KeyEffect.UPDATE);
        }
    }

    public MapInput() {
        this(HashTrieMap.empty());
    }

    @Override
    public boolean containsKey(K key) {
        return this.state.containsKey(key);
    }

    @Override
    public V get(K key) {
        return (V)this.state.get(key);
    }

    public V put(K key, V newValue) {
        Object oldValue = this.state.get(key);
        this.state = this.state.updated(key, newValue);
        this.decohereInputKey(key, KeyEffect.UPDATE);
        return (V)oldValue;
    }

    public boolean removeKey(K key) {
        HashTrieMap<K, V> oldState = this.state;
        HashTrieMap newState = oldState.removed(key);
        if (oldState != newState) {
            this.state = newState;
            this.decohereInputKey(key, KeyEffect.REMOVE);
            return true;
        }
        return false;
    }

    @Override
    public Map<K, V> get() {
        return this.state;
    }

    @Override
    public Iterator<K> keyIterator() {
        return this.state.keyIterator();
    }
}

