/*
 * Decompiled with CFR 0.152.
 */
package swim.structure;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.util.Murmur3;

public class InterpreterSettings
implements Debug {
    public static final int MAX_SCOPE_DEPTH;
    private static InterpreterSettings standard;
    private static int hashSeed;
    protected final int maxScopeDepth;

    public InterpreterSettings(int maxScopeDepth) {
        this.maxScopeDepth = maxScopeDepth;
    }

    public static InterpreterSettings standard() {
        if (standard == null) {
            standard = new InterpreterSettings(MAX_SCOPE_DEPTH);
        }
        return standard;
    }

    public final int maxScopeDepth() {
        return this.maxScopeDepth;
    }

    public InterpreterSettings maxScopeDepth(int maxScopeDepth) {
        return this.copy(maxScopeDepth);
    }

    protected InterpreterSettings copy(int maxScopeDepth) {
        return new InterpreterSettings(maxScopeDepth);
    }

    protected boolean canEqual(Object other) {
        return other instanceof InterpreterSettings;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof InterpreterSettings) {
            InterpreterSettings that = (InterpreterSettings)other;
            return that.canEqual(this) && this.maxScopeDepth == that.maxScopeDepth;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(InterpreterSettings.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.maxScopeDepth));
    }

    public void debug(Output<?> output) {
        output = output.write("new").write(32).write("InterpreterSettings").write(40).debug((Object)this.maxScopeDepth).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    static {
        int maxScopeDepth;
        try {
            maxScopeDepth = Integer.parseInt(System.getProperty("swim.structure.interpreter.max.scope.depth"));
        }
        catch (NumberFormatException e) {
            maxScopeDepth = 1024;
        }
        MAX_SCOPE_DEPTH = maxScopeDepth;
    }
}

