/*
 * Decompiled with CFR 0.152.
 */
package swim.structure;

import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;
import swim.codec.Debug;
import swim.codec.Display;
import swim.codec.Format;
import swim.codec.Output;
import swim.structure.Absent;
import swim.structure.Bool;
import swim.structure.Extant;
import swim.structure.Field;
import swim.structure.Form;
import swim.structure.Interpreter;
import swim.structure.ItemIterator;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Selector;
import swim.structure.Slot;
import swim.structure.Text;
import swim.structure.Value;
import swim.structure.func.MathModule;

public abstract class Item
implements Comparable<Item>,
Iterable<Item>,
Debug,
Display {
    private static Item globalScope;

    Item() {
    }

    public static Item empty() {
        return Record.empty();
    }

    public static Item extant() {
        return Extant.extant();
    }

    public static Item absent() {
        return Absent.absent();
    }

    public static Item fromObject(Object object) {
        if (object instanceof Item) {
            return (Item)object;
        }
        if (object instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)object;
            return Slot.of(Value.fromObject(entry.getKey()), Value.fromObject(entry.getValue()));
        }
        return Value.fromObject(object);
    }

    public static Item globalScope() {
        if (globalScope == null) {
            globalScope = Record.create(1).slot("math", (Value)MathModule.scope()).commit();
        }
        return globalScope;
    }

    public abstract boolean isDefined();

    public abstract boolean isDistinct();

    public abstract boolean isConstant();

    public abstract Value key();

    public abstract Value toValue();

    public abstract String tag();

    public abstract Value target();

    public abstract Value flattened();

    public abstract Record unflattened();

    public abstract Value header(String var1);

    public abstract Record headers(String var1);

    public abstract Item head();

    public abstract Record tail();

    public abstract Value body();

    public abstract int length();

    public abstract boolean contains(Item var1);

    public abstract boolean containsKey(Value var1);

    public abstract boolean containsKey(String var1);

    public abstract boolean containsValue(Value var1);

    public abstract Value get(Value var1);

    public abstract Value get(String var1);

    public abstract Value getAttr(Text var1);

    public abstract Value getAttr(String var1);

    public abstract Value getSlot(Value var1);

    public abstract Value getSlot(String var1);

    public abstract Field getField(Value var1);

    public abstract Field getField(String var1);

    public abstract Item getItem(int var1);

    public Record updated(Value key, Value value) {
        Record record = Record.create(2);
        record.add(this);
        record.put(key, value);
        return record;
    }

    public Record updated(Value key, String value) {
        return this.updated(key, (Value)Text.from(value));
    }

    public Record updated(Value key, int value) {
        return this.updated(key, (Value)Num.from(value));
    }

    public Record updated(Value key, long value) {
        return this.updated(key, (Value)Num.from(value));
    }

    public Record updated(Value key, float value) {
        return this.updated(key, (Value)Num.from(value));
    }

    public Record updated(Value key, double value) {
        return this.updated(key, (Value)Num.from(value));
    }

    public Record updated(Value key, boolean value) {
        return this.updated(key, (Value)Bool.from(value));
    }

    public Record updated(String key, Value value) {
        return this.updated((Value)Text.from(key), value);
    }

    public Record updated(String key, String value) {
        return this.updated(key, (Value)Text.from(value));
    }

    public Record updated(String key, int value) {
        return this.updated(key, (Value)Num.from(value));
    }

    public Record updated(String key, long value) {
        return this.updated(key, (Value)Num.from(value));
    }

    public Record updated(String key, float value) {
        return this.updated(key, (Value)Num.from(value));
    }

    public Record updated(String key, double value) {
        return this.updated(key, (Value)Num.from(value));
    }

    public Record updated(String key, boolean value) {
        return this.updated(key, (Value)Bool.from(value));
    }

    public Record updatedAttr(Text key, Value value) {
        Record record = Record.create(2);
        record.add(this);
        record.putAttr(key, value);
        return record;
    }

    public Record updatedAttr(Text key, String value) {
        return this.updatedAttr(key, (Value)Text.from(value));
    }

    public Record updatedAttr(Text key, int value) {
        return this.updatedAttr(key, (Value)Num.from(value));
    }

    public Record updatedAttr(Text key, long value) {
        return this.updatedAttr(key, (Value)Num.from(value));
    }

    public Record updatedAttr(Text key, float value) {
        return this.updatedAttr(key, (Value)Num.from(value));
    }

    public Record updatedAttr(Text key, double value) {
        return this.updatedAttr(key, (Value)Num.from(value));
    }

    public Record updatedAttr(Text key, boolean value) {
        return this.updatedAttr(key, (Value)Bool.from(value));
    }

    public Record updatedAttr(String key, Value value) {
        return this.updatedAttr(Text.from(key), value);
    }

    public Record updatedAttr(String key, String value) {
        return this.updatedAttr(key, (Value)Text.from(value));
    }

    public Record updatedAttr(String key, int value) {
        return this.updatedAttr(key, (Value)Num.from(value));
    }

    public Record updatedAttr(String key, long value) {
        return this.updatedAttr(key, (Value)Num.from(value));
    }

    public Record updatedAttr(String key, float value) {
        return this.updatedAttr(key, (Value)Num.from(value));
    }

    public Record updatedAttr(String key, double value) {
        return this.updatedAttr(key, (Value)Num.from(value));
    }

    public Record updatedAttr(String key, boolean value) {
        return this.updatedAttr(key, (Value)Bool.from(value));
    }

    public Record updatedSlot(Value key, Value value) {
        Record record = Record.create(2);
        record.add(this);
        record.putSlot(key, value);
        return record;
    }

    public Record updatedSlot(Value key, String value) {
        return this.updatedSlot(key, (Value)Text.from(value));
    }

    public Record updatedSlot(Value key, int value) {
        return this.updatedSlot(key, (Value)Num.from(value));
    }

    public Record updatedSlot(Value key, long value) {
        return this.updatedSlot(key, (Value)Num.from(value));
    }

    public Record updatedSlot(Value key, float value) {
        return this.updatedSlot(key, (Value)Num.from(value));
    }

    public Record updatedSlot(Value key, double value) {
        return this.updatedSlot(key, (Value)Num.from(value));
    }

    public Record updatedSlot(Value key, boolean value) {
        return this.updatedSlot(key, (Value)Bool.from(value));
    }

    public Record updatedSlot(String key, Value value) {
        return this.updatedSlot((Value)Text.from(key), value);
    }

    public Record updatedSlot(String key, String value) {
        return this.updatedSlot(key, (Value)Text.from(value));
    }

    public Record updatedSlot(String key, int value) {
        return this.updatedSlot(key, (Value)Num.from(value));
    }

    public Record updatedSlot(String key, long value) {
        return this.updatedSlot(key, (Value)Num.from(value));
    }

    public Record updatedSlot(String key, float value) {
        return this.updatedSlot(key, (Value)Num.from(value));
    }

    public Record updatedSlot(String key, double value) {
        return this.updatedSlot(key, (Value)Num.from(value));
    }

    public Record updatedSlot(String key, boolean value) {
        return this.updatedSlot(key, (Value)Bool.from(value));
    }

    public Record appended(Item item) {
        Record record = Record.create(2);
        record.add(this);
        record.add(item);
        return record;
    }

    public Record appended(String item) {
        return this.appended(Text.from(item));
    }

    public Record appended(int item) {
        return this.appended(Num.from(item));
    }

    public Record appended(long item) {
        return this.appended(Num.from(item));
    }

    public Record appended(float item) {
        return this.appended(Num.from(item));
    }

    public Record appended(double item) {
        return this.appended(Num.from(item));
    }

    public Record appended(boolean item) {
        return this.appended(Bool.from(item));
    }

    public Record appended(Object ... items) {
        Record record = Record.create(1 + items.length);
        record.add(this);
        record.addAll(Record.of(items));
        return record;
    }

    public Record prepended(Item item) {
        Record record = Record.create(2);
        record.add(item);
        record.add(this);
        return record;
    }

    public Record prepended(String item) {
        return this.prepended(Text.from(item));
    }

    public Record prepended(int item) {
        return this.prepended(Num.from(item));
    }

    public Record prepended(long item) {
        return this.prepended(Num.from(item));
    }

    public Record prepended(float item) {
        return this.prepended(Num.from(item));
    }

    public Record prepended(double item) {
        return this.prepended(Num.from(item));
    }

    public Record prepended(boolean item) {
        return this.prepended(Bool.from(item));
    }

    public Record prepended(Object ... items) {
        Record record = Record.create(items.length + 1);
        record.addAll(Record.of(items));
        record.add(this);
        return record;
    }

    public abstract Item removed(Value var1);

    public abstract Item removed(String var1);

    public Record concat(Item that) {
        Record record = Record.create(1 + that.length());
        record.add(this);
        if (that instanceof Record) {
            record.addAll((Record)that);
        } else {
            record.add(that);
        }
        return record;
    }

    public abstract Item conditional(Item var1, Item var2);

    public abstract Item or(Item var1);

    public abstract Item and(Item var1);

    public abstract Item bitwiseOr(Item var1);

    public abstract Item bitwiseXor(Item var1);

    public abstract Item bitwiseAnd(Item var1);

    public Item lt(Item that) {
        return this.compareTo(that) < 0 ? Bool.from(true) : Item.absent();
    }

    public Item le(Item that) {
        return this.compareTo(that) <= 0 ? Bool.from(true) : Item.absent();
    }

    public Item eq(Item that) {
        return this.equals(that) ? Bool.from(true) : Item.absent();
    }

    public Item ne(Item that) {
        return !this.equals(that) ? Bool.from(true) : Item.absent();
    }

    public Item ge(Item that) {
        return this.compareTo(that) >= 0 ? Bool.from(true) : Item.absent();
    }

    public Item gt(Item that) {
        return this.compareTo(that) > 0 ? Bool.from(true) : Item.absent();
    }

    public abstract Item plus(Item var1);

    public abstract Item minus(Item var1);

    public abstract Item times(Item var1);

    public abstract Item divide(Item var1);

    public abstract Item modulo(Item var1);

    public abstract Item not();

    public abstract Item bitwiseNot();

    public abstract Item negative();

    public abstract Item positive();

    public abstract Item inverse();

    public Item invoke(Value args) {
        return Item.absent();
    }

    public abstract Value lambda(Value var1);

    public Selector filter() {
        Selector selector = Selector.literal(this);
        return selector.filter();
    }

    public Selector filter(Item predicate) {
        Selector selector = Selector.literal(this);
        return selector.filter(predicate);
    }

    public Item max(Item that) {
        return this.compareTo(that) >= 0 ? this : that;
    }

    public Item min(Item that) {
        return this.compareTo(that) <= 0 ? this : that;
    }

    public Item evaluate(Interpreter interpreter) {
        return this;
    }

    public Item evaluate(Item scope) {
        Interpreter interpreter = new Interpreter();
        interpreter.pushScope(Item.globalScope());
        interpreter.pushScope(scope);
        return this.evaluate(interpreter);
    }

    public Item substitute(Interpreter interpreter) {
        return this;
    }

    public Item substitute(Item scope) {
        Interpreter interpreter = new Interpreter();
        interpreter.pushScope(Item.globalScope());
        interpreter.pushScope(scope);
        return this.substitute(interpreter);
    }

    public abstract String stringValue();

    public abstract String stringValue(String var1);

    public abstract byte byteValue();

    public abstract byte byteValue(byte var1);

    public abstract short shortValue();

    public abstract short shortValue(short var1);

    public abstract int intValue();

    public abstract int intValue(int var1);

    public abstract long longValue();

    public abstract long longValue(long var1);

    public abstract float floatValue();

    public abstract float floatValue(float var1);

    public abstract double doubleValue();

    public abstract double doubleValue(double var1);

    public abstract BigInteger integerValue();

    public abstract BigInteger integerValue(BigInteger var1);

    public abstract Number numberValue();

    public abstract Number numberValue(Number var1);

    public abstract char charValue();

    public abstract char charValue(char var1);

    public abstract boolean booleanValue();

    public abstract boolean booleanValue(boolean var1);

    public <T> T cast(Form<T> form) {
        return form.cast(this);
    }

    public <T> T cast(Form<T> form, T orElse) {
        T object = form.cast(this);
        if (object == null) {
            object = orElse;
        }
        return object;
    }

    public <T> T coerce(Form<T> form) {
        T object = form.cast(this);
        if (object == null) {
            object = form.unit();
        }
        return object;
    }

    public <T> T coerce(Form<T> form, T orElse) {
        T object = form.cast(this);
        if (object == null) {
            object = form.unit();
        }
        if (object == null) {
            object = orElse;
        }
        return object;
    }

    public abstract boolean isAliased();

    public abstract boolean isMutable();

    public abstract void alias();

    public abstract Item branch();

    public abstract Item commit();

    public int precedence() {
        return 12;
    }

    @Override
    public Iterator<Item> iterator() {
        return new ItemIterator(this);
    }

    public abstract int typeOrder();

    @Override
    public abstract int compareTo(Item var1);

    public abstract boolean keyEquals(Object var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract void debug(Output<?> var1);

    public void display(Output<?> output) {
        this.debug(output);
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

