/*
 * Decompiled with CFR 0.152.
 */
package swim.structure;

import java.math.BigInteger;
import swim.codec.Format;
import swim.codec.Output;
import swim.structure.Num;
import swim.structure.NumF32;
import swim.structure.NumF64;
import swim.structure.NumI32;
import swim.structure.NumInt;
import swim.structure.Value;
import swim.util.HashGenCacheSet;

final class NumI64
extends Num {
    static final int UINT64 = 1;
    private static NumI64 zero;
    private static NumI64 positiveOne;
    private static NumI64 negativeOne;
    private static ThreadLocal<HashGenCacheSet<NumI64>> cache;
    final long value;
    int flags;

    NumI64(long value, int flags) {
        this.value = value;
        this.flags = flags;
    }

    NumI64(long value) {
        this(value, 0);
    }

    static NumI64 zero() {
        if (zero == null) {
            zero = new NumI64(0L);
        }
        return zero;
    }

    static NumI64 positiveOne() {
        if (positiveOne == null) {
            positiveOne = new NumI64(1L);
        }
        return positiveOne;
    }

    static NumI64 negativeOne() {
        if (negativeOne == null) {
            negativeOne = new NumI64(-1L);
        }
        return negativeOne;
    }

    public static NumI64 from(long value) {
        if (value == 0L) {
            return NumI64.zero();
        }
        if (value == 1L) {
            return NumI64.positiveOne();
        }
        if (value == -1L) {
            return NumI64.negativeOne();
        }
        return (NumI64)NumI64.cache().put((Object)new NumI64(value));
    }

    public static NumI64 uint64(long value) {
        return new NumI64(value, 1);
    }

    static HashGenCacheSet<NumI64> cache() {
        HashGenCacheSet cache = NumI64.cache.get();
        if (cache == null) {
            int cacheSize;
            try {
                cacheSize = Integer.parseInt(System.getProperty("swim.structure.num.i64.cache.size"));
            }
            catch (NumberFormatException e) {
                cacheSize = 16;
            }
            cache = new HashGenCacheSet(cacheSize);
            NumI64.cache.set((HashGenCacheSet<NumI64>)cache);
        }
        return cache;
    }

    @Override
    public boolean isUint64() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isNaN() {
        return false;
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean isValidByte() {
        return (long)((byte)this.value) == this.value;
    }

    @Override
    public boolean isValidShort() {
        return (long)((short)this.value) == this.value;
    }

    @Override
    public boolean isValidInt() {
        return (long)((int)this.value) == this.value;
    }

    @Override
    public boolean isValidLong() {
        return true;
    }

    @Override
    public boolean isValidFloat() {
        return true;
    }

    @Override
    public boolean isValidDouble() {
        return true;
    }

    @Override
    public boolean isValidInteger() {
        return true;
    }

    @Override
    public String stringValue() {
        return Long.toString(this.value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public BigInteger integerValue() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public Number numberValue() {
        return this.value;
    }

    @Override
    public char charValue() {
        return (char)this.value;
    }

    @Override
    public boolean booleanValue() {
        return this.value != 0L;
    }

    @Override
    public Value bitwiseOr(Num that) {
        if (that instanceof NumI32) {
            return NumI64.from(this.value | (long)((NumI32)that).value);
        }
        if (that instanceof NumI64) {
            return NumI64.from(this.value | ((NumI64)that).value);
        }
        if (that instanceof NumF32) {
            return Value.absent();
        }
        if (that instanceof NumF64) {
            return Value.absent();
        }
        if (that instanceof NumInt) {
            return NumInt.from(BigInteger.valueOf(this.value).or(((NumInt)that).value));
        }
        throw new AssertionError();
    }

    @Override
    public Value bitwiseXor(Num that) {
        if (that instanceof NumI32) {
            return NumI64.from(this.value ^ (long)((NumI32)that).value);
        }
        if (that instanceof NumI64) {
            return NumI64.from(this.value ^ ((NumI64)that).value);
        }
        if (that instanceof NumF32) {
            return Value.absent();
        }
        if (that instanceof NumF64) {
            return Value.absent();
        }
        if (that instanceof NumInt) {
            return NumInt.from(BigInteger.valueOf(this.value).xor(((NumInt)that).value));
        }
        throw new AssertionError();
    }

    @Override
    public Value bitwiseAnd(Num that) {
        if (that instanceof NumI32) {
            return NumI64.from(this.value & (long)((NumI32)that).value);
        }
        if (that instanceof NumI64) {
            return NumI64.from(this.value & ((NumI64)that).value);
        }
        if (that instanceof NumF32) {
            return Value.absent();
        }
        if (that instanceof NumF64) {
            return Value.absent();
        }
        if (that instanceof NumInt) {
            return NumInt.from(BigInteger.valueOf(this.value).and(((NumInt)that).value));
        }
        throw new AssertionError();
    }

    @Override
    public Num plus(Num that) {
        if (that instanceof NumI32) {
            return NumI64.from(this.value + (long)((NumI32)that).value);
        }
        if (that instanceof NumI64) {
            return NumI64.from(this.value + ((NumI64)that).value);
        }
        if (that instanceof NumF32) {
            return NumF32.from((float)this.value + ((NumF32)that).value);
        }
        if (that instanceof NumF64) {
            return NumF64.from((double)this.value + ((NumF64)that).value);
        }
        if (that instanceof NumInt) {
            return NumInt.from(BigInteger.valueOf(this.value).add(((NumInt)that).value));
        }
        throw new AssertionError();
    }

    @Override
    public Num minus(Num that) {
        if (that instanceof NumI32) {
            return NumI64.from(this.value - (long)((NumI32)that).value);
        }
        if (that instanceof NumI64) {
            return NumI64.from(this.value - ((NumI64)that).value);
        }
        if (that instanceof NumF32) {
            return NumF32.from((float)this.value - ((NumF32)that).value);
        }
        if (that instanceof NumF64) {
            return NumF64.from((double)this.value - ((NumF64)that).value);
        }
        if (that instanceof NumInt) {
            return NumInt.from(BigInteger.valueOf(this.value).subtract(((NumInt)that).value));
        }
        throw new AssertionError();
    }

    @Override
    public Num times(Num that) {
        if (that instanceof NumI32) {
            return NumI64.from(this.value * (long)((NumI32)that).value);
        }
        if (that instanceof NumI64) {
            return NumI64.from(this.value * ((NumI64)that).value);
        }
        if (that instanceof NumF32) {
            return NumF32.from((float)this.value * ((NumF32)that).value);
        }
        if (that instanceof NumF64) {
            return NumF64.from((double)this.value * ((NumF64)that).value);
        }
        if (that instanceof NumInt) {
            return NumInt.from(BigInteger.valueOf(this.value).multiply(((NumInt)that).value));
        }
        throw new AssertionError();
    }

    @Override
    public Num divide(Num that) {
        if (that instanceof NumI32) {
            return NumF64.from((double)this.value / (double)((NumI32)that).value);
        }
        if (that instanceof NumI64) {
            return NumF64.from((double)this.value / (double)((NumI64)that).value);
        }
        if (that instanceof NumF32) {
            return NumF64.from((double)this.value / (double)((NumF32)that).value);
        }
        if (that instanceof NumF64) {
            return NumF64.from((double)this.value / ((NumF64)that).value);
        }
        if (that instanceof NumInt) {
            return NumF64.from((double)this.value / ((NumInt)that).value.doubleValue());
        }
        throw new AssertionError();
    }

    @Override
    public Num modulo(Num that) {
        if (that instanceof NumI32) {
            return NumI64.from(this.value % (long)((NumI32)that).value);
        }
        if (that instanceof NumI64) {
            return NumI64.from(this.value % ((NumI64)that).value);
        }
        if (that instanceof NumF32) {
            return NumF32.from((float)this.value % ((NumF32)that).value);
        }
        if (that instanceof NumF64) {
            return NumF64.from((double)this.value % ((NumF64)that).value);
        }
        if (that instanceof NumInt) {
            return NumInt.from(BigInteger.valueOf(this.value).mod(((NumInt)that).value));
        }
        throw new AssertionError();
    }

    @Override
    public Value bitwiseNot() {
        return NumI64.from(this.value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public Num negative() {
        return NumI64.from(-this.value);
    }

    @Override
    public Num inverse() {
        return NumF64.from(1.0 / (double)this.value);
    }

    @Override
    public Num abs() {
        return NumI64.from(Math.abs(this.value));
    }

    @Override
    public Num ceil() {
        return this;
    }

    @Override
    public Num floor() {
        return this;
    }

    @Override
    public Num round() {
        return this;
    }

    @Override
    public Num sqrt() {
        return NumF64.from(Math.sqrt(this.value));
    }

    @Override
    public Num pow(Num that) {
        return NumF64.from(Math.pow(this.value, that.doubleValue()));
    }

    @Override
    public void display(Output<?> output) {
        Format.debugLong((long)this.value, output);
    }

    static {
        cache = new ThreadLocal();
    }
}

