/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.collections;

import java.util.AbstractMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;
import swim.structure.collections.ValueKeyedListEntryIterator;
import swim.structure.collections.ValueList;
import swim.util.KeyedList;

public class ValueKeyedList<T>
extends ValueList<T>
implements KeyedList<T> {
    public ValueKeyedList(KeyedList<? extends Value> inner, Form<T> valueForm) {
        super((List<? extends Value>)inner, valueForm);
    }

    public KeyedList<Value> inner() {
        return (KeyedList)this.inner;
    }

    @Override
    public <T2> ValueKeyedList<T2> valueForm(Form<T2> valueForm) {
        return new ValueKeyedList<T2>((KeyedList<? extends Value>)((KeyedList)this.inner), valueForm);
    }

    @Override
    public <T2> ValueKeyedList<T2> valueClass(Class<T2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public T get(int index, Object key) {
        Value value = (Value)((KeyedList)this.inner).get(index, key);
        Object object = this.valueForm.cast(value);
        if (object != null) {
            return object;
        }
        return this.valueForm.unit();
    }

    public Map.Entry<Object, T> getEntry(int index) {
        Map.Entry entry = ((KeyedList)this.inner).getEntry(index);
        Object object = this.valueForm.cast((Item)entry.getValue());
        if (object == null) {
            object = this.valueForm.unit();
        }
        return new AbstractMap.SimpleImmutableEntry(entry.getKey(), object);
    }

    public Map.Entry<Object, T> getEntry(int index, Object key) {
        Map.Entry entry = ((KeyedList)this.inner).getEntry(index, key);
        if (entry != null) {
            Object object = this.valueForm.cast((Item)entry.getValue());
            if (object == null) {
                object = this.valueForm.unit();
            }
            return new AbstractMap.SimpleImmutableEntry(entry.getKey(), object);
        }
        return null;
    }

    public T set(int index, T newObject, Object key) {
        Value newValue = this.valueForm.mold(newObject).toValue();
        Value oldValue = (Value)((KeyedList)this.inner).set(index, (Object)newValue, key);
        Object oldObject = this.valueForm.cast(oldValue);
        if (oldObject != null) {
            return oldObject;
        }
        return this.valueForm.unit();
    }

    public boolean add(T newObject, Object key) {
        Value newValue = this.valueForm.mold(newObject).toValue();
        return ((KeyedList)this.inner).add((Object)newValue, key);
    }

    public void add(int index, T newObject, Object key) {
        Value newValue = this.valueForm.mold(newObject).toValue();
        ((KeyedList)this.inner).add(index, (Object)newValue, key);
    }

    public T remove(int index, Object key) {
        Value value = (Value)((KeyedList)this.inner).remove(index, key);
        Object object = this.valueForm.cast(value);
        if (object != null) {
            return object;
        }
        return this.valueForm.unit();
    }

    public void move(int fromIndex, int toIndex) {
        ((KeyedList)this.inner).move(fromIndex, toIndex);
    }

    public void move(int fromIndex, int toIndex, Object key) {
        ((KeyedList)this.inner).move(fromIndex, toIndex, key);
    }

    public ListIterator<Object> keyIterator() {
        return ((KeyedList)this.inner).keyIterator();
    }

    public ListIterator<Map.Entry<Object, T>> entryIterator() {
        if (this.valueForm != Form.forValue()) {
            return new ValueKeyedListEntryIterator(((KeyedList)this.inner).entryIterator(), this.valueForm);
        }
        return ((KeyedList)this.inner).entryIterator();
    }
}

