/*
 * Decompiled with CFR 0.152.
 */
package swim.structure;

import swim.codec.Output;
import swim.structure.Item;
import swim.structure.Value;

public final class Bool
extends Value {
    private static final Bool TRUE = new Bool(true);
    private static final Bool FALSE = new Bool(false);
    final boolean value;

    private Bool(boolean value) {
        this.value = value;
    }

    public static Bool from(boolean value) {
        return value ? TRUE : FALSE;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public String stringValue() {
        return this.value ? "true" : "false";
    }

    @Override
    public boolean booleanValue() {
        return this.value;
    }

    @Override
    public boolean booleanValue(boolean orElse) {
        return this.value;
    }

    @Override
    public Item conditional(Item thenTerm, Item elseTerm) {
        return this.value ? thenTerm : elseTerm;
    }

    @Override
    public Value conditional(Value thenTerm, Value elseTerm) {
        return this.value ? thenTerm : elseTerm;
    }

    @Override
    public Item or(Item that) {
        return this.value ? this : that;
    }

    @Override
    public Value or(Value that) {
        return this.value ? this : that;
    }

    @Override
    public Item and(Item that) {
        return this.value ? that : this;
    }

    @Override
    public Value and(Value that) {
        return this.value ? that : this;
    }

    @Override
    public Value not() {
        return Bool.from(!this.value);
    }

    @Override
    public int typeOrder() {
        return 7;
    }

    @Override
    public int compareTo(Item other) {
        if (other instanceof Bool) {
            return this.compareTo((Bool)other);
        }
        return Integer.compare(this.typeOrder(), other.typeOrder());
    }

    @Override
    int compareTo(Bool that) {
        if (this.value && !that.value) {
            return -1;
        }
        if (!this.value && that.value) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    public int hashCode() {
        return Boolean.valueOf(this.value).hashCode();
    }

    @Override
    public void debug(Output<?> output) {
        output = output.write("Bool").write(46).write("from").write(40).write(this.value ? "true" : "false").write(41);
    }

    @Override
    public void display(Output<?> output) {
        output = output.write(this.value ? "true" : "false");
    }
}

