/*
 * Decompiled with CFR 0.152.
 */
package swim.structure;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import swim.structure.Item;
import swim.structure.Value;
import swim.structure.form.ArrayForm;
import swim.structure.form.BigIntegerForm;
import swim.structure.form.BooleanForm;
import swim.structure.form.ByteBufferForm;
import swim.structure.form.ByteForm;
import swim.structure.form.CharacterForm;
import swim.structure.form.CollectionForm;
import swim.structure.form.DoubleForm;
import swim.structure.form.FloatForm;
import swim.structure.form.IntegerForm;
import swim.structure.form.ItemForm;
import swim.structure.form.LongForm;
import swim.structure.form.MapForm;
import swim.structure.form.NumberForm;
import swim.structure.form.PolyForm;
import swim.structure.form.ShortForm;
import swim.structure.form.StringForm;
import swim.structure.form.TagForm;
import swim.structure.form.UnitForm;
import swim.structure.form.ValueForm;

public abstract class Form<T> {
    private static Form<Byte> byteForm;
    private static Form<Short> shortForm;
    private static Form<Integer> integerForm;
    private static Form<Long> longForm;
    private static Form<Float> floatForm;
    private static Form<Double> doubleForm;
    private static Form<Character> characterForm;
    private static Form<Boolean> booleanForm;
    private static Form<BigInteger> bigIntegerForm;
    private static Form<Number> numberForm;
    private static Form<String> stringForm;
    private static Form<ByteBuffer> byteBufferForm;
    private static Form<Item> itemForm;
    private static Form<Value> valueForm;

    public static Form<Byte> forByte() {
        if (byteForm == null) {
            byteForm = new ByteForm((byte)0);
        }
        return byteForm;
    }

    public static Form<Short> forShort() {
        if (shortForm == null) {
            shortForm = new ShortForm((short)0);
        }
        return shortForm;
    }

    public static Form<Integer> forInteger() {
        if (integerForm == null) {
            integerForm = new IntegerForm(0);
        }
        return integerForm;
    }

    public static Form<Long> forLong() {
        if (longForm == null) {
            longForm = new LongForm(0L);
        }
        return longForm;
    }

    public static Form<Float> forFloat() {
        if (floatForm == null) {
            floatForm = new FloatForm(Float.valueOf(0.0f));
        }
        return floatForm;
    }

    public static Form<Double> forDouble() {
        if (doubleForm == null) {
            doubleForm = new DoubleForm(0.0);
        }
        return doubleForm;
    }

    public static Form<Character> forCharacter() {
        if (characterForm == null) {
            characterForm = new CharacterForm(Character.valueOf('\u0000'));
        }
        return characterForm;
    }

    public static Form<Boolean> forBoolean() {
        if (booleanForm == null) {
            booleanForm = new BooleanForm(false);
        }
        return booleanForm;
    }

    public static final Form<BigInteger> forBigInteger() {
        if (bigIntegerForm == null) {
            bigIntegerForm = new BigIntegerForm(BigInteger.ZERO);
        }
        return bigIntegerForm;
    }

    public static Form<Number> forNumber() {
        if (numberForm == null) {
            numberForm = new NumberForm(0);
        }
        return numberForm;
    }

    public static Form<String> forString() {
        if (stringForm == null) {
            stringForm = new StringForm("");
        }
        return stringForm;
    }

    public static Form<ByteBuffer> forByteBuffer() {
        if (byteBufferForm == null) {
            byteBufferForm = new ByteBufferForm();
        }
        return byteBufferForm;
    }

    public static Form<Item> forItem() {
        if (itemForm == null) {
            itemForm = new ItemForm(Item.absent());
        }
        return itemForm;
    }

    public static Form<Value> forValue() {
        if (valueForm == null) {
            valueForm = new ValueForm(Value.absent());
        }
        return valueForm;
    }

    public static <T> Form<T> forArray(Class<?> type, Form<?> form) {
        return new ArrayForm(type, form);
    }

    public static <CC, T> Form<CC> forCollection(Class<?> type, Form<T> form) {
        if (type == Collection.class || type == List.class) {
            type = ArrayList.class;
        } else if (type == Queue.class || type == Deque.class) {
            type = LinkedList.class;
        } else if (type == Set.class) {
            type = HashSet.class;
        } else if (type == SortedSet.class) {
            type = TreeSet.class;
        }
        return new CollectionForm<T>(type, form);
    }

    public static <T> Form<List<T>> forList(Form<T> form) {
        return Form.forCollection(List.class, form);
    }

    public static <T> Form<Set<T>> forSet(Form<T> form) {
        return Form.forCollection(Set.class, form);
    }

    public static <CC, K, V> Form<CC> forMap(Class<?> type, Form<K> keyForm, Form<V> valForm) {
        if (type == Map.class) {
            type = HashMap.class;
        } else if (type == SortedMap.class) {
            type = TreeMap.class;
        }
        return new MapForm<K, V>(type, keyForm, valForm);
    }

    public static <K, V> Form<Map<K, V>> forMap(Form<K> keyForm, Form<V> valForm) {
        return Form.forMap(Map.class, keyForm, valForm);
    }

    public static boolean isBuiltin(Class<?> type) {
        return type.isPrimitive() || type.isArray() || type == Object.class || String.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || ByteBuffer.class.isAssignableFrom(type);
    }

    public static <T> Form<T> forBuiltin(Class<?> type) {
        if (type == String.class) {
            return Form.forString();
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return Form.forByte();
        }
        if (type == Short.class || type == Short.TYPE) {
            return Form.forShort();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Form.forInteger();
        }
        if (type == Long.class || type == Long.TYPE) {
            return Form.forLong();
        }
        if (type == Float.class || type == Float.TYPE) {
            return Form.forFloat();
        }
        if (type == Double.class || type == Double.TYPE) {
            return Form.forDouble();
        }
        if (type == Character.class || type == Character.TYPE) {
            return Form.forCharacter();
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return Form.forBoolean();
        }
        if (type == BigInteger.class) {
            return Form.forBigInteger();
        }
        if (type == ByteBuffer.class) {
            return Form.forByteBuffer();
        }
        if (Value.class.isAssignableFrom(type)) {
            return Form.forValue();
        }
        if (Item.class.isAssignableFrom(type)) {
            return Form.forItem();
        }
        return null;
    }

    public static <T> Form<T> forClass(Class<?> type, PolyForm scope) {
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            return Form.forArray(componentType, Form.forClass(componentType));
        }
        Form<T> form = Form.forBuiltin(type);
        if (form != null) {
            return form;
        }
        if (scope == null) {
            scope = new PolyForm();
        }
        if ((form = scope.reflectClass(type)) != null) {
            return form;
        }
        return null;
    }

    public static <T> Form<T> forClass(Class<?> type) {
        return Form.forClass(type, null);
    }

    public String tag() {
        return null;
    }

    public Form<T> tag(String tag) {
        if (tag != null) {
            return new TagForm(tag, this);
        }
        return this;
    }

    public T unit() {
        return null;
    }

    public Form<T> unit(T unit) {
        if (unit != null) {
            return new UnitForm<T>(unit, this);
        }
        return this;
    }

    public abstract Class<?> type();

    public Item mold(T object, Item item) {
        return item.concat(this.mold(object));
    }

    public abstract Item mold(T var1);

    public T cast(Item item, T object) {
        return this.cast(item);
    }

    public abstract T cast(Item var1);
}

