/*
 * Decompiled with CFR 0.152.
 */
package swim.structure;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import swim.codec.Output;
import swim.structure.Attr;
import swim.structure.Bool;
import swim.structure.Field;
import swim.structure.Interpreter;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.RecordFieldIterator;
import swim.structure.RecordFieldSet;
import swim.structure.RecordIterator;
import swim.structure.RecordKeyIterator;
import swim.structure.RecordKeySet;
import swim.structure.RecordMap;
import swim.structure.RecordValueIterator;
import swim.structure.RecordValues;
import swim.structure.Slot;
import swim.structure.Text;
import swim.structure.Value;
import swim.util.Builder;
import swim.util.PairBuilder;

public abstract class Record
extends Value
implements List<Item>,
Builder<Item, Record>,
PairBuilder<Value, Value, Record> {
    protected static final AtomicIntegerFieldUpdater<Record> FLAGS = AtomicIntegerFieldUpdater.newUpdater(Record.class, "flags");
    static final int ALIASED = 1;
    static final int IMMUTABLE = 2;
    volatile int flags;

    protected Record() {
    }

    public static Record empty() {
        return RecordMap.empty();
    }

    public static Record create() {
        return RecordMap.create();
    }

    public static Record create(int initialSize) {
        return RecordMap.create(initialSize);
    }

    public static Record of() {
        return RecordMap.of();
    }

    public static Record of(Object object) {
        return RecordMap.of(object);
    }

    public static Record of(Object ... objects) {
        return RecordMap.of(objects);
    }

    static int expand(int n) {
        n = Math.max(8, n) - 1;
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return n + 1;
    }

    @Override
    public abstract boolean isEmpty();

    public boolean isArray() {
        return this.fieldCount() == 0;
    }

    public boolean isObject() {
        return this.valueCount() == 0;
    }

    @Override
    public abstract int size();

    @Override
    public final int length() {
        return this.size();
    }

    public int fieldCount() {
        int count = 0;
        for (Item member : this) {
            if (!(member instanceof Field)) continue;
            ++count;
        }
        return count;
    }

    public int valueCount() {
        int count = 0;
        for (Item member : this) {
            if (!(member instanceof Value)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isConstant() {
        for (Item member : this) {
            if (member.isConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String tag() {
        Item item = this.head();
        if (item instanceof Attr) {
            return ((Attr)item).key.value;
        }
        return null;
    }

    @Override
    public Value target() {
        Value value = null;
        Record record = null;
        boolean modified = false;
        for (Item item : this) {
            if (item instanceof Attr) {
                modified = true;
                continue;
            }
            if (value == null && item instanceof Value) {
                value = (Value)item;
                continue;
            }
            if (record == null) {
                record = Record.create();
                if (value != null) {
                    record.add(value);
                }
            }
            record.add(item);
        }
        if (value == null) {
            return Value.extant();
        }
        if (record == null) {
            return value;
        }
        if (modified) {
            return record;
        }
        return this;
    }

    @Override
    public Value flattened() {
        if (this.isEmpty()) {
            return Value.extant();
        }
        Iterator<Item> items = this.iterator();
        Item head = items.next();
        if (!items.hasNext() && head instanceof Value) {
            return (Value)head;
        }
        return this.branch();
    }

    @Override
    public Record unflattened() {
        return this;
    }

    @Override
    public Value header(String tag) {
        Item head = this.head();
        if (head instanceof Attr && head.keyEquals(tag)) {
            return ((Attr)head).value;
        }
        return Value.absent();
    }

    @Override
    public Record headers(String tag) {
        Item head = this.head();
        if (head instanceof Attr && head.keyEquals(tag)) {
            Value header = ((Attr)head).value;
            if (header instanceof Record) {
                return (Record)header;
            }
            return Record.of((Object)header);
        }
        return null;
    }

    @Override
    public Item head() {
        return this.getItem(0);
    }

    @Override
    public Record tail() {
        Record tail = Record.create();
        Iterator<Item> items = this.iterator();
        if (items.hasNext()) {
            items.next();
        }
        while (items.hasNext()) {
            tail.add(items.next());
        }
        return tail;
    }

    @Override
    public Value body() {
        Record tail = this.tail();
        if (!tail.isEmpty()) {
            return tail.flattened();
        }
        return Value.absent();
    }

    @Override
    public boolean contains(Object item) {
        return this.contains(Item.fromObject(item));
    }

    @Override
    public boolean contains(Item item) {
        for (Item member : this) {
            if (!member.equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> items) {
        HashSet q = new HashSet(items);
        Iterator<Item> elems = this.iterator();
        while (elems.hasNext() && !q.isEmpty()) {
            q.remove(elems.next());
        }
        return q.isEmpty();
    }

    @Override
    public boolean containsKey(Value key) {
        for (Item item : this) {
            if (!(item instanceof Field) || !item.keyEquals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(String key) {
        for (Item item : this) {
            if (!(item instanceof Field) || !item.keyEquals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Value value) {
        for (Item item : this) {
            if (!(item instanceof Field) || !item.toValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int indexOf(Object item) {
        return this.indexOf(Item.fromObject(item));
    }

    private int indexOf(Item item) {
        Iterator<Item> items = this.iterator();
        int index = 0;
        while (items.hasNext()) {
            if (item.equals(items.next())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object item) {
        return this.lastIndexOf(Item.fromObject(item));
    }

    private int lastIndexOf(Item item) {
        for (int index = this.size() - 1; index >= 0; --index) {
            if (!item.equals(this.getItem(index))) continue;
            return index;
        }
        return -1;
    }

    @Override
    public Value get(Value key) {
        for (Item item : this) {
            if (!(item instanceof Field) || !item.keyEquals(key)) continue;
            return item.toValue();
        }
        return Value.absent();
    }

    @Override
    public Value get(String key) {
        for (Item item : this) {
            if (!(item instanceof Field) || !item.keyEquals(key)) continue;
            return item.toValue();
        }
        return Value.absent();
    }

    @Override
    public Value getAttr(Text key) {
        for (Item item : this) {
            if (!(item instanceof Attr) || !item.keyEquals(key)) continue;
            return item.toValue();
        }
        return Value.absent();
    }

    @Override
    public Value getAttr(String key) {
        for (Item item : this) {
            if (!(item instanceof Attr) || !item.keyEquals(key)) continue;
            return item.toValue();
        }
        return Value.absent();
    }

    @Override
    public Value getSlot(Value key) {
        for (Item item : this) {
            if (!(item instanceof Slot) || !item.keyEquals(key)) continue;
            return item.toValue();
        }
        return Value.absent();
    }

    @Override
    public Value getSlot(String key) {
        for (Item item : this) {
            if (!(item instanceof Slot) || !item.keyEquals(key)) continue;
            return item.toValue();
        }
        return Value.absent();
    }

    @Override
    public Field getField(Value key) {
        for (Item item : this) {
            if (!(item instanceof Field) || !item.keyEquals(key)) continue;
            return (Field)item;
        }
        return null;
    }

    @Override
    public Field getField(String key) {
        for (Item item : this) {
            if (!(item instanceof Field) || !item.keyEquals(key)) continue;
            return (Field)item;
        }
        return null;
    }

    @Override
    public abstract Item get(int var1);

    @Override
    public abstract Item getItem(int var1);

    public Value put(Value key, Value newValue) {
        ListIterator<Item> items = this.listIterator();
        while (items.hasNext()) {
            Item item = items.next();
            if (!(item instanceof Field) || !item.keyEquals(key)) continue;
            Field field = (Field)item;
            if (field.isMutable()) {
                return field.setValue(newValue);
            }
            Value oldValue = field.toValue();
            items.set(field.updatedValue(newValue));
            return oldValue;
        }
        this.add(new Slot(key, newValue));
        return Value.absent();
    }

    public Value put(Value key, String newValue) {
        return this.put(key, (Value)Text.from(newValue));
    }

    public Value put(Value key, int newValue) {
        return this.put(key, (Value)Num.from(newValue));
    }

    public Value put(Value key, long newValue) {
        return this.put(key, (Value)Num.from(newValue));
    }

    public Value put(Value key, float newValue) {
        return this.put(key, (Value)Num.from(newValue));
    }

    public Value put(Value key, double newValue) {
        return this.put(key, (Value)Num.from(newValue));
    }

    public Value put(Value key, boolean newValue) {
        return this.put(key, (Value)Bool.from(newValue));
    }

    public Value put(String key, Value newValue) {
        ListIterator<Item> items = this.listIterator();
        while (items.hasNext()) {
            Item item = items.next();
            if (!(item instanceof Field) || !item.keyEquals(key)) continue;
            Field field = (Field)item;
            if (field.isMutable()) {
                return field.setValue(newValue);
            }
            Value oldValue = field.toValue();
            items.set(field.updatedValue(newValue));
            return oldValue;
        }
        this.add(new Slot(Text.from(key), newValue));
        return Value.absent();
    }

    public Value put(String key, String newValue) {
        return this.put(key, (Value)Text.from(newValue));
    }

    public Value put(String key, int newValue) {
        return this.put(key, (Value)Num.from(newValue));
    }

    public Value put(String key, long newValue) {
        return this.put(key, (Value)Num.from(newValue));
    }

    public Value put(String key, float newValue) {
        return this.put(key, (Value)Num.from(newValue));
    }

    public Value put(String key, double newValue) {
        return this.put(key, (Value)Num.from(newValue));
    }

    public Value put(String key, boolean newValue) {
        return this.put(key, (Value)Bool.from(newValue));
    }

    public Value putAttr(Text key, Value newValue) {
        ListIterator<Item> items = this.listIterator();
        while (items.hasNext()) {
            Item item = items.next();
            if (!(item instanceof Field) || !item.keyEquals(key)) continue;
            if (item instanceof Attr && item.isMutable()) {
                return ((Attr)item).setValue(newValue);
            }
            Value oldValue = item.toValue();
            items.set(new Attr(key, newValue));
            return oldValue;
        }
        this.add(new Attr(key, newValue));
        return Value.absent();
    }

    public Value putAttr(Text key, String newValue) {
        return this.putAttr(key, (Value)Text.from(newValue));
    }

    public Value putAttr(Text key, int newValue) {
        return this.putAttr(key, (Value)Num.from(newValue));
    }

    public Value putAttr(Text key, long newValue) {
        return this.putAttr(key, (Value)Num.from(newValue));
    }

    public Value putAttr(Text key, float newValue) {
        return this.putAttr(key, (Value)Num.from(newValue));
    }

    public Value putAttr(Text key, double newValue) {
        return this.putAttr(key, (Value)Num.from(newValue));
    }

    public Value putAttr(Text key, boolean newValue) {
        return this.putAttr(key, (Value)Bool.from(newValue));
    }

    public Value putAttr(String key, Value newValue) {
        ListIterator<Item> items = this.listIterator();
        while (items.hasNext()) {
            Item item = items.next();
            if (!(item instanceof Field) || !item.keyEquals(key)) continue;
            if (item instanceof Attr && item.isMutable()) {
                return ((Attr)item).setValue(newValue);
            }
            Value oldValue = item.toValue();
            items.set(new Attr(Text.from(key), newValue));
            return oldValue;
        }
        this.add(new Attr(Text.from(key), newValue));
        return Value.absent();
    }

    public Value putAttr(String key, String newValue) {
        return this.putAttr(key, (Value)Text.from(newValue));
    }

    public Value putAttr(String key, int newValue) {
        return this.putAttr(key, (Value)Num.from(newValue));
    }

    public Value putAttr(String key, long newValue) {
        return this.putAttr(key, (Value)Num.from(newValue));
    }

    public Value putAttr(String key, float newValue) {
        return this.putAttr(key, (Value)Num.from(newValue));
    }

    public Value putAttr(String key, double newValue) {
        return this.putAttr(key, (Value)Num.from(newValue));
    }

    public Value putAttr(String key, boolean newValue) {
        return this.putAttr(key, (Value)Bool.from(newValue));
    }

    public Value putSlot(Value key, Value newValue) {
        ListIterator<Item> items = this.listIterator();
        while (items.hasNext()) {
            Item item = items.next();
            if (!(item instanceof Field) || !item.keyEquals(key)) continue;
            if (item instanceof Slot && item.isMutable()) {
                return ((Slot)item).setValue(newValue);
            }
            Value oldValue = item.toValue();
            items.set(new Slot(key, newValue));
            return oldValue;
        }
        this.add(new Slot(key, newValue));
        return Value.absent();
    }

    public Value putSlot(Value key, String newValue) {
        return this.putSlot(key, (Value)Text.from(newValue));
    }

    public Value putSlot(Value key, int newValue) {
        return this.putSlot(key, (Value)Num.from(newValue));
    }

    public Value putSlot(Value key, long newValue) {
        return this.putSlot(key, (Value)Num.from(newValue));
    }

    public Value putSlot(Value key, float newValue) {
        return this.putSlot(key, (Value)Num.from(newValue));
    }

    public Value putSlot(Value key, double newValue) {
        return this.putSlot(key, (Value)Num.from(newValue));
    }

    public Value putSlot(Value key, boolean newValue) {
        return this.putSlot(key, (Value)Bool.from(newValue));
    }

    public Value putSlot(String key, Value newValue) {
        ListIterator<Item> items = this.listIterator();
        while (items.hasNext()) {
            Item item = items.next();
            if (!(item instanceof Field) || !item.keyEquals(key)) continue;
            if (item instanceof Slot && item.isMutable()) {
                return ((Slot)item).setValue(newValue);
            }
            Value oldValue = item.toValue();
            items.set(new Slot(Text.from(key), newValue));
            return oldValue;
        }
        this.add(new Slot(Text.from(key), newValue));
        return Value.absent();
    }

    public Value putSlot(String key, String newValue) {
        return this.putSlot(key, (Value)Text.from(newValue));
    }

    public Value putSlot(String key, int newValue) {
        return this.putSlot(key, (Value)Num.from(newValue));
    }

    public Value putSlot(String key, long newValue) {
        return this.putSlot(key, (Value)Num.from(newValue));
    }

    public Value putSlot(String key, float newValue) {
        return this.putSlot(key, (Value)Num.from(newValue));
    }

    public Value putSlot(String key, double newValue) {
        return this.putSlot(key, (Value)Num.from(newValue));
    }

    public Value putSlot(String key, boolean newValue) {
        return this.putSlot(key, (Value)Bool.from(newValue));
    }

    public void putAll(Map<? extends Value, ? extends Value> fields) {
        for (Map.Entry<? extends Value, ? extends Value> field : fields.entrySet()) {
            this.put(field.getKey(), field.getValue());
        }
    }

    @Override
    public Item set(int index, Item item) {
        return this.setItem(index, item);
    }

    public abstract Item setItem(int var1, Item var2);

    public Item setItem(int index, String value) {
        return this.setItem(index, Text.from(value));
    }

    public Item setItem(int index, int value) {
        return this.setItem(index, Num.from(value));
    }

    public Item setItem(int index, long value) {
        return this.setItem(index, Num.from(value));
    }

    public Item setItem(int index, float value) {
        return this.setItem(index, Num.from(value));
    }

    public Item setItem(int index, double value) {
        return this.setItem(index, Num.from(value));
    }

    public Item setItem(int index, boolean value) {
        return this.setItem(index, Bool.from(value));
    }

    @Override
    public abstract boolean add(Item var1);

    @Override
    public boolean add(String item) {
        return this.add(Text.from(item));
    }

    @Override
    public boolean add(int item) {
        return this.add(Num.from(item));
    }

    @Override
    public boolean add(long item) {
        return this.add(Num.from(item));
    }

    @Override
    public boolean add(float item) {
        return this.add(Num.from(item));
    }

    @Override
    public boolean add(double item) {
        return this.add(Num.from(item));
    }

    @Override
    public boolean add(boolean item) {
        return this.add(Bool.from(item));
    }

    @Override
    public abstract void add(int var1, Item var2);

    @Override
    public void add(int index, String item) {
        this.add(index, (Item)Text.from(item));
    }

    @Override
    public void add(int index, int item) {
        this.add(index, (Item)Num.from(item));
    }

    @Override
    public void add(int index, long item) {
        this.add(index, (Item)Num.from(item));
    }

    @Override
    public void add(int index, float item) {
        this.add(index, (Item)Num.from(item));
    }

    @Override
    public void add(int index, double item) {
        this.add(index, (Item)Num.from(item));
    }

    @Override
    public void add(int index, boolean item) {
        this.add(index, (Item)Bool.from(item));
    }

    public boolean add(Value key, Value value) {
        return this.add(new Slot(key, value));
    }

    @Override
    public boolean addAll(Collection<? extends Item> items) {
        boolean changed = false;
        for (Item item : items) {
            this.add(item);
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Item> items) {
        boolean changed = false;
        for (Item item : items) {
            this.add(index, item);
            changed = true;
            ++index;
        }
        return changed;
    }

    public Record attr(Text key, Value value) {
        this.add(new Attr(key, value));
        return this;
    }

    public Record attr(Text key, String value) {
        return this.attr(key, (Value)Text.from(value));
    }

    public Record attr(Text key, int value) {
        return this.attr(key, (Value)Num.from(value));
    }

    public Record attr(Text key, long value) {
        return this.attr(key, (Value)Num.from(value));
    }

    public Record attr(Text key, float value) {
        return this.attr(key, (Value)Num.from(value));
    }

    public Record attr(Text key, double value) {
        return this.attr(key, (Value)Num.from(value));
    }

    public Record attr(Text key, boolean value) {
        return this.attr(key, (Value)Bool.from(value));
    }

    public Record attr(Text key) {
        return this.attr(key, Value.extant());
    }

    public Record attr(String key, Value value) {
        return this.attr(Text.from(key), value);
    }

    public Record attr(String key, String value) {
        return this.attr(key, (Value)Text.from(value));
    }

    public Record attr(String key, int value) {
        return this.attr(key, (Value)Num.from(value));
    }

    public Record attr(String key, long value) {
        return this.attr(key, (Value)Num.from(value));
    }

    public Record attr(String key, float value) {
        return this.attr(key, (Value)Num.from(value));
    }

    public Record attr(String key, double value) {
        return this.attr(key, (Value)Num.from(value));
    }

    public Record attr(String key, boolean value) {
        return this.attr(key, (Value)Bool.from(value));
    }

    public Record attr(String key) {
        return this.attr(key, Value.extant());
    }

    public Record slot(Value key, Value value) {
        this.add(new Slot(key, value));
        return this;
    }

    public Record slot(Value key, String value) {
        return this.slot(key, (Value)Text.from(value));
    }

    public Record slot(Value key, int value) {
        return this.slot(key, (Value)Num.from(value));
    }

    public Record slot(Value key, long value) {
        return this.slot(key, (Value)Num.from(value));
    }

    public Record slot(Value key, float value) {
        return this.slot(key, (Value)Num.from(value));
    }

    public Record slot(Value key, double value) {
        return this.slot(key, (Value)Num.from(value));
    }

    public Record slot(Value key, boolean value) {
        return this.slot(key, (Value)Bool.from(value));
    }

    public Record slot(Value key) {
        return this.slot(key, Value.extant());
    }

    public Record slot(String key, Value value) {
        return this.slot((Value)Text.from(key), value);
    }

    public Record slot(String key, String value) {
        return this.slot(key, (Value)Text.from(value));
    }

    public Record slot(String key, int value) {
        return this.slot(key, (Value)Num.from(value));
    }

    public Record slot(String key, long value) {
        return this.slot(key, (Value)Num.from(value));
    }

    public Record slot(String key, float value) {
        return this.slot(key, (Value)Num.from(value));
    }

    public Record slot(String key, double value) {
        return this.slot(key, (Value)Num.from(value));
    }

    public Record slot(String key, boolean value) {
        return this.slot(key, (Value)Bool.from(value));
    }

    public Record slot(String key) {
        return this.slot(key, Value.extant());
    }

    public Record item(Item item) {
        this.add(item);
        return this;
    }

    public Record item(String item) {
        return this.item(Text.from(item));
    }

    public Record item(int item) {
        return this.item(Num.from(item));
    }

    public Record item(long item) {
        return this.item(Num.from(item));
    }

    public Record item(float item) {
        return this.item(Num.from(item));
    }

    public Record item(double item) {
        return this.item(Num.from(item));
    }

    public Record item(boolean item) {
        return this.item(Bool.from(item));
    }

    @Override
    public abstract Item remove(int var1);

    @Override
    public boolean remove(Object object) {
        Item item = Item.fromObject(object);
        int index = this.indexOf(item);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    public boolean removeKey(Value key) {
        Iterator<Item> items = this.iterator();
        while (items.hasNext()) {
            Item item = items.next();
            if (!item.keyEquals(key)) continue;
            items.remove();
            return true;
        }
        return false;
    }

    public boolean removeKey(String key) {
        Iterator<Item> items = this.iterator();
        while (items.hasNext()) {
            Item item = items.next();
            if (!item.keyEquals(key)) continue;
            items.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> items) {
        boolean modified = false;
        Iterator<Item> iter = this.iterator();
        while (iter.hasNext()) {
            Item item = iter.next();
            if (!items.contains(item)) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> items) {
        boolean modified = false;
        Iterator<Item> iter = this.iterator();
        while (iter.hasNext()) {
            Item item = iter.next();
            if (items.contains(item)) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public abstract void clear();

    @Override
    public Record updated(Value key, Value value) {
        Record record = this.isMutable() ? this : this.branch();
        ListIterator<Item> items = record.listIterator();
        while (items.hasNext()) {
            Item item = items.next();
            if (!item.keyEquals(key)) continue;
            if (item instanceof Field && item.isMutable()) {
                ((Field)item).setValue(value);
            } else {
                items.set(new Slot(key, value));
            }
            return record;
        }
        record.add(new Slot(key, value));
        return record;
    }

    @Override
    public Record updated(String key, Value value) {
        Record record = this.isMutable() ? this : this.branch();
        ListIterator<Item> items = record.listIterator();
        while (items.hasNext()) {
            Item item = items.next();
            if (!item.keyEquals(key)) continue;
            if (item instanceof Field && item.isMutable()) {
                ((Field)item).setValue(value);
            } else {
                items.set(new Slot(Text.from(key), value));
            }
            return record;
        }
        record.add(new Slot(Text.from(key), value));
        return record;
    }

    @Override
    public Record updatedAttr(Text key, Value value) {
        Record record = this.isMutable() ? this : this.branch();
        ListIterator<Item> items = record.listIterator();
        while (items.hasNext()) {
            Item item = items.next();
            if (!item.keyEquals(key)) continue;
            if (item instanceof Attr && item.isMutable()) {
                ((Attr)item).setValue(value);
            } else {
                items.set(new Attr(key, value));
            }
            return record;
        }
        record.add(new Attr(key, value));
        return record;
    }

    @Override
    public Record updatedAttr(String key, Value value) {
        Record record = this.isMutable() ? this : this.branch();
        ListIterator<Item> items = record.listIterator();
        while (items.hasNext()) {
            Item item = items.next();
            if (!item.keyEquals(key)) continue;
            if (item instanceof Attr && item.isMutable()) {
                ((Attr)item).setValue(value);
            } else {
                items.set(new Attr(Text.from(key), value));
            }
            return record;
        }
        record.add(new Attr(Text.from(key), value));
        return record;
    }

    @Override
    public Record updatedSlot(Value key, Value value) {
        Record record = this.isMutable() ? this : this.branch();
        ListIterator<Item> items = record.listIterator();
        while (items.hasNext()) {
            Item item = items.next();
            if (!item.keyEquals(key)) continue;
            if (item instanceof Slot && item.isMutable()) {
                ((Slot)item).setValue(value);
            } else {
                items.set(new Slot(key, value));
            }
            return record;
        }
        record.add(new Slot(key, value));
        return record;
    }

    @Override
    public Record updatedSlot(String key, Value value) {
        Record record = this.isMutable() ? this : this.branch();
        ListIterator<Item> items = record.listIterator();
        while (items.hasNext()) {
            Item item = items.next();
            if (!item.keyEquals(key)) continue;
            if (item instanceof Slot && item.isMutable()) {
                ((Slot)item).setValue(value);
            } else {
                items.set(new Slot(Text.from(key), value));
            }
            return record;
        }
        record.add(new Slot(Text.from(key), value));
        return record;
    }

    @Override
    public Record appended(Item item) {
        Record record = this.isMutable() ? this : this.branch();
        record.add(item);
        return record;
    }

    @Override
    public Record appended(Object ... items) {
        Record record = this.isMutable() ? this : this.branch();
        record.addAll(Record.of(items));
        return record;
    }

    @Override
    public Record prepended(Item item) {
        Record record = this.isMutable() ? this : this.branch();
        record.add(0, item);
        return record;
    }

    @Override
    public Record prepended(Object ... items) {
        Record record = this.isMutable() ? this : this.branch();
        record.addAll(0, Record.of(items));
        return record;
    }

    @Override
    public Record removed(Value key) {
        Record record = this.isMutable() ? this : this.branch();
        record.removeKey(key);
        return record;
    }

    @Override
    public Record removed(String key) {
        Record record = this.isMutable() ? this : this.branch();
        record.removeKey(key);
        return record;
    }

    @Override
    public Record concat(Item that) {
        if (!that.isDefined()) {
            return this.branch();
        }
        Record record = Record.create(this.length() + that.length());
        record.addAll(this);
        if (that instanceof Record) {
            record.addAll((Record)that);
        } else {
            record.add(that);
        }
        return record;
    }

    @Override
    public Record evaluate(Interpreter interpreter) {
        Record scope = Record.create();
        interpreter.pushScope(scope);
        boolean changed = false;
        for (Item oldItem : this) {
            Item newItem = oldItem.evaluate(interpreter);
            if (newItem.isDefined()) {
                scope.add(newItem);
            }
            if (oldItem == newItem) continue;
            changed = true;
        }
        interpreter.popScope();
        return changed ? scope : this;
    }

    @Override
    public Record substitute(Interpreter interpreter) {
        Record scope = Record.create();
        interpreter.pushScope(scope);
        boolean changed = false;
        for (Item oldItem : this) {
            Item newItem = oldItem.substitute(interpreter);
            if (newItem.isDefined()) {
                scope.add(newItem);
            }
            if (oldItem == newItem) continue;
            changed = true;
        }
        interpreter.popScope();
        return changed ? scope : this;
    }

    @Override
    public String stringValue() {
        return this.stringValue(null);
    }

    @Override
    public String stringValue(String orElse) {
        StringBuilder recordString = new StringBuilder();
        for (Item item : this) {
            String itemString;
            if (item instanceof Value && (itemString = item.stringValue(null)) != null) {
                recordString.append(itemString);
                continue;
            }
            return orElse;
        }
        return recordString.toString();
    }

    @Override
    public boolean isAliased() {
        return false;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public void alias() {
    }

    @Override
    public Record branch() {
        Record branch = Record.create();
        branch.addAll(this);
        return branch;
    }

    @Override
    public Record commit() {
        return this;
    }

    public Record bind() {
        return this;
    }

    public Item[] toArray() {
        int n = this.size();
        Item[] array = new Item[n];
        Iterator<Item> items = this.iterator();
        int i = 0;
        while (items.hasNext()) {
            array[i] = items.next();
            ++i;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int n = this.size();
        if (array.length < n) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), n);
        }
        Iterator<Item> items = this.iterator();
        int i = 0;
        while (items.hasNext()) {
            array[i] = items.next();
            ++i;
        }
        if (array.length > n) {
            array[n] = null;
        }
        return array;
    }

    public Record subList(int fromIndex, int toIndex) {
        Iterator<Item> items = this.iterator();
        Record record = Record.create();
        int index = 0;
        while (items.hasNext()) {
            if (index >= fromIndex && index < toIndex) {
                record.add(items.next());
            } else if (index >= toIndex) break;
            ++index;
        }
        return record;
    }

    public Set<Map.Entry<Value, Value>> entrySet() {
        return this.fieldSet();
    }

    public Set<Field> fieldSet() {
        return new RecordFieldSet(this);
    }

    public Set<Value> keySet() {
        return new RecordKeySet(this);
    }

    public Collection<Value> values() {
        return new RecordValues(this);
    }

    @Override
    public Iterator<Item> iterator() {
        return new RecordIterator(this);
    }

    @Override
    public ListIterator<Item> listIterator() {
        return new RecordIterator(this);
    }

    @Override
    public ListIterator<Item> listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        return new RecordIterator(this, index);
    }

    public Iterator<Value> keyIterator() {
        return new RecordKeyIterator(this.iterator());
    }

    public Iterator<Value> valueIterator() {
        return new RecordValueIterator(this.iterator());
    }

    public Iterator<Field> fieldIterator() {
        return new RecordFieldIterator(this.iterator());
    }

    @Override
    public int typeOrder() {
        return 3;
    }

    @Override
    public int compareTo(Item other) {
        if (other instanceof Record) {
            return this.compareTo((Record)other);
        }
        return Integer.compare(this.typeOrder(), other.typeOrder());
    }

    @Override
    public int compareTo(Record that) {
        Iterator<Item> xs = this.iterator();
        Iterator<Item> ys = that.iterator();
        int order = 0;
        while (xs.hasNext() && ys.hasNext() && (order = xs.next().compareTo(ys.next())) == 0) {
        }
        if (order != 0) {
            return order;
        }
        if (!xs.hasNext() && ys.hasNext()) {
            return -1;
        }
        if (xs.hasNext() && !ys.hasNext()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof List) {
            List that = (List)other;
            Iterator<Item> xs = this.iterator();
            Iterator ys = that.iterator();
            while (xs.hasNext() && ys.hasNext()) {
                if (xs.next().equals(ys.next())) continue;
                return false;
            }
            return !xs.hasNext() && !ys.hasNext();
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = 1;
        for (Item item : this) {
            code = 31 * code + item.hashCode();
        }
        return code;
    }

    @Override
    public void debug(Output<?> output) {
        output = output.write("Record").write(46);
        if (this.isEmpty()) {
            output = output.write("empty").write(40).write(41);
        } else {
            Iterator<Item> items = this.iterator();
            output = output.write("of").write(40).display((Object)items.next());
            while (items.hasNext()) {
                output = output.write(", ").display((Object)items.next());
            }
            output = output.write(41);
        }
    }
}

