/*
 * Decompiled with CFR 0.152.
 */
package swim.structure;

import swim.codec.Output;
import swim.structure.Bool;
import swim.structure.Expression;
import swim.structure.Extant;
import swim.structure.Field;
import swim.structure.Interpreter;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Text;
import swim.structure.Value;
import swim.structure.operator.BitwiseAndOperator;
import swim.structure.operator.BitwiseOrOperator;
import swim.structure.operator.BitwiseXorOperator;
import swim.structure.operator.DivideOperator;
import swim.structure.operator.MinusOperator;
import swim.structure.operator.ModuloOperator;
import swim.structure.operator.PlusOperator;
import swim.structure.operator.TimesOperator;

public final class Slot
extends Field {
    final Value key;
    Value value;

    Slot(Value key, Value value, int flags) {
        this.key = key.commit();
        this.value = value;
        this.flags = flags;
    }

    Slot(Value key, Value value) {
        this(key, value, 0);
    }

    public static Slot of(Value key, Value value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return new Slot(key, value);
    }

    public static Slot of(Value key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return new Slot(key, Text.from(value));
    }

    public static Slot of(Value key, int value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new Slot(key, Num.from(value));
    }

    public static Slot of(Value key, long value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new Slot(key, Num.from(value));
    }

    public static Slot of(Value key, float value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new Slot(key, Num.from(value));
    }

    public static Slot of(Value key, double value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new Slot(key, Num.from(value));
    }

    public static Slot of(Value key, boolean value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new Slot(key, Bool.from(value));
    }

    public static Slot of(String key, Value value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return new Slot(Text.from(key), value);
    }

    public static Slot of(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return new Slot(Text.from(key), Text.from(value));
    }

    public static Slot of(String key, int value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new Slot(Text.from(key), Num.from(value));
    }

    public static Slot of(String key, long value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new Slot(Text.from(key), Num.from(value));
    }

    public static Slot of(String key, float value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new Slot(Text.from(key), Num.from(value));
    }

    public static Slot of(String key, double value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new Slot(Text.from(key), Num.from(value));
    }

    public static Slot of(String key, boolean value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new Slot(Text.from(key), Bool.from(value));
    }

    public static Slot of(Value key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new Slot(key, Value.extant());
    }

    public static Slot of(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return new Slot(Text.from(key), Value.extant());
    }

    @Override
    public boolean isConstant() {
        return this.key.isConstant() && this.value.isConstant();
    }

    @Override
    public Value key() {
        return this.key;
    }

    @Override
    public Value value() {
        return this.value;
    }

    @Override
    public Value setValue(Value newValue) {
        if ((this.flags & 1) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        Value oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    @Override
    public Slot updatedValue(Value value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return new Slot(this.key, value);
    }

    @Override
    public Item bitwiseOr(Item that) {
        if (that instanceof Expression) {
            return new BitwiseOrOperator(this, that);
        }
        Value newValue = that instanceof Slot && this.key.equals(((Slot)that).key) ? this.value.bitwiseOr(((Slot)that).value) : (that instanceof Value ? this.value.bitwiseOr((Value)that) : Value.absent());
        if (newValue.isDefined()) {
            return new Slot(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item bitwiseXor(Item that) {
        if (that instanceof Expression) {
            return new BitwiseXorOperator(this, that);
        }
        Value newValue = that instanceof Slot && this.key.equals(((Slot)that).key) ? this.value.bitwiseXor(((Slot)that).value) : (that instanceof Value ? this.value.bitwiseXor((Value)that) : Value.absent());
        if (newValue.isDefined()) {
            return new Slot(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item bitwiseAnd(Item that) {
        if (that instanceof Expression) {
            return new BitwiseAndOperator(this, that);
        }
        Value newValue = that instanceof Slot && this.key.equals(((Slot)that).key) ? this.value.bitwiseAnd(((Slot)that).value) : (that instanceof Value ? this.value.bitwiseAnd((Value)that) : Value.absent());
        if (newValue.isDefined()) {
            return new Slot(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item plus(Item that) {
        if (that instanceof Expression) {
            return new PlusOperator(this, that);
        }
        Value newValue = that instanceof Slot && this.key.equals(((Slot)that).key) ? this.value.plus(((Slot)that).value) : (that instanceof Value ? this.value.plus((Value)that) : Value.absent());
        if (newValue.isDefined()) {
            return new Slot(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item minus(Item that) {
        if (that instanceof Expression) {
            return new MinusOperator(this, that);
        }
        Value newValue = that instanceof Slot && this.key.equals(((Slot)that).key) ? this.value.minus(((Slot)that).value) : (that instanceof Value ? this.value.minus((Value)that) : Value.absent());
        if (newValue.isDefined()) {
            return new Slot(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item times(Item that) {
        if (that instanceof Expression) {
            return new TimesOperator(this, that);
        }
        Value newValue = that instanceof Slot && this.key.equals(((Slot)that).key) ? this.value.times(((Slot)that).value) : (that instanceof Value ? this.value.times((Value)that) : Value.absent());
        if (newValue.isDefined()) {
            return new Slot(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item divide(Item that) {
        if (that instanceof Expression) {
            return new DivideOperator(this, that);
        }
        Value newValue = that instanceof Slot && this.key.equals(((Slot)that).key) ? this.value.divide(((Slot)that).value) : (that instanceof Value ? this.value.divide((Value)that) : Value.absent());
        if (newValue.isDefined()) {
            return new Slot(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item modulo(Item that) {
        if (that instanceof Expression) {
            return new ModuloOperator(this, that);
        }
        Value newValue = that instanceof Slot && this.key.equals(((Slot)that).key) ? this.value.modulo(((Slot)that).value) : (that instanceof Value ? this.value.modulo((Value)that) : Value.absent());
        if (newValue.isDefined()) {
            return new Slot(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item not() {
        Value newValue = this.value.not();
        if (newValue.isDefined()) {
            return new Slot(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item bitwiseNot() {
        Value newValue = this.value.bitwiseNot();
        if (newValue.isDefined()) {
            return new Slot(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item negative() {
        Value newValue = this.value.negative();
        if (newValue.isDefined()) {
            return new Slot(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item positive() {
        Value newValue = this.value.positive();
        if (newValue.isDefined()) {
            return new Slot(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item inverse() {
        Value newValue = this.value.inverse();
        if (newValue.isDefined()) {
            return new Slot(this.key, newValue);
        }
        return Item.absent();
    }

    @Override
    public Item evaluate(Interpreter interpreter) {
        Value key = this.key.evaluate(interpreter).toValue();
        Value value = this.value.evaluate(interpreter).toValue();
        if (key == this.key && value == this.value) {
            return this;
        }
        if (key.isDefined() && value.isDefined()) {
            return new Slot(key, value);
        }
        return Item.absent();
    }

    @Override
    public Item substitute(Interpreter interpreter) {
        Value key = this.key.substitute(interpreter).toValue();
        Value value = this.value.substitute(interpreter).toValue();
        if (key == this.key && value == this.value) {
            return this;
        }
        if (key.isDefined() && value.isDefined()) {
            return new Slot(key, value);
        }
        return Item.absent();
    }

    @Override
    public boolean isAliased() {
        return false;
    }

    @Override
    public boolean isMutable() {
        return (this.flags & 1) == 0;
    }

    @Override
    public void alias() {
        int newFlags;
        int oldFlags;
        while (((oldFlags = this.flags) & 1) == 0 && !FLAGS.compareAndSet(this, oldFlags, newFlags = oldFlags | 1)) {
        }
    }

    @Override
    public Slot branch() {
        if ((this.flags & 1) != 0) {
            return new Slot(this.key, this.value, this.flags & 0xFFFFFFFE);
        }
        return this;
    }

    @Override
    public Slot commit() {
        int oldFlags;
        while (((oldFlags = this.flags) & 1) == 0) {
            int newFlags = oldFlags | 1;
            if (!FLAGS.compareAndSet(this, oldFlags, newFlags)) continue;
            this.value.commit();
            break;
        }
        return this;
    }

    @Override
    public int typeOrder() {
        return 2;
    }

    @Override
    public int compareTo(Item other) {
        if (other instanceof Slot) {
            return this.compareTo((Slot)other);
        }
        return Integer.compare(this.typeOrder(), other.typeOrder());
    }

    @Override
    int compareTo(Slot that) {
        int order = this.key.compareTo(that.key);
        if (order == 0) {
            order = this.value.compareTo(that.value);
        }
        return order;
    }

    @Override
    public boolean keyEquals(Object key) {
        if (key instanceof String && this.key instanceof Text) {
            return ((Text)this.key).value.equals(key);
        }
        if (key instanceof Field) {
            return this.key.equals(((Field)key).getKey());
        }
        return this.key.equals(key);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Slot) {
            Slot that = (Slot)other;
            return this.key.equals(that.key) && this.value.equals(that.value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.key.hashCode() ^ this.value.hashCode();
    }

    @Override
    public void debug(Output<?> output) {
        output = output.write("Slot").write(46).write("of").write(40).display((Object)this.key);
        if (!(this.value instanceof Extant)) {
            output = output.write(", ").display((Object)this.value);
        }
        output = output.write(41);
    }
}

