/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.form;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import swim.collections.HashTrieMap;
import swim.structure.Bool;
import swim.structure.Data;
import swim.structure.Form;
import swim.structure.FormException;
import swim.structure.Header;
import swim.structure.Item;
import swim.structure.Kind;
import swim.structure.Member;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Tag;
import swim.structure.Text;
import swim.structure.form.ClassForm;
import swim.structure.form.SlotForm;

public class PolyForm
extends Form<Object>
implements Cloneable {
    final Object unit;
    HashTrieMap<Class<?>, Form<?>> classForms;
    HashTrieMap<String, Form<?>> tagForms;

    PolyForm(Object unit, HashTrieMap<Class<?>, Form<?>> classForms, HashTrieMap<String, Form<?>> tagForms) {
        this.unit = unit;
        this.classForms = classForms;
        this.tagForms = tagForms;
    }

    public PolyForm() {
        this(null, HashTrieMap.empty(), HashTrieMap.empty());
    }

    @Override
    public final Object unit() {
        return this.unit;
    }

    public PolyForm unit(Object unit) {
        return new PolyForm(unit, this.classForms, this.tagForms);
    }

    @Override
    public final Class<?> type() {
        return Object.class;
    }

    @Override
    public Item mold(Object object, Item item) {
        if (object != null) {
            Form<Object> form = this.formForClass(object.getClass());
            if (form != null) {
                return form.mold(object, item);
            }
            if (object instanceof String) {
                return this.moldString((String)object, item);
            }
            if (object instanceof Number) {
                return this.moldNumber((Number)object, item);
            }
            if (object instanceof Character) {
                return this.moldCharacter((Character)object, item);
            }
            if (object instanceof Boolean) {
                return this.moldBoolean((Boolean)object, item);
            }
            if (object instanceof ByteBuffer) {
                return this.moldByteBuffer((ByteBuffer)object, item);
            }
            if (object instanceof Map) {
                return this.moldMap((Map)object, item);
            }
            if (object instanceof Collection) {
                return this.moldCollection((Collection)object, item);
            }
            if (object instanceof Object[]) {
                return this.moldArray((Object[])object, item);
            }
            return Item.absent();
        }
        return Item.extant();
    }

    @Override
    public Item mold(Object object) {
        if (object != null) {
            Form<Object> form = this.formForClass(object.getClass());
            if (form != null) {
                return form.mold(object);
            }
            if (object instanceof String) {
                return this.moldString((String)object);
            }
            if (object instanceof Number) {
                return this.moldNumber((Number)object);
            }
            if (object instanceof Character) {
                return this.moldCharacter((Character)object);
            }
            if (object instanceof Boolean) {
                return this.moldBoolean((Boolean)object);
            }
            if (object instanceof ByteBuffer) {
                return this.moldByteBuffer((ByteBuffer)object);
            }
            if (object instanceof Map) {
                return this.moldMap((Map)object);
            }
            if (object instanceof Collection) {
                return this.moldCollection((Collection)object);
            }
            if (object instanceof Object[]) {
                return this.moldArray((Object[])object);
            }
            return Item.absent();
        }
        return Item.extant();
    }

    protected Item moldString(String object, Item item) {
        return Form.forString().mold(object, item);
    }

    protected Item moldString(String object) {
        return Form.forString().mold(object);
    }

    protected Item moldNumber(Number object, Item item) {
        return Form.forNumber().mold(object, item);
    }

    protected Item moldNumber(Number object) {
        return Form.forNumber().mold(object);
    }

    protected Item moldCharacter(Character object, Item item) {
        return Form.forCharacter().mold(object, item);
    }

    protected Item moldCharacter(Character object) {
        return Form.forCharacter().mold(object);
    }

    protected Item moldBoolean(Boolean object, Item item) {
        return Form.forBoolean().mold(object, item);
    }

    protected Item moldBoolean(Boolean object) {
        return Form.forBoolean().mold(object);
    }

    protected Item moldByteBuffer(ByteBuffer object, Item item) {
        return Form.forByteBuffer().mold(object, item);
    }

    protected Item moldByteBuffer(ByteBuffer object) {
        return Form.forByteBuffer().mold(object);
    }

    protected Item moldArray(Object[] object, Item item) {
        return Form.forArray(object.getClass().getComponentType(), this).mold(object, item);
    }

    protected Item moldArray(Object[] object) {
        return Form.forArray(object.getClass().getComponentType(), this).mold(object);
    }

    protected Item moldCollection(Collection<?> object, Item item) {
        return Form.forCollection(object.getClass(), this).mold(object, item);
    }

    protected Item moldCollection(Collection<?> object) {
        return Form.forCollection(object.getClass(), this).mold(object);
    }

    protected Item moldMap(Map<?, ?> object, Item item) {
        return Form.forMap(object.getClass(), this, this).mold(object, item);
    }

    protected Item moldMap(Map<?, ?> object) {
        return Form.forMap(object.getClass(), this, this).mold(object);
    }

    @Override
    public Object cast(Item item, Object object) {
        if (item instanceof Record) {
            return this.castRecord((Record)item, object);
        }
        if (item instanceof Text) {
            return this.castText((Text)item);
        }
        if (item instanceof Data) {
            return this.castData((Data)item);
        }
        if (item instanceof Num) {
            return this.castNum((Num)item);
        }
        if (item instanceof Bool) {
            return this.castBool((Bool)item);
        }
        return null;
    }

    @Override
    public Object cast(Item item) {
        if (item instanceof Record) {
            return this.castRecord((Record)item);
        }
        if (item instanceof Text) {
            return this.castText((Text)item);
        }
        if (item instanceof Data) {
            return this.castData((Data)item);
        }
        if (item instanceof Num) {
            return this.castNum((Num)item);
        }
        if (item instanceof Bool) {
            return this.castBool((Bool)item);
        }
        return null;
    }

    protected Object castRecord(Record value, Object object) {
        Form<Object> form = this.formForTag(value.tag());
        if (form != null) {
            return form.cast(value, object);
        }
        return null;
    }

    protected Object castRecord(Record value) {
        Form form = this.formForTag(value.tag());
        if (form != null) {
            return form.cast(value);
        }
        return null;
    }

    protected Object castText(Text value) {
        return Form.forString().cast(value);
    }

    protected Object castData(Data value) {
        return Form.forByteBuffer().cast(value);
    }

    protected Object castNum(Num value) {
        return Form.forNumber().cast(value);
    }

    protected Object castBool(Bool value) {
        return Form.forBoolean().cast(value);
    }

    public <T> Form<T> formForTag(String tag) {
        if (tag != null) {
            return (Form)this.tagForms.get((Object)tag);
        }
        return null;
    }

    public <T> Form<T> formForClass(Class<?> type) {
        Form form;
        do {
            form = (Form)this.classForms.get(type);
            type = type.getSuperclass();
        } while (form == null && type != null);
        return form;
    }

    public <T> Form<T> formForType(Type genericType) {
        if (genericType instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)genericType).getGenericComponentType();
            if (componentType instanceof TypeVariable) {
                componentType = ((TypeVariable)componentType).getBounds()[0];
            }
            if (componentType instanceof Class) {
                return Form.forArray((Class)componentType, this);
            }
        }
        if (genericType instanceof ParameterizedType) {
            genericType = ((ParameterizedType)genericType).getRawType();
        }
        if (genericType instanceof Class) {
            Class type = (Class)genericType;
            if (type.isArray()) {
                return Form.forArray(type.getComponentType(), this);
            }
            if (Map.class.isAssignableFrom(type)) {
                return Form.forMap(type, this, this);
            }
            if (Collection.class.isAssignableFrom(type)) {
                return Form.forCollection(type, this);
            }
            Form<T> form = this.formForClass(type);
            if (form != null) {
                return form;
            }
            form = Form.forClass(type);
            if (form != null) {
                return form;
            }
        }
        return this;
    }

    public PolyForm addForm(Form<?> newForm) {
        if (newForm instanceof PolyForm) {
            PolyForm that = (PolyForm)newForm;
            for (Map.Entry entry : that.classForms) {
                this.classForms = this.classForms.updated((Object)((Class)entry.getKey()), (Object)((Form)entry.getValue()));
            }
            for (Map.Entry entry : that.tagForms) {
                this.tagForms = this.tagForms.updated((Object)((String)entry.getKey()), (Object)((Form)entry.getValue()));
            }
        } else {
            String newTag;
            Class<?> newClass = newForm.type();
            if (!this.classForms.containsKey(newClass) && (newTag = newForm.tag()) != null) {
                this.classForms = this.classForms.updated(newClass, newForm);
                this.tagForms = this.tagForms.updated((Object)newTag, newForm);
            }
        }
        return this;
    }

    public PolyForm addForms(Form<?> ... newForms) {
        int n = newForms.length;
        for (int i = 0; i < n; ++i) {
            this.addForm(newForms[i]);
        }
        return this;
    }

    public PolyForm addClass(Class<?> newClass) {
        String newTag;
        Form newForm;
        if (!this.classForms.containsKey(newClass) && (newForm = Form.forClass(newClass)) != null && (newTag = newForm.tag()) != null) {
            this.classForms = this.classForms.updated(newClass, newForm);
            this.tagForms = this.tagForms.updated((Object)newTag, newForm);
        }
        return this;
    }

    public PolyForm addClasses(Class<?> ... newClasses) {
        int n = newClasses.length;
        for (int i = 0; i < n; ++i) {
            this.addClass(newClasses[i]);
        }
        return this;
    }

    public PolyForm addType(Type genericType) {
        if (genericType instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)genericType).getGenericComponentType();
            if (componentType instanceof TypeVariable) {
                componentType = ((TypeVariable)componentType).getBounds()[0];
            }
            if (componentType instanceof Class) {
                this.addClass((Class)componentType);
            }
        } else if (genericType instanceof ParameterizedType) {
            this.addTypes(((ParameterizedType)genericType).getActualTypeArguments());
        } else if (genericType instanceof Class) {
            Class type = (Class)genericType;
            if (type.isArray()) {
                this.addClass(type.getComponentType());
            } else {
                this.addClass(type);
            }
        }
        return this;
    }

    public PolyForm addTypes(Type ... newGenericTypes) {
        int n = newGenericTypes.length;
        for (int i = 0; i < n; ++i) {
            this.addType(newGenericTypes[i]);
        }
        return this;
    }

    public <T> ClassForm<T> reflectClassForm(ClassForm<T> classForm) {
        this.addForm(classForm);
        this.reflectFields(classForm, classForm.type());
        return classForm;
    }

    public <T> ClassForm<T> reflectClassForm(Class<?> type, String tag, T unit) {
        if (!type.isInterface() && (type.getModifiers() & 0x400) == 0 && !Form.isBuiltin(type)) {
            return this.reflectClassForm(new ClassForm<T>(type, tag, unit));
        }
        return null;
    }

    public <T> ClassForm<T> reflectClassForm(Class<?> type, String tag) {
        return this.reflectClassForm(type, tag, null);
    }

    public <T> ClassForm<T> reflectClassForm(Class<?> type) {
        String tag = this.reflectClassTag(type);
        return this.reflectClassForm(type, tag, null);
    }

    public <T> Form<T> reflectClass(Class<?> type) {
        if (!type.isInterface() && (type.getModifiers() & 0x400) == 0 && !Form.isBuiltin(type)) {
            for (Field field : type.getDeclaredFields()) {
                Kind kind = field.getAnnotation(Kind.class);
                if (kind == null) continue;
                if (!Form.class.isAssignableFrom(field.getType())) {
                    throw new FormException(field.toString());
                }
                int modifiers = field.getModifiers();
                if ((modifiers & 8) == 0) {
                    throw new FormException(field.toString());
                }
                field.setAccessible(true);
                try {
                    ClassForm<T> form = (ClassForm<T>)field.get(null);
                    if (form == null) {
                        form = this.reflectClassForm(type);
                        field.set(null, form);
                    }
                    return form;
                }
                catch (ReflectiveOperationException cause) {
                    throw new FormException(cause);
                }
            }
            for (Method method : type.getDeclaredMethods()) {
                Kind kind = method.getAnnotation(Kind.class);
                if (kind == null) continue;
                if (!Form.class.isAssignableFrom(method.getReturnType())) {
                    throw new FormException(method.toString());
                }
                if (method.getParameterTypes().length != 0) {
                    throw new FormException(method.toString());
                }
                int modifiers = method.getModifiers();
                if ((modifiers & 8) == 0) {
                    throw new FormException(method.toString());
                }
                method.setAccessible(true);
                try {
                    return (Form)method.invoke(null, new Object[0]);
                }
                catch (ReflectiveOperationException cause) {
                    throw new FormException(cause);
                }
            }
            return this.reflectClassForm(type);
        }
        return null;
    }

    public <T> Form<T> reflectClassName(String className) {
        try {
            return this.reflectClass(Class.forName(className));
        }
        catch (ClassNotFoundException cause) {
            throw new FormException(cause);
        }
    }

    public String reflectClassTag(Class<?> type) {
        Tag tag = type.getAnnotation(Tag.class);
        if (tag != null) {
            return tag.value();
        }
        return type.getSimpleName();
    }

    public <T> ClassForm<T> reflectField(ClassForm<T> classForm, Field field) {
        int modifiers = field.getModifiers();
        if ((modifiers & 0x88) == 0) {
            String name;
            if ((modifiers & 0x16) != 0 || modifiers == 0) {
                field.setAccessible(true);
            }
            Type fieldType = field.getGenericType();
            this.addType(fieldType);
            Header header = field.getAnnotation(Header.class);
            if (header != null) {
                String name2 = header.value();
                if (name2 == null || name2.length() == 0) {
                    name2 = field.getName();
                }
                SlotForm fieldForm = new SlotForm(field, Text.from(name2), this.formForType(fieldType));
                return classForm.putHeader(fieldForm);
            }
            Member member = field.getAnnotation(Member.class);
            String string = name = member != null ? member.value() : null;
            if (name == null || name.length() == 0) {
                name = field.getName();
            }
            SlotForm fieldForm = new SlotForm(field, Text.from(name), this.formForType(fieldType));
            return classForm.putMember(fieldForm);
        }
        return classForm;
    }

    public <T> ClassForm<T> reflectFields(ClassForm<T> classForm, Class<?> type) {
        if (type != null) {
            this.reflectFields(classForm, type.getSuperclass());
            Field[] fields = type.getDeclaredFields();
            int n = fields.length;
            for (int i = 0; i < n; ++i) {
                this.reflectField(classForm, fields[i]);
            }
        }
        return classForm;
    }

    public PolyForm clone() {
        return new PolyForm(this.unit, this.classForms, this.tagForms);
    }
}

