/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.func;

import swim.codec.Output;
import swim.structure.Func;
import swim.structure.Interpreter;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Slot;
import swim.structure.Text;
import swim.structure.Value;
import swim.structure.operator.InvokeOperator;
import swim.util.Murmur3;

public class LambdaFunc
extends Func {
    private static int hashSeed;
    final Value bindings;
    final Value template;

    public LambdaFunc(Value bindings, Value template) {
        this.bindings = bindings;
        this.template = template;
    }

    public final Value bindings() {
        return this.bindings;
    }

    public final Value template() {
        return this.template;
    }

    @Override
    public int precedence() {
        return 1;
    }

    @Override
    public Item invoke(Value args, Interpreter interpreter, InvokeOperator operator) {
        Value bindings = this.bindings;
        int arity = Math.max(1, bindings.length());
        Record params = Record.create(arity);
        int j = 0;
        for (int i = 0; i < arity; ++i) {
            Value arg;
            Item binding;
            Item item = bindings instanceof Record ? bindings.getItem(i) : (binding = i == 0 ? bindings : Item.absent());
            Value value = args instanceof Record ? args.getItem(j).toValue() : (arg = j == 0 ? args : Value.absent());
            if (binding instanceof Text && arg.isDistinct()) {
                params.add(Slot.of((Value)((Text)binding), arg));
                ++j;
                continue;
            }
            if (!(binding instanceof Slot)) continue;
            if (arg.isDistinct()) {
                params.add(((Slot)binding).updatedValue(arg));
            } else {
                params.add(binding);
            }
            ++j;
        }
        interpreter.pushScope(params);
        Item result = this.template.evaluate(interpreter);
        interpreter.popScope();
        return result;
    }

    @Override
    public int typeOrder() {
        return 50;
    }

    @Override
    public int compareTo(Item other) {
        if (other instanceof LambdaFunc) {
            return this.compareTo((LambdaFunc)other);
        }
        return Integer.compare(this.typeOrder(), other.typeOrder());
    }

    @Override
    int compareTo(LambdaFunc that) {
        int order = this.bindings.compareTo(that.bindings);
        if (order == 0) {
            order = this.template.compareTo(that.template);
        }
        return order;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof LambdaFunc) {
            LambdaFunc that = (LambdaFunc)other;
            return this.bindings.equals(that.bindings) && this.template.equals(that.template);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(LambdaFunc.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.bindings.hashCode()), (int)this.template.hashCode()));
    }

    @Override
    public void debug(Output<?> output) {
        output.debug((Object)this.bindings).write(46).write("lambda").write(40).debug((Object)this.template).write(41);
    }
}

