/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.selector;

import swim.codec.Output;
import swim.structure.Interpreter;
import swim.structure.Item;
import swim.structure.Selectee;
import swim.structure.Selector;
import swim.util.Murmur3;

public final class FilterSelector
extends Selector
implements Selectee<Item> {
    private static int hashSeed;
    final Selector predicate;
    final Selector then;

    public FilterSelector(Selector predicate, Selector then) {
        this.predicate = predicate;
        this.then = then;
    }

    public Selector predicate() {
        return this.predicate;
    }

    @Override
    public Selector then() {
        return this.then;
    }

    @Override
    public <T> T forSelected(Interpreter interpreter, Selectee<T> callback) {
        T selected = null;
        interpreter.willSelect(this);
        if (interpreter.scopeDepth() != 0 && this.filterSelected(interpreter)) {
            selected = this.then.forSelected(interpreter, callback);
        }
        interpreter.didSelect(this, selected);
        return selected;
    }

    @Override
    public Item mapSelected(Interpreter interpreter, Selectee<Item> transform) {
        interpreter.willTransform(this);
        Item result = interpreter.scopeDepth() != 0 ? (this.filterSelected(interpreter) ? this.then.mapSelected(interpreter, transform) : interpreter.peekScope().toValue()) : Item.absent();
        interpreter.didTransform(this, result);
        return result;
    }

    @Override
    public Item substitute(Interpreter interpreter) {
        Item then;
        Item predicate = this.predicate.substitute(interpreter);
        if (!(predicate instanceof Selector)) {
            predicate = this.predicate;
        }
        if (!((then = this.then.substitute(interpreter)) instanceof Selector)) {
            then = this.then;
        }
        return new FilterSelector((Selector)predicate, (Selector)then);
    }

    protected boolean filterSelected(Interpreter interpreter) {
        return this.predicate.forSelected(interpreter, this) != null;
    }

    @Override
    public Item selected(Interpreter interpreter) {
        return Item.extant();
    }

    @Override
    public Selector andThen(Selector then) {
        return new FilterSelector(this.predicate, this.then.andThen(then));
    }

    @Override
    public FilterSelector filter() {
        return this;
    }

    @Override
    public int typeOrder() {
        return 19;
    }

    @Override
    protected int compareTo(Selector that) {
        if (that instanceof FilterSelector) {
            return this.compareTo((FilterSelector)that);
        }
        return Integer.compare(this.typeOrder(), that.typeOrder());
    }

    @Override
    int compareTo(FilterSelector that) {
        int order = this.predicate.compareTo((Item)that.predicate);
        if (order == 0) {
            order = this.then.compareTo((Item)that.then);
        }
        return order;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof FilterSelector) {
            FilterSelector that = (FilterSelector)other;
            return this.predicate.equals(that.predicate) && this.then.equals(that.then);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(FilterSelector.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.predicate.hashCode()), (int)this.then.hashCode()));
    }

    @Override
    public void debugThen(Output<?> output) {
        output = output.write(46).write("filter").write(40).debug((Object)this.predicate).write(41);
        this.then.debugThen(output);
    }
}

