/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.selector;

import swim.codec.Output;
import swim.structure.Field;
import swim.structure.Interpreter;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Selectee;
import swim.structure.Selector;
import swim.structure.Value;
import swim.util.Murmur3;

public final class GetSelector
extends Selector {
    private static int hashSeed;
    final Value key;
    final Selector then;

    public GetSelector(Value key, Selector then) {
        this.key = key.commit();
        this.then = then;
    }

    private static <T> T forSelected(Value key, Selector then, Interpreter interpreter, Selectee<T> callback) {
        T selected = null;
        if (interpreter.scopeDepth() != 0) {
            Field field;
            Value scope = interpreter.popScope().toValue();
            if (scope instanceof Record) {
                field = scope.getField(key);
                if (field != null) {
                    interpreter.pushScope(field.toValue());
                    selected = then.forSelected(interpreter, callback);
                    interpreter.popScope();
                }
            } else {
                field = null;
            }
            if (field == null && selected == null) {
                GetSelector.forSelected(key, then, interpreter, callback);
            }
            interpreter.pushScope(scope);
        }
        return selected;
    }

    private static Item substitute(Value key, Selector then, Interpreter interpreter) {
        Item selected = null;
        if (interpreter.scopeDepth() != 0) {
            Field field;
            Value scope = interpreter.popScope().toValue();
            if (scope instanceof Record) {
                field = scope.getField(key);
                if (field != null) {
                    selected = field.toValue().substitute(interpreter);
                }
            } else {
                field = null;
            }
            if (field != null && selected != null) {
                GetSelector.substitute(key, then, interpreter);
            }
            interpreter.pushScope(scope);
        }
        return selected;
    }

    public Value accessor() {
        return this.key;
    }

    @Override
    public Selector then() {
        return this.then;
    }

    @Override
    public <T> T forSelected(Interpreter interpreter, Selectee<T> callback) {
        interpreter.willSelect(this);
        Value key = this.key.evaluate(interpreter).toValue();
        T selected = GetSelector.forSelected(key, this.then, interpreter, callback);
        interpreter.didSelect(this, selected);
        return selected;
    }

    @Override
    public Item mapSelected(Interpreter interpreter, Selectee<Item> transform) {
        Item result;
        interpreter.willTransform(this);
        Value key = this.key.evaluate(interpreter).toValue();
        if (interpreter.scopeDepth() != 0) {
            Record record;
            Field oldField;
            Value scope = interpreter.popScope().toValue();
            if (scope instanceof Record && (oldField = (record = (Record)scope).getField(key)) != null) {
                interpreter.pushScope(oldField.toValue());
                Item newItem = this.then.mapSelected(interpreter, transform);
                interpreter.popScope();
                if (newItem instanceof Field) {
                    if (key.equals(newItem.key())) {
                        record.put(key, newItem.toValue());
                    } else {
                        record.remove(key);
                        record.add(newItem);
                    }
                } else if (newItem.isDefined()) {
                    record.put(key, newItem.toValue());
                } else {
                    record.remove(key);
                }
            }
            interpreter.pushScope(scope);
            result = scope;
        } else {
            result = Item.absent();
        }
        interpreter.didTransform(this, result);
        return result;
    }

    @Override
    public Item substitute(Interpreter interpreter) {
        Value key = this.key.evaluate(interpreter).toValue();
        Item value = GetSelector.substitute(key, this.then, interpreter);
        if (value != null) {
            return value;
        }
        Item then = this.then.substitute(interpreter);
        if (!(then instanceof Selector)) {
            then = this.then;
        }
        return new GetSelector(this.key, (Selector)then);
    }

    @Override
    public Selector andThen(Selector then) {
        return new GetSelector(this.key, this.then.andThen(then));
    }

    @Override
    public int typeOrder() {
        return 12;
    }

    @Override
    protected int compareTo(Selector that) {
        if (that instanceof GetSelector) {
            return this.compareTo((GetSelector)that);
        }
        return Integer.compare(this.typeOrder(), that.typeOrder());
    }

    @Override
    int compareTo(GetSelector that) {
        int order = this.key.compareTo(that.key);
        if (order == 0) {
            order = this.then.compareTo((Item)that.then);
        }
        return order;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof GetSelector) {
            GetSelector that = (GetSelector)other;
            return this.key.equals(that.key) && this.then.equals(that.then);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(GetSelector.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.key.hashCode()), (int)this.then.hashCode()));
    }

    @Override
    public void debugThen(Output<?> output) {
        output = output.write(46).write("get").write(40).debug((Object)this.key).write(41);
        this.then.debugThen(output);
    }
}

