/*
 * Decompiled with CFR 0.152.
 */
package swim.structure;

import swim.structure.InterpreterException;
import swim.structure.InterpreterSettings;
import swim.structure.Item;
import swim.structure.Operator;
import swim.structure.Selector;

public class Interpreter {
    protected InterpreterSettings settings;
    Item[] scopeStack;
    int scopeDepth;

    protected Interpreter(InterpreterSettings settings, Item[] scopeStack, int scopeDepth) {
        this.settings = settings;
        this.scopeStack = scopeStack;
        this.scopeDepth = scopeDepth;
    }

    public Interpreter(InterpreterSettings settings) {
        this(settings, null, 0);
    }

    public Interpreter() {
        this(InterpreterSettings.standard(), null, 0);
    }

    static int expand(int n) {
        n = Math.max(32, n) - 1;
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return n + 1;
    }

    public final InterpreterSettings settings() {
        return this.settings;
    }

    public Interpreter settings(InterpreterSettings settings) {
        this.settings = settings;
        return this;
    }

    public final int scopeDepth() {
        return this.scopeDepth;
    }

    public Item peekScope() {
        int scopeDepth = this.scopeDepth;
        if (scopeDepth <= 0) {
            throw new InterpreterException("scope stack empty");
        }
        return this.scopeStack[scopeDepth - 1];
    }

    public Item getScope(int index) {
        if (index < 0 || index >= this.scopeDepth) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        return this.scopeStack[index];
    }

    public void pushScope(Item scope) {
        Item[] newScopeStack;
        int scopeDepth = this.scopeDepth;
        if (scopeDepth >= this.settings.maxScopeDepth) {
            throw new InterpreterException("scope stack overflow");
        }
        Item[] oldScopeStack = this.scopeStack;
        if (oldScopeStack == null || scopeDepth + 1 > oldScopeStack.length) {
            newScopeStack = new Item[Interpreter.expand(scopeDepth + 1)];
            if (oldScopeStack != null) {
                System.arraycopy(oldScopeStack, 0, newScopeStack, 0, scopeDepth);
            }
            this.scopeStack = newScopeStack;
        } else {
            newScopeStack = oldScopeStack;
        }
        newScopeStack[scopeDepth] = scope;
        this.scopeDepth = scopeDepth + 1;
    }

    public Item popScope() {
        int scopeDepth = this.scopeDepth;
        if (scopeDepth <= 0) {
            throw new InterpreterException("scope stack empty");
        }
        Item[] scopeStack = this.scopeStack;
        Item scope = scopeStack[scopeDepth - 1];
        scopeStack[scopeDepth - 1] = null;
        this.scopeDepth = scopeDepth - 1;
        return scope;
    }

    public Item swapScope(Item newScope) {
        int scopeDepth = this.scopeDepth;
        if (scopeDepth <= 0) {
            throw new InterpreterException("scope stack empty");
        }
        Item[] scopeStack = this.scopeStack;
        Item oldScope = scopeStack[scopeDepth - 1];
        scopeStack[scopeDepth - 1] = newScope;
        return oldScope;
    }

    public void willOperate(Operator operator) {
    }

    public void didOperate(Operator operator, Item result) {
    }

    public void willSelect(Selector selector) {
    }

    public void didSelect(Selector selector, Object result) {
    }

    public void willTransform(Selector selector) {
    }

    public void didTransform(Selector selector, Item result) {
    }
}

