/*
 * Decompiled with CFR 0.152.
 */
package swim.structure;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import swim.structure.Attr;
import swim.structure.Field;
import swim.structure.Interpreter;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.RecordMapView;
import swim.structure.Slot;
import swim.structure.Text;
import swim.structure.Value;

final class RecordMap
extends Record {
    Item[] array;
    Field[] table;
    int itemCount;
    int fieldCount;
    private static RecordMap empty;

    RecordMap(Item[] array, Field[] table, int itemCount, int fieldCount, int flags) {
        this.array = array;
        this.table = table;
        this.itemCount = itemCount;
        this.fieldCount = fieldCount;
        this.flags = flags;
    }

    @Override
    public boolean isEmpty() {
        return this.itemCount == 0;
    }

    @Override
    public int size() {
        return this.itemCount;
    }

    @Override
    public int fieldCount() {
        return this.fieldCount;
    }

    @Override
    public int valueCount() {
        return this.itemCount - this.fieldCount;
    }

    @Override
    public boolean isConstant() {
        Item[] array = this.array;
        int n = this.itemCount;
        for (int i = 0; i < n; ++i) {
            if (array[i].isConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String tag() {
        Item item;
        if (this.fieldCount > 0 && (item = this.array[0]) instanceof Attr) {
            return ((Attr)item).key.value;
        }
        return null;
    }

    @Override
    public Value target() {
        Value value = null;
        Record record = null;
        boolean modified = false;
        Item[] array = this.array;
        int n = this.itemCount;
        for (int i = 0; i < n; ++i) {
            Item item = array[i];
            if (item instanceof Attr) {
                modified = true;
                continue;
            }
            if (value == null && item instanceof Value) {
                value = (Value)item;
                continue;
            }
            if (record == null) {
                record = Record.create();
                if (value != null) {
                    record.add(value);
                }
            }
            record.add(item);
        }
        if (value == null) {
            return Value.extant();
        }
        if (record == null) {
            return value;
        }
        if (modified) {
            return record;
        }
        return this;
    }

    @Override
    public Item head() {
        if (this.itemCount > 0) {
            return this.array[0];
        }
        return Item.absent();
    }

    @Override
    public Record tail() {
        int n = this.itemCount;
        if (n > 0) {
            return new RecordMapView(this, 1, n);
        }
        return Record.empty();
    }

    @Override
    public Value body() {
        int n = this.itemCount;
        if (n > 2) {
            return new RecordMapView(this, 1, n).branch();
        }
        if (n == 2) {
            Item item = this.array[1];
            if (item instanceof Value) {
                return (Value)item;
            }
            return Record.of((Object)item);
        }
        return Value.absent();
    }

    @Override
    public boolean contains(Item item) {
        Item[] array = this.array;
        int n = this.itemCount;
        for (int i = 0; i < n; ++i) {
            if (!array[i].equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> items) {
        HashSet q = new HashSet(items);
        Item[] array = this.array;
        int n = this.itemCount;
        for (int i = 0; i < n && !q.isEmpty(); ++i) {
            q.remove(array[i]);
        }
        return q.isEmpty();
    }

    @Override
    public boolean containsKey(Value key) {
        return this.containsKey((Object)key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.containsKey((Object)key);
    }

    private boolean containsKey(Object key) {
        if (!(key instanceof Value) && !(key instanceof String)) {
            key = Value.fromObject(key);
        }
        if (this.fieldCount != 0) {
            Field field;
            int x;
            Field[] table = this.hashTable();
            int n = table.length;
            assert (n > 0);
            int i = x = Math.abs(key.hashCode() % n);
            while ((field = table[i]) != null) {
                if (field.keyEquals(key)) {
                    return true;
                }
                if ((i = (i + 1) % n) != x) continue;
            }
        }
        return false;
    }

    @Override
    public boolean containsValue(Value value) {
        if (this.fieldCount != 0) {
            for (Field field : this.hashTable()) {
                if (field == null || !field.value().equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int indexOf(Object object) {
        Item item = Item.fromObject(object);
        Item[] array = this.array;
        int n = this.itemCount;
        for (int i = 0; i < n; ++i) {
            if (!array[i].equals(item)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        Item item = Item.fromObject(object);
        Item[] array = this.array;
        for (int i = this.itemCount - 1; i >= 0; --i) {
            if (!array[i].equals(item)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Value get(Value key) {
        return this.get((Object)key);
    }

    @Override
    public Value get(String key) {
        return this.get((Object)key);
    }

    private Value get(Object key) {
        if (!(key instanceof Value) && !(key instanceof String)) {
            key = Value.fromObject(key);
        }
        if (this.fieldCount != 0) {
            Field field;
            int x;
            Field[] table = this.hashTable();
            int n = table.length;
            assert (n > 0);
            int i = x = Math.abs(key.hashCode() % n);
            while ((field = table[i]) != null) {
                if (field.keyEquals(key)) {
                    return field.value();
                }
                if ((i = (i + 1) % n) != x) continue;
            }
        }
        return Value.absent();
    }

    @Override
    public Value getAttr(Text key) {
        return this.getAttr((Object)key);
    }

    @Override
    public Value getAttr(String key) {
        return this.getAttr((Object)key);
    }

    private Value getAttr(Object key) {
        if (this.fieldCount != 0) {
            Field field;
            int x;
            Field[] table = this.hashTable();
            int n = table.length;
            assert (n > 0);
            int i = x = Math.abs(key.hashCode() % n);
            while ((field = table[i]) != null) {
                if (field instanceof Attr && field.keyEquals(key)) {
                    return field.value();
                }
                if ((i = (i + 1) % n) != x) continue;
            }
        }
        return Value.absent();
    }

    @Override
    public Value getSlot(Value key) {
        return this.getSlot((Object)key);
    }

    @Override
    public Value getSlot(String key) {
        return this.getSlot((Object)key);
    }

    private Value getSlot(Object key) {
        if (this.fieldCount != 0) {
            Field field;
            int x;
            Field[] table = this.hashTable();
            int n = table.length;
            assert (n > 0);
            int i = x = Math.abs(key.hashCode() % n);
            while ((field = table[i]) != null) {
                if (field instanceof Slot && field.keyEquals(key)) {
                    return field.value();
                }
                if ((i = (i + 1) % n) != x) continue;
            }
        }
        return Value.absent();
    }

    @Override
    public Field getField(Value key) {
        return this.getField((Object)key);
    }

    @Override
    public Field getField(String key) {
        return this.getField((Object)key);
    }

    private Field getField(Object key) {
        if (this.fieldCount != 0) {
            Field field;
            int x;
            Field[] table = this.hashTable();
            int n = table.length;
            assert (n > 0);
            int i = x = Math.abs(key.hashCode() % n);
            while ((field = table[i]) != null) {
                if (field.keyEquals(key)) {
                    return field;
                }
                if ((i = (i + 1) % n) != x) continue;
            }
        }
        return null;
    }

    @Override
    public Item get(int index) {
        if (index < 0 || index >= this.itemCount) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        return this.array[index];
    }

    @Override
    public Item getItem(int index) {
        if (index >= 0 && index < this.itemCount) {
            return this.array[index];
        }
        return Item.absent();
    }

    @Override
    public Value put(Value key, Value newValue) {
        return this.put((Object)key, newValue);
    }

    @Override
    public Value put(String key, Value newValue) {
        return this.put((Object)key, newValue);
    }

    private Value put(Object key, Value newValue) {
        if ((this.flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        if ((this.flags & 1) != 0) {
            if (this.fieldCount > 0) {
                return this.putAliased(key, newValue);
            }
            this.addAliased(new Slot(Value.fromObject(key), newValue));
            return Value.absent();
        }
        if (this.fieldCount > 0) {
            if (this.table != null) {
                return this.putMutable(key, newValue);
            }
            return this.updateMutable(key, newValue);
        }
        this.addMutable(new Slot(Value.fromObject(key), newValue));
        return Value.absent();
    }

    private Value putAliased(Object key, Value newValue) {
        int n = this.itemCount;
        Item[] oldArray = this.array;
        Item[] newArray = new Item[RecordMap.expand(n + 1)];
        for (int i = 0; i < n; ++i) {
            Item item = oldArray[i];
            if (item instanceof Field && item.keyEquals(key)) {
                Value oldValue = item.toValue();
                newArray[i] = ((Field)item).updatedValue(newValue);
                System.arraycopy(oldArray, ++i, newArray, i, n - i);
                this.array = newArray;
                this.table = null;
                this.flags &= 0xFFFFFFFE;
                return oldValue;
            }
            newArray[i] = item;
        }
        newArray[n] = new Slot(Value.fromObject(key), newValue);
        this.array = newArray;
        this.table = null;
        this.itemCount = n + 1;
        ++this.fieldCount;
        this.flags &= 0xFFFFFFFE;
        return Value.absent();
    }

    private Value putMutable(Object key, Value newValue) {
        Field field;
        int x;
        Field[] table = this.table;
        int n = table.length;
        assert (n > 0);
        int i = x = Math.abs(key.hashCode() % n);
        while ((field = table[i]) != null) {
            if (field.keyEquals(key)) {
                if (field.isMutable()) {
                    return field.setValue(newValue);
                }
                return this.updateMutable(key, newValue);
            }
            if ((i = (i + 1) % n) != x) continue;
        }
        field = new Slot(Value.fromObject(key), newValue);
        this.addMutable(field);
        RecordMap.put(table, field);
        return Value.absent();
    }

    private Value updateMutable(Object key, Value newValue) {
        Item[] array = this.array;
        int n = this.itemCount;
        for (int i = 0; i < n; ++i) {
            Item item = array[i];
            if (!(item instanceof Field) || !item.keyEquals(key)) continue;
            Value oldValue = item.toValue();
            array[i] = ((Field)item).updatedValue(newValue);
            this.table = null;
            return oldValue;
        }
        Slot field = new Slot(Value.fromObject(key), newValue);
        this.addMutable(field);
        RecordMap.put(this.table, field);
        return Value.absent();
    }

    @Override
    public Value putAttr(Text key, Value newValue) {
        return this.putAttr((Object)key, newValue);
    }

    @Override
    public Value putAttr(String key, Value newValue) {
        return this.putAttr((Object)key, newValue);
    }

    private Value putAttr(Object key, Value newValue) {
        if ((this.flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        if ((this.flags & 1) != 0) {
            if (this.fieldCount > 0) {
                return this.putAttrAliased(key, newValue);
            }
            this.addAliased(new Attr(Text.fromObject(key), newValue));
            return Value.absent();
        }
        if (this.fieldCount > 0) {
            if (this.table != null) {
                return this.putAttrMutable(key, newValue);
            }
            return this.updateAttrMutable(key, newValue);
        }
        this.addMutable(new Attr(Text.fromObject(key), newValue));
        return Value.absent();
    }

    private Value putAttrAliased(Object key, Value newValue) {
        int n = this.itemCount;
        Item[] oldArray = this.array;
        Item[] newArray = new Item[RecordMap.expand(n + 1)];
        for (int i = 0; i < n; ++i) {
            Item item = oldArray[i];
            if (item instanceof Field && item.keyEquals(key)) {
                Value oldValue = item.toValue();
                newArray[i] = new Attr(Text.fromObject(key), newValue);
                System.arraycopy(oldArray, ++i, newArray, i, n - i);
                this.array = newArray;
                this.table = null;
                this.flags &= 0xFFFFFFFE;
                return oldValue;
            }
            newArray[i] = item;
        }
        newArray[n] = new Attr(Text.fromObject(key), newValue);
        this.array = newArray;
        this.table = null;
        this.itemCount = n + 1;
        ++this.fieldCount;
        this.flags &= 0xFFFFFFFE;
        return Value.absent();
    }

    private Value putAttrMutable(Object key, Value newValue) {
        Field field;
        int x;
        Field[] table = this.table;
        int n = table.length;
        assert (n > 0);
        int i = x = Math.abs(key.hashCode() % n);
        while ((field = table[i]) != null) {
            if (field.keyEquals(key)) {
                if (field instanceof Attr && field.isMutable()) {
                    return field.setValue(newValue);
                }
                return this.updateAttrMutable(key, newValue);
            }
            if ((i = (i + 1) % n) != x) continue;
        }
        field = new Attr(Text.fromObject(key), newValue);
        this.add(field);
        RecordMap.put(table, field);
        return Value.absent();
    }

    private Value updateAttrMutable(Object key, Value newValue) {
        Item[] array = this.array;
        int n = this.itemCount;
        for (int i = 0; i < n; ++i) {
            Item item = array[i];
            if (!(item instanceof Field) || !item.keyEquals(key)) continue;
            Value oldValue = item.toValue();
            array[i] = new Attr(Text.fromObject(key), newValue);
            this.table = null;
            return oldValue;
        }
        Attr field = new Attr(Text.fromObject(key), newValue);
        this.add(field);
        RecordMap.put(this.table, field);
        return Value.absent();
    }

    @Override
    public Value putSlot(Value key, Value newValue) {
        return this.putSlot((Object)key, newValue);
    }

    @Override
    public Value putSlot(String key, Value newValue) {
        return this.putSlot((Object)key, newValue);
    }

    private Value putSlot(Object key, Value newValue) {
        if ((this.flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        if ((this.flags & 1) != 0) {
            if (this.fieldCount > 0) {
                return this.putSlotAliased(key, newValue);
            }
            this.addAliased(new Slot(Value.fromObject(key), newValue));
            return Value.absent();
        }
        if (this.fieldCount > 0) {
            if (this.table != null) {
                return this.putSlotMutable(key, newValue);
            }
            return this.updateSlotMutable(key, newValue);
        }
        this.addMutable(new Slot(Value.fromObject(key), newValue));
        return Value.absent();
    }

    private Value putSlotAliased(Object key, Value newValue) {
        int n = this.itemCount;
        Item[] oldArray = this.array;
        Item[] newArray = new Item[RecordMap.expand(n + 1)];
        for (int i = 0; i < n; ++i) {
            Item item = oldArray[i];
            if (item instanceof Field && item.keyEquals(key)) {
                Value oldValue = item.toValue();
                newArray[i] = new Slot(Value.fromObject(key), newValue);
                System.arraycopy(oldArray, ++i, newArray, i, n - i);
                this.array = newArray;
                this.table = null;
                this.flags &= 0xFFFFFFFE;
                return oldValue;
            }
            newArray[i] = item;
        }
        newArray[n] = new Slot(Value.fromObject(key), newValue);
        this.array = newArray;
        this.table = null;
        this.itemCount = n + 1;
        ++this.fieldCount;
        this.flags &= 0xFFFFFFFE;
        return Value.absent();
    }

    private Value putSlotMutable(Object key, Value newValue) {
        Field field;
        int x;
        Field[] table = this.table;
        int n = table.length;
        assert (n > 0);
        int i = x = Math.abs(key.hashCode() % n);
        while ((field = table[i]) != null) {
            if (field.keyEquals(key)) {
                if (field instanceof Slot && field.isMutable()) {
                    return field.setValue(newValue);
                }
                return this.updateSlotMutable(key, newValue);
            }
            if ((i = (i + 1) % n) != x) continue;
        }
        field = new Slot(Value.fromObject(key), newValue);
        this.add(field);
        RecordMap.put(table, field);
        return Value.absent();
    }

    private Value updateSlotMutable(Object key, Value newValue) {
        Item[] array = this.array;
        int n = this.itemCount;
        for (int i = 0; i < n; ++i) {
            Item item = array[i];
            if (!(item instanceof Field) || !item.keyEquals(key)) continue;
            Value oldValue = item.toValue();
            array[i] = new Slot(Value.fromObject(key), newValue);
            this.table = null;
            return oldValue;
        }
        Slot field = new Slot(Value.fromObject(key), newValue);
        this.add(field);
        RecordMap.put(this.table, field);
        return Value.absent();
    }

    @Override
    public Item setItem(int index, Item newItem) {
        if ((this.flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        if (index < 0 || index >= this.itemCount) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if ((this.flags & 1) != 0) {
            return this.setItemAliased(index, newItem);
        }
        return this.setItemMutable(index, newItem);
    }

    private Item setItemAliased(int index, Item newItem) {
        int n = this.itemCount;
        Item[] oldArray = this.array;
        Item[] newArray = new Item[RecordMap.expand(n)];
        System.arraycopy(oldArray, 0, newArray, 0, n);
        Item oldItem = oldArray[index];
        newArray[index] = newItem;
        this.array = newArray;
        this.table = null;
        if (newItem instanceof Field) {
            if (!(oldItem instanceof Field)) {
                ++this.fieldCount;
            }
        } else if (oldItem instanceof Field) {
            --this.fieldCount;
        }
        this.flags &= 0xFFFFFFFE;
        return oldItem;
    }

    private Item setItemMutable(int index, Item newItem) {
        Item[] array = this.array;
        Item oldItem = array[index];
        array[index] = newItem;
        if (newItem instanceof Field) {
            this.table = null;
            if (!(oldItem instanceof Field)) {
                ++this.fieldCount;
            }
        } else if (oldItem instanceof Field) {
            this.table = null;
            --this.fieldCount;
        }
        return oldItem;
    }

    @Override
    public Record updated(Value key, Value newValue) {
        return this.updated((Object)key, newValue);
    }

    @Override
    public Record updated(String key, Value newValue) {
        return this.updated((Object)key, newValue);
    }

    private Record updated(Object key, Value newValue) {
        RecordMap record;
        RecordMap recordMap = record = (this.flags & 2) == 0 ? this : this.branch();
        if ((record.flags & 1) != 0) {
            if (record.fieldCount > 0) {
                record.putAliased(key, newValue);
            } else {
                record.addAliased(new Slot(Value.fromObject(key), newValue));
            }
        } else if (record.fieldCount > 0) {
            if (record.table != null) {
                record.putMutable(key, newValue);
            } else {
                record.updateMutable(key, newValue);
            }
        } else {
            record.addMutable(new Slot(Value.fromObject(key), newValue));
        }
        return record;
    }

    @Override
    public Record updatedAttr(Text key, Value newValue) {
        return this.updatedAttr((Object)key, newValue);
    }

    @Override
    public Record updatedAttr(String key, Value newValue) {
        return this.updatedAttr((Object)key, newValue);
    }

    private Record updatedAttr(Object key, Value newValue) {
        RecordMap record;
        RecordMap recordMap = record = (this.flags & 2) == 0 ? this : this.branch();
        if ((record.flags & 1) != 0) {
            if (record.fieldCount > 0) {
                record.putAttrAliased(key, newValue);
            } else {
                record.addAliased(new Attr(Text.fromObject(key), newValue));
            }
        } else if (record.fieldCount > 0) {
            if (record.table != null) {
                record.putAttrMutable(key, newValue);
            } else {
                record.updateAttrMutable(key, newValue);
            }
        } else {
            record.addMutable(new Attr(Text.fromObject(key), newValue));
        }
        return record;
    }

    @Override
    public Record updatedSlot(Value key, Value newValue) {
        return this.updatedSlot((Object)key, newValue);
    }

    @Override
    public Record updatedSlot(String key, Value newValue) {
        return this.updatedSlot((Object)key, newValue);
    }

    private Record updatedSlot(Object key, Value newValue) {
        RecordMap record;
        RecordMap recordMap = record = (this.flags & 2) == 0 ? this : this.branch();
        if ((record.flags & 1) != 0) {
            if (record.fieldCount > 0) {
                record.putSlotAliased(key, newValue);
            } else {
                record.addAliased(new Slot(Value.fromObject(key), newValue));
            }
        } else if (record.fieldCount > 0) {
            if (record.table != null) {
                record.putSlotMutable(key, newValue);
            } else {
                record.updateSlotMutable(key, newValue);
            }
        } else {
            record.addMutable(new Slot(Value.fromObject(key), newValue));
        }
        return record;
    }

    @Override
    public boolean add(Item newItem) {
        if ((this.flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        if ((this.flags & 1) != 0) {
            return this.addAliased(newItem);
        }
        return this.addMutable(newItem);
    }

    private boolean addAliased(Item newItem) {
        int n = this.itemCount;
        Item[] oldArray = this.array;
        Item[] newArray = new Item[RecordMap.expand(n + 1)];
        if (oldArray != null) {
            System.arraycopy(oldArray, 0, newArray, 0, n);
        }
        newArray[n] = newItem;
        this.array = newArray;
        this.table = null;
        this.itemCount = n + 1;
        if (newItem instanceof Field) {
            ++this.fieldCount;
        }
        this.flags &= 0xFFFFFFFE;
        return true;
    }

    private boolean addMutable(Item newItem) {
        Item[] newArray;
        int n = this.itemCount;
        Item[] oldArray = this.array;
        if (oldArray == null || n + 1 > oldArray.length) {
            newArray = new Item[RecordMap.expand(n + 1)];
            if (oldArray != null) {
                System.arraycopy(oldArray, 0, newArray, 0, n);
            }
            this.array = newArray;
        } else {
            newArray = oldArray;
        }
        newArray[n] = newItem;
        this.itemCount = n + 1;
        if (newItem instanceof Field) {
            ++this.fieldCount;
            Field[] table = this.table;
            if (table != null && Math.max(table.length, table.length * 7 / 10) > n + 1) {
                RecordMap.put(table, (Field)newItem);
            } else {
                this.table = null;
            }
        }
        return true;
    }

    @Override
    public void add(int index, Item newItem) {
        if ((this.flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        if (index < 0 || index > this.itemCount) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (index == this.itemCount) {
            this.add(newItem);
        } else if ((this.flags & 1) != 0) {
            this.addAliased(index, newItem);
        } else {
            this.addMutable(index, newItem);
        }
    }

    private void addAliased(int index, Item newItem) {
        int n = this.itemCount;
        Item[] oldArray = this.array;
        Item[] newArray = new Item[RecordMap.expand(n + 1)];
        System.arraycopy(oldArray, 0, newArray, 0, index);
        System.arraycopy(oldArray, index, newArray, index + 1, n - index);
        newArray[index] = newItem;
        this.array = newArray;
        this.table = null;
        this.itemCount = n + 1;
        if (newItem instanceof Field) {
            ++this.fieldCount;
        }
        this.flags &= 0xFFFFFFFE;
    }

    private void addMutable(int index, Item newItem) {
        Item[] newArray;
        int n = this.itemCount;
        Item[] oldArray = this.array;
        if (n + 1 > oldArray.length) {
            newArray = new Item[RecordMap.expand(n + 1)];
            System.arraycopy(oldArray, 0, newArray, 0, index);
        } else {
            newArray = oldArray;
        }
        System.arraycopy(oldArray, index, newArray, index + 1, n - index);
        newArray[index] = newItem;
        this.array = newArray;
        this.itemCount = n + 1;
        if (newItem instanceof Field) {
            ++this.fieldCount;
            this.table = null;
        }
    }

    @Override
    public boolean addAll(Collection<? extends Item> newItems) {
        if ((this.flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        if ((this.flags & 1) != 0) {
            return this.addAllAliased(newItems);
        }
        return this.addAllMutable(newItems);
    }

    private boolean addAllAliased(Collection<? extends Item> newItems) {
        int k = newItems.size();
        if (k == 0) {
            return false;
        }
        int m = this.itemCount;
        int n = this.fieldCount;
        Item[] oldArray = this.array;
        Item[] newArray = new Item[RecordMap.expand(m + k)];
        if (oldArray != null) {
            System.arraycopy(oldArray, 0, newArray, 0, m);
        }
        Iterator<? extends Item> iterator = newItems.iterator();
        while (iterator.hasNext()) {
            Item newItem;
            newArray[m] = newItem = iterator.next();
            ++m;
            if (!(newItem instanceof Field)) continue;
            ++n;
        }
        this.array = newArray;
        this.table = null;
        this.itemCount = m;
        this.fieldCount = n;
        this.flags &= 0xFFFFFFFE;
        return true;
    }

    private boolean addAllMutable(Collection<? extends Item> newItems) {
        Item[] newArray;
        int k = newItems.size();
        if (k == 0) {
            return false;
        }
        int m = this.itemCount;
        int n = this.fieldCount;
        Item[] oldArray = this.array;
        if (oldArray == null || m + k > oldArray.length) {
            newArray = new Item[RecordMap.expand(m + k)];
            if (oldArray != null) {
                System.arraycopy(oldArray, 0, newArray, 0, m);
            }
        } else {
            newArray = oldArray;
        }
        Iterator<? extends Item> iterator = newItems.iterator();
        while (iterator.hasNext()) {
            Item newItem;
            newArray[m] = newItem = iterator.next();
            ++m;
            if (!(newItem instanceof Field)) continue;
            ++n;
            this.table = null;
        }
        this.array = newArray;
        this.itemCount = m;
        this.fieldCount = n;
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Item> newItems) {
        if ((this.flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        if (index < 0 || index > this.itemCount) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (index == this.itemCount) {
            return this.addAll(newItems);
        }
        if ((this.flags & 1) != 0) {
            return this.addAllAliased(index, newItems);
        }
        return this.addAllMutable(index, newItems);
    }

    private boolean addAllAliased(int index, Collection<? extends Item> newItems) {
        int k = newItems.size();
        if (k == 0) {
            return false;
        }
        int m = this.itemCount;
        int n = this.fieldCount;
        Item[] oldArray = this.array;
        Item[] newArray = new Item[RecordMap.expand(m + k)];
        if (oldArray != null) {
            System.arraycopy(oldArray, 0, newArray, 0, index);
            System.arraycopy(oldArray, index, newArray, index + k, m - index);
        }
        Iterator<? extends Item> iterator = newItems.iterator();
        while (iterator.hasNext()) {
            Item newItem;
            newArray[index] = newItem = iterator.next();
            ++index;
            if (!(newItem instanceof Field)) continue;
            ++n;
        }
        this.array = newArray;
        this.table = null;
        this.itemCount = m + k;
        this.fieldCount = n;
        this.flags &= 0xFFFFFFFE;
        return true;
    }

    private boolean addAllMutable(int index, Collection<? extends Item> newItems) {
        Item[] newArray;
        int k = newItems.size();
        if (k == 0) {
            return false;
        }
        int m = this.itemCount;
        int n = this.fieldCount;
        Item[] oldArray = this.array;
        if (oldArray == null || m + k > oldArray.length) {
            newArray = new Item[RecordMap.expand(m + k)];
            if (oldArray != null) {
                System.arraycopy(oldArray, 0, newArray, 0, index);
            }
        } else {
            newArray = oldArray;
        }
        if (oldArray != null) {
            System.arraycopy(oldArray, index, newArray, index + k, m - index);
        }
        Iterator<? extends Item> iterator = newItems.iterator();
        while (iterator.hasNext()) {
            Item newItem;
            newArray[index] = newItem = iterator.next();
            ++index;
            if (!(newItem instanceof Field)) continue;
            ++n;
            this.table = null;
        }
        this.array = newArray;
        this.itemCount = m + k;
        this.fieldCount = n;
        return true;
    }

    @Override
    public Item remove(int index) {
        if ((this.flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        if (index < 0 || index >= this.itemCount) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if ((this.flags & 1) != 0) {
            return this.removeAliased(index);
        }
        return this.removeMutable(index);
    }

    private Item removeAliased(int index) {
        int n = this.itemCount;
        Item[] oldArray = this.array;
        Item[] newArray = new Item[RecordMap.expand(n - 1)];
        Item oldItem = oldArray[index];
        System.arraycopy(oldArray, 0, newArray, 0, index);
        System.arraycopy(oldArray, index + 1, newArray, index, n - index - 1);
        this.array = newArray;
        this.table = null;
        this.itemCount = n - 1;
        if (oldItem instanceof Field) {
            --this.fieldCount;
        }
        this.flags &= 0xFFFFFFFE;
        return oldItem;
    }

    private Item removeMutable(int index) {
        int n = this.itemCount;
        Item[] array = this.array;
        Item oldItem = array[index];
        System.arraycopy(array, index + 1, array, index, n - index - 1);
        array[n - 1] = null;
        this.itemCount = n - 1;
        if (oldItem instanceof Field) {
            --this.fieldCount;
            this.table = null;
        }
        return oldItem;
    }

    @Override
    public boolean remove(Object object) {
        Item item = Item.fromObject(object);
        if ((this.flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        int index = this.indexOf(item);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeKey(Value key) {
        return this.removeKey((Object)key);
    }

    @Override
    public boolean removeKey(String key) {
        return this.removeKey((Object)key);
    }

    private boolean removeKey(Object key) {
        if ((this.flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        if ((this.flags & 1) != 0) {
            return this.removeKeyAliased(key);
        }
        return this.removeKeyMutable(key);
    }

    private boolean removeKeyAliased(Object key) {
        int n = this.itemCount;
        Item[] oldArray = this.array;
        Item[] newArray = new Item[RecordMap.expand(n)];
        for (int i = 0; i < n; ++i) {
            Item item = oldArray[i];
            if (item.keyEquals(key)) {
                System.arraycopy(oldArray, i + 1, newArray, i, n - i - 1);
                this.array = newArray;
                this.table = null;
                this.itemCount = n - 1;
                --this.fieldCount;
                this.flags &= 0xFFFFFFFE;
                return true;
            }
            newArray[i] = item;
        }
        return false;
    }

    private boolean removeKeyMutable(Object key) {
        int n = this.itemCount;
        Item[] array = this.array;
        for (int i = 0; i < n; ++i) {
            Item item = array[i];
            if (!item.keyEquals(key)) continue;
            System.arraycopy(array, i + 1, array, i, n - i - 1);
            array[n - 1] = null;
            this.table = null;
            this.itemCount = n - 1;
            --this.fieldCount;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> items) {
        if ((this.flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        if ((this.flags & 1) != 0) {
            return this.removeAllAliased(items);
        }
        return this.removeAllMutable(items);
    }

    private boolean removeAllAliased(Collection<?> items) {
        int i;
        int m = this.itemCount;
        int n = this.fieldCount;
        Item[] oldArray = this.array;
        Item[] newArray = new Item[RecordMap.expand(m)];
        int j = 0;
        for (i = 0; i < m; ++i) {
            Item item = oldArray[i];
            if (!items.contains(item)) {
                newArray[j] = item;
                ++j;
                continue;
            }
            if (!(item instanceof Field)) continue;
            --n;
        }
        if (i > j) {
            this.array = newArray;
            this.table = null;
            this.itemCount = j;
            this.fieldCount = n;
            this.flags &= 0xFFFFFFFE;
            return true;
        }
        return false;
    }

    private boolean removeAllMutable(Collection<?> items) {
        int i;
        int m = this.itemCount;
        int n = this.fieldCount;
        Item[] array = this.array;
        int j = 0;
        for (i = 0; i < m; ++i) {
            Item item = array[i];
            if (!items.contains(item)) {
                array[j] = item;
                ++j;
                continue;
            }
            if (!(item instanceof Field)) continue;
            --n;
            this.table = null;
        }
        if (i > j) {
            while (i > j) {
                array[--i] = null;
            }
            this.itemCount = j;
            this.fieldCount = n;
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> items) {
        if ((this.flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        if ((this.flags & 1) != 0) {
            return this.retainAllAliased(items);
        }
        return this.retainAllMutable(items);
    }

    private boolean retainAllAliased(Collection<?> items) {
        int i;
        int m = this.itemCount;
        int n = this.fieldCount;
        Item[] oldArray = this.array;
        Item[] newArray = new Item[RecordMap.expand(m)];
        int j = 0;
        for (i = 0; i < m; ++i) {
            Item item = oldArray[i];
            if (items.contains(item)) {
                newArray[j] = item;
                ++j;
                continue;
            }
            if (!(item instanceof Field)) continue;
            --n;
        }
        if (i > j) {
            this.array = newArray;
            this.table = null;
            this.itemCount = j;
            this.fieldCount = n;
            this.flags &= 0xFFFFFFFE;
            return true;
        }
        return false;
    }

    private boolean retainAllMutable(Collection<?> items) {
        int i;
        int m = this.itemCount;
        int n = this.fieldCount;
        Item[] array = this.array;
        int j = 0;
        for (i = 0; i < m; ++i) {
            Item item = array[i];
            if (items.contains(item)) {
                array[j] = item;
                ++j;
                continue;
            }
            if (!(item instanceof Field)) continue;
            --n;
            this.table = null;
        }
        if (i > j) {
            while (i > j) {
                array[--i] = null;
            }
            this.itemCount = j;
            this.fieldCount = n;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if ((this.flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        this.array = null;
        this.table = null;
        this.itemCount = 0;
        this.fieldCount = 0;
        this.flags = 0;
    }

    @Override
    public boolean isAliased() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isMutable() {
        return (this.flags & 2) == 0;
    }

    @Override
    public void alias() {
        this.flags |= 1;
    }

    @Override
    public RecordMap branch() {
        if ((this.flags & 3) == 0) {
            Item[] array = this.array;
            int n = this.itemCount;
            for (int i = 0; i < n; ++i) {
                array[i].alias();
            }
        }
        this.flags |= 1;
        return new RecordMap(this.array, this.table, this.itemCount, this.fieldCount, 1);
    }

    @Override
    public RecordMap commit() {
        if ((this.flags & 2) == 0) {
            this.flags |= 2;
            Item[] array = this.array;
            int n = this.itemCount;
            for (int i = 0; i < n; ++i) {
                array[i].commit();
            }
        }
        return this;
    }

    private Field[] hashTable() {
        int n = this.fieldCount;
        Field[] table = this.table;
        if (n != 0 && table == null) {
            table = new Field[RecordMap.expand(Math.max(n, n * 10 / 7))];
            int m = this.itemCount;
            Item[] array = this.array;
            for (int i = 0; i < m; ++i) {
                Item item = array[i];
                if (!(item instanceof Field)) continue;
                RecordMap.put(table, (Field)item);
            }
            this.table = table;
        }
        return table;
    }

    @Override
    public Record evaluate(Interpreter interpreter) {
        int n = this.itemCount;
        Item[] array = this.array;
        Record scope = Record.create(n);
        interpreter.pushScope(scope);
        boolean changed = false;
        for (int i = 0; i < n; ++i) {
            Item oldItem = array[i];
            Item newItem = oldItem.evaluate(interpreter);
            scope.add(newItem);
            if (oldItem == newItem) continue;
            changed = true;
        }
        interpreter.popScope();
        return changed ? scope : this;
    }

    @Override
    public Record substitute(Interpreter interpreter) {
        int n = this.itemCount;
        Item[] array = this.array;
        Record scope = Record.create(n);
        interpreter.pushScope(scope);
        boolean changed = false;
        for (int i = 0; i < n; ++i) {
            Item oldItem = array[i];
            Item newItem = oldItem.substitute(interpreter);
            scope.add(newItem);
            if (oldItem == newItem) continue;
            changed = true;
        }
        interpreter.popScope();
        return changed ? scope : this;
    }

    @Override
    public Item[] toArray() {
        int n = this.itemCount;
        Item[] array = new Item[n];
        System.arraycopy(this.array, 0, array, 0, n);
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int n = this.itemCount;
        if (array.length < n) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), n);
        }
        System.arraycopy(this.array, 0, array, 0, n);
        if (array.length > n) {
            array[n] = null;
        }
        return array;
    }

    @Override
    public Record subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.itemCount || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException(fromIndex + ", " + toIndex);
        }
        return new RecordMapView(this, fromIndex, toIndex);
    }

    public static RecordMap empty() {
        if (empty == null) {
            empty = new RecordMap(null, null, 0, 0, 3);
        }
        return empty;
    }

    public static RecordMap create() {
        return new RecordMap(null, null, 0, 0, 1);
    }

    public static RecordMap create(int initialCapacity) {
        return new RecordMap(new Item[initialCapacity], null, 0, 0, 0);
    }

    public static RecordMap of() {
        return new RecordMap(null, null, 0, 0, 1);
    }

    public static Record of(Object object) {
        Item item = Item.fromObject(object);
        Item[] array = new Item[]{item};
        return new RecordMap(array, null, 1, item instanceof Field ? 1 : 0, 0);
    }

    public static RecordMap of(Object ... objects) {
        int itemCount = objects.length;
        int fieldCount = 0;
        Item[] array = new Item[itemCount];
        for (int i = 0; i < itemCount; ++i) {
            Item item;
            array[i] = item = Item.fromObject(objects[i]);
            if (!(item instanceof Field)) continue;
            ++fieldCount;
        }
        return new RecordMap(array, null, itemCount, fieldCount, 0);
    }

    static void put(Field[] table, Field field) {
        int x;
        if (table == null) {
            return;
        }
        int n = table.length;
        int i = x = Math.abs(field.getKey().hashCode() % n);
        do {
            Field item;
            if ((item = table[i]) != null) {
                if (!field.keyEquals(item)) continue;
                table[i] = field;
                return;
            }
            table[i] = field;
            return;
        } while ((i = (i + 1) % n) != x);
        throw new AssertionError();
    }
}

