/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import swim.structure.Form;
import swim.structure.Record;
import swim.structure.Value;
import swim.structure.collections.ValueCollection;
import swim.structure.collections.ValueListIterator;

public class ValueList<T>
extends ValueCollection<T>
implements List<T> {
    public ValueList(List<? extends Value> inner, Form<T> valueForm) {
        super((Collection<? extends Value>)inner, valueForm);
    }

    @Override
    public List<Value> inner() {
        return (List)this.inner;
    }

    @Override
    public <T2> ValueList<T2> valueForm(Form<T2> valueForm) {
        return new ValueList<T2>((List)this.inner, valueForm);
    }

    @Override
    public <T2> ValueList<T2> valueClass(Class<T2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    @Override
    public int indexOf(Object object) {
        Class<?> valueType = this.valueForm.type();
        if (valueType == null || valueType.isInstance(object)) {
            Value value = this.valueForm.mold(object).toValue();
            return ((List)this.inner).indexOf(value);
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        Class<?> valueType = this.valueForm.type();
        if (valueType == null || valueType.isInstance(object)) {
            Value value = this.valueForm.mold(object).toValue();
            return ((List)this.inner).lastIndexOf(value);
        }
        return -1;
    }

    @Override
    public T get(int index) {
        Value value = (Value)((List)this.inner).get(index);
        Object object = this.valueForm.cast(value);
        if (object != null) {
            return object;
        }
        return this.valueForm.unit();
    }

    @Override
    public T set(int index, T newObject) {
        Value newValue = this.valueForm.mold(newObject).toValue();
        Value oldValue = ((List)this.inner).set(index, newValue);
        Object oldObject = this.valueForm.cast(oldValue);
        if (oldObject != null) {
            return oldObject;
        }
        return this.valueForm.unit();
    }

    @Override
    public void add(int index, T newObject) {
        Value newValue = this.valueForm.mold(newObject).toValue();
        ((List)this.inner).add(index, newValue);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> newObjects) {
        Iterator<T> those = newObjects.iterator();
        Class<?> valueType = this.valueForm.type();
        Record values = Record.create(newObjects.size());
        while (those.hasNext()) {
            T object = those.next();
            if (valueType != null && !valueType.isInstance(object)) continue;
            Value value = this.valueForm.mold(object).toValue();
            values.add(value);
        }
        return ((List)this.inner).addAll(index, values);
    }

    @Override
    public T remove(int index) {
        Value value = (Value)((List)this.inner).remove(index);
        Object object = this.valueForm.cast(value);
        if (object != null) {
            return object;
        }
        return this.valueForm.unit();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        if (this.valueForm != Form.forValue()) {
            return new ValueList<T>(((List)this.inner).subList(fromIndex, toIndex), this.valueForm);
        }
        return ((List)this.inner).subList(fromIndex, toIndex);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        if (this.valueForm != Form.forValue()) {
            return new ValueListIterator(((List)this.inner).listIterator(index), this.valueForm);
        }
        return ((List)this.inner).listIterator();
    }

    @Override
    public ListIterator<T> listIterator() {
        if (this.valueForm != Form.forValue()) {
            return new ValueListIterator(((List)this.inner).listIterator(), this.valueForm);
        }
        return ((List)this.inner).listIterator();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof List) {
            Iterator these = this.iterator();
            Iterator those = ((List)other).iterator();
            while (these.hasNext() && those.hasNext()) {
                Object x = these.next();
                Object y = those.next();
                if (x != null ? x.equals(y) : y == null) continue;
                return false;
            }
            return !these.hasNext() && !those.hasNext();
        }
        return false;
    }

    @Override
    public int hashCode() {
        Iterator these = this.iterator();
        int code = 0;
        while (these.hasNext()) {
            Object object = these.next();
            code = 31 * code + (object == null ? 0 : object.hashCode());
        }
        return code;
    }
}

