/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.operator;

import swim.codec.Output;
import swim.structure.Interpreter;
import swim.structure.Item;
import swim.structure.Operator;
import swim.structure.operator.BinaryOperator;
import swim.util.Murmur3;

public final class AndOperator
extends BinaryOperator {
    private static int hashSeed;

    public AndOperator(Item operand1, Item operand2) {
        super(operand1, operand2);
    }

    @Override
    public String operator() {
        return "&&";
    }

    @Override
    public int precedence() {
        return 4;
    }

    @Override
    public Item evaluate(Interpreter interpreter) {
        Item argument2;
        interpreter.willOperate(this);
        Item argument1 = this.operand1.evaluate(interpreter);
        Item result = argument1.isDefinite() ? (argument2 = this.operand2.evaluate(interpreter)) : argument1;
        interpreter.didOperate(this, result);
        return result;
    }

    @Override
    public Item substitute(Interpreter interpreter) {
        Item argument1 = this.operand1.substitute(interpreter);
        Item argument2 = this.operand2.substitute(interpreter);
        return argument1.and(argument2);
    }

    @Override
    public int typeOrder() {
        return 22;
    }

    @Override
    protected int compareTo(Operator that) {
        if (that instanceof AndOperator) {
            return this.compareTo((AndOperator)that);
        }
        return Integer.compare(this.typeOrder(), that.typeOrder());
    }

    @Override
    int compareTo(AndOperator that) {
        int order = this.operand1.compareTo(that.operand1);
        if (order == 0) {
            order = this.operand2.compareTo(that.operand2);
        }
        return order;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof AndOperator) {
            AndOperator that = (AndOperator)other;
            return this.operand1.equals(that.operand1) && this.operand2.equals(that.operand2);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(AndOperator.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.operand1.hashCode()), (int)this.operand2.hashCode()));
    }

    @Override
    public void debug(Output<?> output) {
        output.debug((Object)this.operand1).write(46).write("and").write(40).debug((Object)this.operand2).write(41);
    }
}

