/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.operator;

import swim.codec.Output;
import swim.structure.Interpreter;
import swim.structure.Item;
import swim.structure.Operator;
import swim.util.Murmur3;

public final class ConditionalOperator
extends Operator {
    private static int hashSeed;
    final Item ifTerm;
    final Item thenTerm;
    final Item elseTerm;

    public ConditionalOperator(Item ifTerm, Item thenTerm, Item elseTerm) {
        this.ifTerm = ifTerm.commit();
        this.thenTerm = thenTerm.commit();
        this.elseTerm = elseTerm.commit();
    }

    public Item ifTerm() {
        return this.ifTerm;
    }

    public Item thenTerm() {
        return this.thenTerm;
    }

    public Item elseTerm() {
        return this.elseTerm;
    }

    @Override
    public boolean isConstant() {
        return this.ifTerm.isConstant() && this.thenTerm.isConstant() && this.elseTerm.isConstant();
    }

    @Override
    public int precedence() {
        return 2;
    }

    @Override
    public Item evaluate(Interpreter interpreter) {
        Item elseTerm;
        Item thenTerm;
        interpreter.willOperate(this);
        Item ifTerm = this.ifTerm.evaluate(interpreter);
        Item result = ifTerm.isDefinite() ? (thenTerm = this.thenTerm.evaluate(interpreter)) : (elseTerm = this.elseTerm.evaluate(interpreter));
        interpreter.didOperate(this, result);
        return result;
    }

    @Override
    public Item substitute(Interpreter interpreter) {
        Item ifTerm = this.ifTerm.substitute(interpreter);
        Item thenTerm = this.thenTerm.substitute(interpreter);
        Item elseTerm = this.elseTerm.substitute(interpreter);
        return new ConditionalOperator(ifTerm, thenTerm, elseTerm);
    }

    @Override
    public int typeOrder() {
        return 20;
    }

    @Override
    protected int compareTo(Operator that) {
        if (that instanceof ConditionalOperator) {
            return this.compareTo((ConditionalOperator)that);
        }
        return Integer.compare(this.typeOrder(), that.typeOrder());
    }

    @Override
    int compareTo(ConditionalOperator that) {
        int order = this.ifTerm.compareTo(that.ifTerm);
        if (order == 0 && (order = this.thenTerm.compareTo(that.thenTerm)) == 0) {
            order = this.elseTerm.compareTo(that.elseTerm);
        }
        return order;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ConditionalOperator) {
            ConditionalOperator that = (ConditionalOperator)other;
            return this.ifTerm.equals(that.ifTerm) && this.thenTerm.equals(that.thenTerm) && this.elseTerm.equals(that.elseTerm);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(ConditionalOperator.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.ifTerm.hashCode()), (int)this.thenTerm.hashCode()), (int)this.elseTerm.hashCode()));
    }

    @Override
    public void debug(Output<?> output) {
        output.debug((Object)this.ifTerm).write(46).write("conditional").write(40).debug((Object)this.thenTerm).write(", ").debug((Object)this.elseTerm).write(41);
    }
}

