/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.selector;

import swim.codec.Output;
import swim.structure.Interpreter;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Selectee;
import swim.structure.Selector;
import swim.structure.Value;
import swim.util.Murmur3;

public final class GetItemSelector
extends Selector {
    private static int hashSeed;
    final Num index;
    final Selector then;

    public GetItemSelector(Num index, Selector then) {
        this.index = index;
        this.then = then;
    }

    public Num accessor() {
        return this.index;
    }

    @Override
    public Selector then() {
        return this.then;
    }

    @Override
    public <T> T forSelected(Interpreter interpreter, Selectee<T> callback) {
        T selected = null;
        interpreter.willSelect(this);
        int index = this.index.intValue();
        if (interpreter.scopeDepth() != 0) {
            Value scope = interpreter.popScope().toValue();
            if (scope instanceof Record && index < scope.length()) {
                Item item = scope.getItem(index);
                interpreter.pushScope(item);
                selected = this.then.forSelected(interpreter, callback);
                interpreter.popScope();
            }
            interpreter.pushScope(scope);
        }
        interpreter.didSelect(this, selected);
        return selected;
    }

    @Override
    public Item mapSelected(Interpreter interpreter, Selectee<Item> transform) {
        Item result;
        interpreter.willTransform(this);
        if (interpreter.scopeDepth() != 0) {
            Value scope = interpreter.popScope().toValue();
            int index = this.index.intValue();
            if (scope instanceof Record && index < scope.length()) {
                Item oldItem = scope.getItem(index);
                interpreter.pushScope(oldItem);
                Item newItem = this.then.mapSelected(interpreter, transform);
                interpreter.popScope();
                if (newItem.isDefined()) {
                    ((Record)scope).setItem(index, newItem);
                } else {
                    ((Record)scope).remove(index);
                }
            }
            interpreter.pushScope(scope);
            result = scope;
        } else {
            result = Item.absent();
        }
        interpreter.didTransform(this, result);
        return result;
    }

    @Override
    public Item substitute(Interpreter interpreter) {
        Item then;
        int index = this.index.intValue();
        if (interpreter.scopeDepth() != 0) {
            Item selected;
            Value scope = interpreter.popScope().toValue();
            if (scope instanceof Record && index < scope.length()) {
                Item item = scope.getItem(index);
                selected = item.substitute(interpreter);
            } else {
                selected = null;
            }
            interpreter.pushScope(scope);
            if (selected != null) {
                return selected;
            }
        }
        if (!((then = this.then.substitute(interpreter)) instanceof Selector)) {
            then = this.then;
        }
        return new GetItemSelector(this.index, (Selector)then);
    }

    @Override
    public Selector andThen(Selector then) {
        return new GetItemSelector(this.index, this.then.andThen(then));
    }

    @Override
    public int typeOrder() {
        return 14;
    }

    @Override
    protected int compareTo(Selector that) {
        if (that instanceof GetItemSelector) {
            return this.compareTo((GetItemSelector)that);
        }
        return Integer.compare(this.typeOrder(), that.typeOrder());
    }

    @Override
    int compareTo(GetItemSelector that) {
        int order = this.index.compareTo(that.index);
        if (order == 0) {
            order = this.then.compareTo((Item)that.then);
        }
        return order;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof GetItemSelector) {
            GetItemSelector that = (GetItemSelector)other;
            return this.index.equals((Object)that.index) && this.then.equals(that.then);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(GetItemSelector.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.index.hashCode()), (int)this.then.hashCode()));
    }

    @Override
    public void debugThen(Output<?> output) {
        output = output.write(46).write("getItem").write(40).debug((Object)this.index).write(41);
        this.then.debugThen(output);
    }
}

