/*
 * Decompiled with CFR 0.152.
 */
package swim.structure;

import java.math.BigDecimal;
import java.math.BigInteger;
import swim.codec.Format;
import swim.codec.Output;
import swim.structure.Num;
import swim.structure.NumF64;
import swim.structure.NumI32;
import swim.structure.NumI64;
import swim.structure.NumInt;
import swim.structure.Value;
import swim.util.HashGenCacheSet;

final class NumF32
extends Num {
    final float value;
    private static NumF32 positiveZero;
    private static NumF32 negativeZero;
    private static NumF32 positiveOne;
    private static NumF32 negativeOne;
    private static NumF32 nan;
    private static HashGenCacheSet<NumF32> cache;

    NumF32(float value) {
        this.value = value;
    }

    @Override
    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    @Override
    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    @Override
    public boolean isValidByte() {
        return (float)((byte)this.value) == this.value;
    }

    @Override
    public boolean isValidShort() {
        return (float)((short)this.value) == this.value;
    }

    @Override
    public boolean isValidInt() {
        return (float)((int)this.value) == this.value;
    }

    @Override
    public boolean isValidLong() {
        return (float)((long)this.value) == this.value;
    }

    @Override
    public boolean isValidFloat() {
        return true;
    }

    @Override
    public boolean isValidDouble() {
        return true;
    }

    @Override
    public boolean isValidInteger() {
        return this.integerValue().floatValue() == this.value;
    }

    @Override
    public String stringValue() {
        return Float.toString(this.value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public BigInteger integerValue() {
        return BigDecimal.valueOf(this.value).toBigInteger();
    }

    @Override
    public Number numberValue() {
        return Float.valueOf(this.value);
    }

    @Override
    public char charValue() {
        return (char)this.value;
    }

    @Override
    public boolean booleanValue() {
        return this.value != 0.0f;
    }

    @Override
    public Value bitwiseOr(Num that) {
        return Value.absent();
    }

    @Override
    public Value bitwiseXor(Num that) {
        return Value.absent();
    }

    @Override
    public Value bitwiseAnd(Num that) {
        return Value.absent();
    }

    @Override
    public Num plus(Num that) {
        if (that instanceof NumI32) {
            return NumF32.from(this.value + (float)((NumI32)that).value);
        }
        if (that instanceof NumI64) {
            return NumF32.from(this.value + (float)((NumI64)that).value);
        }
        if (that instanceof NumF32) {
            return NumF32.from(this.value + ((NumF32)that).value);
        }
        if (that instanceof NumF64) {
            return NumF64.from((double)this.value + ((NumF64)that).value);
        }
        if (that instanceof NumInt) {
            return NumF64.from((double)this.value + ((NumInt)that).value.doubleValue());
        }
        throw new AssertionError();
    }

    @Override
    public Num minus(Num that) {
        if (that instanceof NumI32) {
            return NumF32.from(this.value - (float)((NumI32)that).value);
        }
        if (that instanceof NumI64) {
            return NumF32.from(this.value - (float)((NumI64)that).value);
        }
        if (that instanceof NumF32) {
            return NumF32.from(this.value - ((NumF32)that).value);
        }
        if (that instanceof NumF64) {
            return NumF64.from((double)this.value - ((NumF64)that).value);
        }
        if (that instanceof NumInt) {
            return NumF64.from((double)this.value - ((NumInt)that).value.doubleValue());
        }
        throw new AssertionError();
    }

    @Override
    public Num times(Num that) {
        if (that instanceof NumI32) {
            return NumF32.from(this.value * (float)((NumI32)that).value);
        }
        if (that instanceof NumI64) {
            return NumF32.from(this.value * (float)((NumI64)that).value);
        }
        if (that instanceof NumF32) {
            return NumF32.from(this.value * ((NumF32)that).value);
        }
        if (that instanceof NumF64) {
            return NumF64.from((double)this.value * ((NumF64)that).value);
        }
        if (that instanceof NumInt) {
            return NumF64.from((double)this.value * ((NumInt)that).value.doubleValue());
        }
        throw new AssertionError();
    }

    @Override
    public Num divide(Num that) {
        if (that instanceof NumI32) {
            return NumF64.from((double)this.value / (double)((NumI32)that).value);
        }
        if (that instanceof NumI64) {
            return NumF64.from((double)this.value / (double)((NumI64)that).value);
        }
        if (that instanceof NumF32) {
            return NumF64.from((double)this.value / (double)((NumF32)that).value);
        }
        if (that instanceof NumF64) {
            return NumF64.from((double)this.value / ((NumF64)that).value);
        }
        if (that instanceof NumInt) {
            return NumF64.from((double)this.value / ((NumInt)that).value.doubleValue());
        }
        throw new AssertionError();
    }

    @Override
    public Num modulo(Num that) {
        if (that instanceof NumI32) {
            return NumF32.from(this.value % (float)((NumI32)that).value);
        }
        if (that instanceof NumI64) {
            return NumF32.from(this.value % (float)((NumI64)that).value);
        }
        if (that instanceof NumF32) {
            return NumF32.from(this.value % ((NumF32)that).value);
        }
        if (that instanceof NumF64) {
            return NumF64.from((double)this.value % ((NumF64)that).value);
        }
        if (that instanceof NumInt) {
            return NumF64.from((double)this.value % ((NumInt)that).value.doubleValue());
        }
        throw new AssertionError();
    }

    @Override
    public Value bitwiseNot() {
        return Value.absent();
    }

    @Override
    public Num negative() {
        return NumF32.from(-this.value);
    }

    @Override
    public Num inverse() {
        return NumF64.from(1.0 / (double)this.value);
    }

    @Override
    public Num abs() {
        return NumF32.from(Math.abs(this.value));
    }

    @Override
    public Num ceil() {
        return NumF32.from(Math.ceil(this.value));
    }

    @Override
    public Num floor() {
        return NumF32.from(Math.floor(this.value));
    }

    @Override
    public Num round() {
        return NumF32.from(Math.round(this.value));
    }

    @Override
    public Num sqrt() {
        return NumF64.from(Math.sqrt(this.value));
    }

    @Override
    public Num pow(Num that) {
        return NumF64.from(Math.pow(this.value, that.doubleValue()));
    }

    @Override
    public void display(Output<?> output) {
        Format.debugFloat((float)this.value, output);
    }

    static NumF32 positiveZero() {
        if (positiveZero == null) {
            positiveZero = new NumF32(0.0f);
        }
        return positiveZero;
    }

    static NumF32 negativeZero() {
        if (negativeZero == null) {
            negativeZero = new NumF32(-0.0f);
        }
        return negativeZero;
    }

    static NumF32 positiveOne() {
        if (positiveOne == null) {
            positiveOne = new NumF32(1.0f);
        }
        return positiveOne;
    }

    static NumF32 negativeOne() {
        if (negativeOne == null) {
            negativeOne = new NumF32(-1.0f);
        }
        return negativeOne;
    }

    static NumF32 nan() {
        if (nan == null) {
            nan = new NumF32(Float.NaN);
        }
        return nan;
    }

    public static NumF32 from(float value) {
        if (value == 0.0f) {
            if (Math.copySign(1.0f, value) == 1.0f) {
                return NumF32.positiveZero();
            }
            return NumF32.negativeZero();
        }
        if (value == 1.0f) {
            return NumF32.positiveOne();
        }
        if (value == -1.0f) {
            return NumF32.negativeOne();
        }
        if (Float.isNaN(value)) {
            return NumF32.nan();
        }
        return (NumF32)NumF32.cache().put((Object)new NumF32(value));
    }

    static HashGenCacheSet<NumF32> cache() {
        if (cache == null) {
            int cacheSize;
            try {
                cacheSize = Integer.parseInt(System.getProperty("swim.structure.num.f32.cache.size"));
            }
            catch (NumberFormatException e) {
                cacheSize = 16;
            }
            cache = new HashGenCacheSet(cacheSize);
        }
        return cache;
    }
}

