/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.collections;

import java.util.Iterator;
import swim.structure.Form;
import swim.structure.Value;

public class ValueIterator<T>
implements Iterator<T> {
    protected Iterator<Value> inner;
    protected Form<T> valueForm;

    public ValueIterator(Iterator<? extends Value> inner, Form<T> valueForm) {
        this.inner = inner;
        this.valueForm = valueForm;
    }

    public Iterator<Value> inner() {
        return this.inner;
    }

    public Form<T> valueForm() {
        return this.valueForm;
    }

    public <T2> ValueIterator<T2> valueForm(Form<T2> valueForm) {
        return new ValueIterator<T2>(this.inner, valueForm);
    }

    public <T2> ValueIterator<T2> valueClass(Class<T2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    @Override
    public boolean hasNext() {
        return this.inner.hasNext();
    }

    @Override
    public T next() {
        Value value = this.inner.next();
        T object = this.valueForm.cast(value);
        if (object != null) {
            return object;
        }
        return this.valueForm.unit();
    }

    @Override
    public void remove() {
        this.inner.remove();
    }
}

