/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.form;

import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Value;

public final class ByteForm
extends Form<Byte> {
    final Byte unit;

    public ByteForm(Byte unit) {
        this.unit = unit;
    }

    @Override
    public Byte unit() {
        return this.unit;
    }

    @Override
    public Form<Byte> unit(Byte unit) {
        return new ByteForm(unit);
    }

    @Override
    public Class<Byte> type() {
        return Byte.class;
    }

    @Override
    public Item mold(Byte value) {
        if (value != null) {
            return Num.from(value.byteValue());
        }
        return Item.extant();
    }

    @Override
    public Byte cast(Item item) {
        Value value = item.target();
        try {
            return value.byteValue();
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }
}

