/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.selector;

import java.util.ListIterator;
import swim.codec.Output;
import swim.structure.Attr;
import swim.structure.Field;
import swim.structure.Interpreter;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Selectee;
import swim.structure.Selector;
import swim.structure.Slot;
import swim.structure.Text;
import swim.structure.Value;
import swim.util.Murmur3;

public final class KeysSelector
extends Selector {
    final Selector then;
    private static int hashSeed;

    public KeysSelector(Selector then) {
        this.then = then;
    }

    @Override
    public Selector then() {
        return this.then;
    }

    @Override
    public <T> T forSelected(Interpreter interpreter, Selectee<T> callback) {
        T selected = null;
        interpreter.willSelect(this);
        if (interpreter.scopeDepth() != 0) {
            Item scope = interpreter.popScope();
            if (scope instanceof Record) {
                ListIterator<Item> children = ((Record)scope).listIterator();
                while (selected == null && children.hasNext()) {
                    Item child = children.next();
                    if (!(child instanceof Field)) continue;
                    interpreter.pushScope(child.key());
                    selected = this.then.forSelected(interpreter, callback);
                    interpreter.popScope();
                }
            } else if (scope instanceof Field) {
                interpreter.pushScope(scope.key());
                selected = this.then.forSelected(interpreter, callback);
                interpreter.popScope();
            }
            interpreter.pushScope(scope);
        }
        interpreter.didSelect(this, selected);
        return selected;
    }

    @Override
    public Item mapSelected(Interpreter interpreter, Selectee<Item> transform) {
        Item result;
        interpreter.willTransform(this);
        if (interpreter.scopeDepth() != 0) {
            Item scope = interpreter.popScope();
            if (scope instanceof Record) {
                ListIterator<Item> children = ((Record)scope).listIterator();
                while (children.hasNext()) {
                    Item child = children.next();
                    if (!(child instanceof Field)) continue;
                    Value oldKey = child.key();
                    interpreter.pushScope(oldKey);
                    Value newKey = this.then.mapSelected(interpreter, transform).toValue();
                    interpreter.popScope();
                    if (newKey.isDefined()) {
                        if (oldKey == newKey) continue;
                        if (scope instanceof Attr && newKey instanceof Text) {
                            children.set(Attr.of((Text)newKey, scope.toValue()));
                            continue;
                        }
                        children.set(Slot.of(newKey, scope.toValue()));
                        continue;
                    }
                    children.remove();
                }
            } else if (scope instanceof Field) {
                Value oldKey = scope.key();
                interpreter.pushScope(oldKey);
                Value newKey = this.then.mapSelected(interpreter, transform).toValue();
                interpreter.popScope();
                if (newKey.isDefined()) {
                    if (oldKey != newKey) {
                        scope = scope instanceof Attr && newKey instanceof Text ? Attr.of((Text)newKey, scope.toValue()) : Slot.of(newKey, scope.toValue());
                    }
                } else {
                    scope = Item.absent();
                }
            }
            interpreter.pushScope(scope);
            result = scope;
        } else {
            result = Item.absent();
        }
        interpreter.didTransform(this, result);
        return result;
    }

    @Override
    public Item substitute(Interpreter interpreter) {
        Item then = this.then.substitute(interpreter);
        if (!(then instanceof Selector)) {
            then = this.then;
        }
        return new KeysSelector((Selector)then);
    }

    @Override
    public Selector andThen(Selector then) {
        return new KeysSelector(this.then.andThen(then));
    }

    @Override
    public int typeOrder() {
        return 15;
    }

    @Override
    protected int compareTo(Selector that) {
        if (that instanceof KeysSelector) {
            return this.compareTo((KeysSelector)that);
        }
        return Integer.compare(this.typeOrder(), that.typeOrder());
    }

    @Override
    int compareTo(KeysSelector that) {
        return this.then.compareTo((Item)that.then);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof KeysSelector) {
            KeysSelector that = (KeysSelector)other;
            return this.then.equals(that.then);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(KeysSelector.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.then.hashCode()));
    }

    @Override
    public void debugThen(Output<?> output) {
        output = output.write(46).write("keys").write(40).write(41);
        this.then.debugThen(output);
    }
}

